/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.accessservices.assetmanager.server.GlossaryExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class DataAssetExchangeRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryExchangeRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createAsset(String serverName, String userId, boolean assetManagerIsHome, AssetRequestBody requestBody) {
        String methodName = "createAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "createAsset");
                response.setGUID(handler.createAsset(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAsset", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createAssetFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createAssetFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createAssetFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createAssetFromTemplate");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "createAssetFromTemplate");
                response.setGUID(handler.createAssetFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), templateGUID, requestBody.getElementProperties(), "createAssetFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createAssetFromTemplate", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createAssetFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAsset(String serverName, String userId, String assetGUID, boolean isMergeUpdate, AssetRequestBody requestBody) {
        String methodName = "updateAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "updateAsset");
                handler.updateAsset(userId, requestBody.getMetadataCorrelationProperties(), assetGUID, isMergeUpdate, requestBody.getElementProperties(), "updateAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAsset", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishAsset(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "publishAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "publishAsset");
            handler.publishAsset(userId, assetGUID, "publishAsset");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "publishAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawAsset(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "withdrawAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "withdrawAsset");
            handler.withdrawAsset(userId, assetGUID, "withdrawAsset");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "withdrawAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeAsset(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "removeAsset");
            handler.removeAsset(userId, requestBody, assetGUID, "removeAsset");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setAssetAsReferenceData(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "setAssetAsReferenceData");
            handler.setAssetAsReferenceData(userId, assetGUID, "setAssetAsReferenceData");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "setAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetAsReferenceData(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "clearAssetAsReferenceData");
            handler.clearAssetAsReferenceData(userId, assetGUID, "clearAssetAsReferenceData");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "clearAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse findAssets(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "findAssets");
                response.setElementList(handler.findAssets(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, "findAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findAssets", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse getAssetsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "getAssetsByName");
            if (requestBody != null) {
                response.setElementList(handler.getAssetsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, "getAssetsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsByName", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse getAssetsForAssetManager(String serverName, String userId, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getAssetsForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsForAssetManager");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsForAssetManager");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "getAssetsForAssetManager");
                response.setElementList(handler.getAssetsForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, "getAssetsForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetsForAssetManager", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetsForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementResponse getAssetByGUID(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getAssetByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetByGUID");
        AssetElementResponse response = new AssetElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetByGUID");
            DataAssetExchangeHandler handler = instanceHandler.getDataAsseExchangeHandler(userId, serverName, "getAssetByGUID");
            if (requestBody != null) {
                response.setElement(handler.getAssetByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetGUID, "getAssetByGUID"));
            } else {
                response.setElement(handler.getAssetByGUID(userId, null, null, assetGUID, "getAssetByGUID"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

