/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessConverter<B>
extends AssetManagerOMASConverter<B> {
    public ProcessConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ProcessElement) {
                ProcessElement bean = (ProcessElement)returnBean;
                ProcessProperties processProperties = new ProcessProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    processProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    processProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    processProperties.setTechnicalName(this.removeName(instanceProperties));
                    processProperties.setTechnicalDescription(this.removeDescription(instanceProperties));
                    processProperties.setOwner(this.removeOwner(instanceProperties));
                    processProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
                    processProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
                    processProperties.setFormula(this.removeFormula(instanceProperties));
                    processProperties.setImplementationLanguage(this.removeImplementationLanguage(instanceProperties));
                    processProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    processProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                    processProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                    processProperties.setOwner(this.getOwner(instanceProperties));
                    processProperties.setOwnerCategory(this.getOwnerCategoryFromProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                    processProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
                    processProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
                    processProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
                    bean.setProcessProperties(processProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

