/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeConverter<B>
extends AssetManagerOMASConverter<B> {
    public SchemaAttributeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof SchemaAttributeElement) {
                SchemaAttributeElement bean = (SchemaAttributeElement)returnBean;
                SchemaAttributeProperties schemaAttributeProperties = new SchemaAttributeProperties();
                if (schemaAttributeEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    schemaAttributeProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    schemaAttributeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    schemaAttributeProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    schemaAttributeProperties.setDescription(this.removeDescription(instanceProperties));
                    schemaAttributeProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
                    schemaAttributeProperties.setElementPosition(this.removePosition(instanceProperties));
                    schemaAttributeProperties.setMinCardinality(this.removeMinCardinality(instanceProperties));
                    schemaAttributeProperties.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
                    schemaAttributeProperties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
                    schemaAttributeProperties.setOrderedValues(this.removeOrderedValues(instanceProperties));
                    schemaAttributeProperties.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
                    schemaAttributeProperties.setMinimumLength(this.removeMinimumLength(instanceProperties));
                    schemaAttributeProperties.setLength(this.removeLength(instanceProperties));
                    schemaAttributeProperties.setPrecision(this.removePrecision(instanceProperties));
                    schemaAttributeProperties.setIsNullable(this.removeIsNullable(instanceProperties));
                    schemaAttributeProperties.setNativeJavaClass(this.removeNativeClass(instanceProperties));
                    schemaAttributeProperties.setAliases(this.removeAliases(instanceProperties));
                    schemaAttributeProperties.setSortOrder(this.removeSortOrder(instanceProperties));
                    if (schemaType instanceof SchemaTypeElement) {
                        schemaAttributeProperties.setSchemaType(((SchemaTypeElement)schemaType).getSchemaTypeProperties());
                    }
                    bean.setSchemaAttributeProperties(schemaAttributeProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

