/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ControlFlowConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.DataFlowConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.LineageMappingConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.PortConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ProcessCallConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProcessHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessExchangeHandler
extends ExchangeHandlerBase {
    private ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> processHandler;
    private static final String processGUIDParameterName = "processGUID";
    private static final String portGUIDParameterName = "portGUID";

    public ProcessExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.processHandler = new ProcessHandler(new ProcessConverter(repositoryHelper, serviceName, serverName), ProcessElement.class, new PortConverter(repositoryHelper, serviceName, serverName), PortElement.class, new DataFlowConverter(repositoryHelper, serviceName, serverName), DataFlowElement.class, new ControlFlowConverter(repositoryHelper, serviceName, serverName), ControlFlowElement.class, new ProcessCallConverter(repositoryHelper, serviceName, serverName), ProcessCallElement.class, new LineageMappingConverter(repositoryHelper, serviceName, serverName), LineageMappingElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToProcesses(String userId, String assetManagerGUID, String assetManagerName, List<ProcessElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToPorts(String userId, String assetManagerGUID, String assetManagerName, List<PortElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    private InstanceStatus getInstanceStatus(ProcessStatus status) {
        if (status != null) {
            switch (status) {
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
            }
        }
        return InstanceStatus.UNKNOWN;
    }

    public String createProcess(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, ProcessProperties processProperties, ProcessStatus initialStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUID;
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", methodName);
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", methodName);
        String typeName = "DeployedSoftwareComponent";
        if (processProperties.getTypeName() != null) {
            typeName = processProperties.getTypeName();
        }
        int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
        if (processProperties.getOwnerCategory() != null) {
            ownerCategory = processProperties.getOwnerCategory().getOpenTypeOrdinal();
        }
        if ((processGUID = this.processHandler.createProcess(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getTechnicalDescription(), processProperties.getFormula(), processProperties.getImplementationLanguage(), processProperties.getZoneMembership(), processProperties.getOwner(), ownerCategory, processProperties.getOriginOrganizationGUID(), processProperties.getOriginBusinessCapabilityGUID(), processProperties.getOtherOriginValues(), processProperties.getAdditionalProperties(), typeName, processProperties.getExtendedProperties(), this.getInstanceStatus(initialStatus), methodName)) != null) {
            this.maintainSupplementaryProperties(userId, processGUID, processProperties.getQualifiedName(), (SupplementaryProperties)processProperties, false, methodName);
            this.createExternalIdentifier(userId, processGUID, processGUIDParameterName, "Asset", correlationProperties, methodName);
        }
        return processGUID;
    }

    public String createProcessFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String processGUID = this.processHandler.createProcessFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, "templateGUID", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (processGUID != null) {
            this.createExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, methodName);
        }
        return processGUID;
    }

    public void updateProcess(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, boolean isMergeUpdate, ProcessProperties processProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = processGUIDParameterName;
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        String typeName = "DeployedSoftwareComponent";
        if (processProperties.getTypeName() != null) {
            typeName = processProperties.getTypeName();
        }
        int ownerCategory = OwnerCategory.USER_ID.getOpenTypeOrdinal();
        if (processProperties.getOwnerCategory() != null) {
            ownerCategory = processProperties.getOwnerCategory().getOpenTypeOrdinal();
        }
        this.processHandler.updateProcess(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, isMergeUpdate, processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getTechnicalDescription(), processProperties.getFormula(), processProperties.getImplementationLanguage(), processProperties.getZoneMembership(), processProperties.getOwner(), ownerCategory, processProperties.getOriginOrganizationGUID(), processProperties.getOriginBusinessCapabilityGUID(), processProperties.getOtherOriginValues(), processProperties.getAdditionalProperties(), typeName, processProperties.getExtendedProperties(), methodName);
        this.maintainSupplementaryProperties(userId, processGUID, processProperties.getQualifiedName(), (SupplementaryProperties)processProperties, isMergeUpdate, methodName);
    }

    public void updateProcessStatus(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, ProcessStatus processStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "processStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)processStatus, "processStatus", methodName);
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Asset", correlationProperties, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        this.processHandler.updateProcessStatus(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, this.getInstanceStatus(processStatus), "processStatus", methodName);
    }

    public void setupProcessParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", methodName);
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        int containmentTypeOrdinal = ProcessContainmentType.USED.getOpenTypeOrdinal();
        if (containmentType != null) {
            containmentTypeOrdinal = containmentType.getOpenTypeOrdinal();
        }
        this.processHandler.setupProcessParent(userId, externalSourceGUID, externalSourceName, parentProcessGUID, "parentProcessGUID", childProcessGUID, "childProcessGUID", containmentTypeOrdinal, methodName);
    }

    public void clearProcessParent(String userId, String assetManagerGUID, String assetManagerName, String parentProcessGUID, String childProcessGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", methodName);
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", methodName);
        this.processHandler.clearProcessParent(userId, assetManagerGUID, assetManagerName, parentProcessGUID, "parentProcessGUID", childProcessGUID, "childProcessGUID", methodName);
    }

    public void publishProcess(String userId, String processGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.processHandler.publishProcess(userId, processGUID, processGUIDParameterName, methodName);
    }

    public void withdrawProcess(String userId, String processGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.processHandler.withdrawProcess(userId, processGUID, processGUIDParameterName, methodName);
    }

    public void removeProcess(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, methodName);
        this.processHandler.removeProcess(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, methodName);
    }

    public List<ProcessElement> findProcesses(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.findProcesses(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<ProcessElement> getProcessesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String processEntityParameterName = "processEntity";
        String processEntityGUIDParameterName = "processEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ProcessElement> results = new ArrayList<ProcessElement>();
        List processEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareServerCapability", "Process", startFrom, validatedPageSize, methodName);
        if (processEntities != null) {
            for (EntityDetail processEntity : processEntities) {
                ProcessElement processElement;
                if (processEntity == null || (processElement = (ProcessElement)this.processHandler.getBeanFromEntity(userId, processEntity, "processEntity", methodName)) == null) continue;
                processElement.setCorrelationHeaders(this.getCorrelationProperties(userId, processEntity.getGUID(), "processEntity.getGUID()", "Asset", assetManagerGUID, assetManagerName, methodName));
                results.add(processElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<ProcessElement> getProcessesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List results = this.processHandler.getProcessesByName(userId, name, nameParameterName, startFrom, validatedPageSize, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public ProcessElement getProcessByGUID(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        ProcessElement element = (ProcessElement)this.processHandler.getProcessByGUID(userId, processGUID, processGUIDParameterName, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, methodName));
        }
        return element;
    }

    public ProcessElement getProcessParent(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        ProcessElement element = (ProcessElement)this.processHandler.getProcessParent(userId, processGUID, processGUIDParameterName, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, methodName));
        }
        return element;
    }

    public List<ProcessElement> getSubProcesses(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List results = this.processHandler.getSubProcesses(userId, processGUID, processGUIDParameterName, startFrom, validatedPageSize, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public String createPort(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String processGUID, PortProperties portProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUID;
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", methodName);
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        String typeName = "Port";
        if (portProperties.getTypeName() != null) {
            typeName = portProperties.getTypeName();
        }
        int portType = PortType.OTHER.getOpenTypeOrdinal();
        if (portProperties.getPortType() != null) {
            portType = portProperties.getPortType().getOpenTypeOrdinal();
        }
        if ((portGUID = this.processHandler.createPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portProperties.getQualifiedName(), portProperties.getDisplayName(), portType, portProperties.getAdditionalProperties(), typeName, portProperties.getExtendedProperties(), methodName)) != null) {
            this.createExternalIdentifier(userId, portGUID, portGUIDParameterName, "Port", correlationProperties, methodName);
        }
        return portGUID;
    }

    public void updatePort(String userId, MetadataCorrelationProperties correlationProperties, String portGUID, PortProperties portProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", methodName);
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", methodName);
        String typeName = "Port";
        if (portProperties.getTypeName() != null) {
            typeName = portProperties.getTypeName();
        }
        this.validateExternalIdentifier(userId, portGUID, portGUIDParameterName, typeName, correlationProperties, methodName);
        int portType = PortType.OTHER.getOpenTypeOrdinal();
        if (portProperties.getPortType() != null) {
            portType = portProperties.getPortType().getOpenTypeOrdinal();
        }
        this.processHandler.updatePort(userId, correlationProperties.getAssetManagerGUID(), correlationProperties.getAssetManagerName(), portGUID, portGUIDParameterName, portProperties.getQualifiedName(), portProperties.getDisplayName(), portType, portProperties.getAdditionalProperties(), typeName, portProperties.getExtendedProperties(), methodName);
    }

    public void setupProcessPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, String portGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        this.processHandler.setupProcessPort(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, methodName);
    }

    public void clearProcessPort(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String portGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.processHandler.clearProcessPort(userId, assetManagerGUID, assetManagerName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, methodName);
    }

    public void setupPortDelegation(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", methodName);
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        this.processHandler.setupPortDelegation(userId, externalSourceGUID, externalSourceName, portOneGUID, "portOneGUID", portTwoGUID, "portTwoGUID", methodName);
    }

    public void clearPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portOneGUID, String portTwoGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", methodName);
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", methodName);
        this.processHandler.clearPortDelegation(userId, assetManagerGUID, assetManagerName, portOneGUID, "portOneGUID", portTwoGUID, "portTwoGUID", methodName);
    }

    public void setupPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        this.processHandler.setupPortSchemaType(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, schemaTypeGUID, "schemaTypeGUID", methodName);
    }

    public void clearPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String schemaTypeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        this.processHandler.clearPortSchemaType(userId, assetManagerGUID, assetManagerName, portGUID, portGUIDParameterName, schemaTypeGUID, "schemaTypeGUID", methodName);
    }

    public void removePort(String userId, MetadataCorrelationProperties correlationProperties, String portGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            externalSourceGUID = correlationProperties.getAssetManagerGUID();
            externalSourceName = correlationProperties.getAssetManagerName();
        }
        this.validateExternalIdentifier(userId, portGUID, portGUIDParameterName, "Port", correlationProperties, methodName);
        this.processHandler.removePort(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, methodName);
    }

    public List<PortElement> findPorts(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.findPorts(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<PortElement> getPortsForProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortsForProcess(userId, processGUID, processGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<PortElement> getPortUse(String userId, String assetManagerGUID, String assetManagerName, String portGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortUse(userId, portGUID, portGUIDParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public PortElement getPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PortElement element = (PortElement)this.processHandler.getPortDelegation(userId, portGUID, portGUIDParameterName, methodName);
        if (element != null && element.getElementHeader() != null && element.getElementHeader().getGUID() != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, methodName));
        }
        return element;
    }

    public List<PortElement> getPortsByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortsByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public PortElement getPortByGUID(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PortElement element = (PortElement)this.processHandler.getPortByGUID(userId, portGUID, portGUIDParameterName, methodName);
        if (element != null && element.getElementHeader() != null && element.getElementHeader().getGUID() != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, methodName));
        }
        return element;
    }

    public void setBusinessSignificant(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.validateExternalIdentifier(userId, elementGUID, "elementGUID", "Referenceable", correlationProperties, methodName);
        this.processHandler.setBusinessSignificant(userId, elementGUID, "elementGUID", methodName);
    }

    public void clearBusinessSignificant(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.validateExternalIdentifier(userId, elementGUID, "elementGUID", "Referenceable", correlationProperties, methodName);
        this.processHandler.clearBusinessSignificant(userId, elementGUID, "elementGUID", methodName);
    }

    public String setupDataFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupDataFlow(userId, externalSourceGUID, externalSourceName, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataSupplierGUID", qualifiedName, description, formula, methodName);
    }

    public DataFlowElement getDataFlow(String userId, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", methodName);
        return (DataFlowElement)this.processHandler.getDataFlow(userId, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", qualifiedName, methodName);
    }

    public void updateDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", methodName);
        this.processHandler.updateDataFlow(userId, assetManagerGUID, assetManagerName, dataFlowGUID, "dataFlowGUID", qualifiedName, description, formula, methodName);
    }

    public void clearDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFlowGUID, "dataFlowGUID", methodName);
        this.processHandler.clearDataFlow(userId, assetManagerGUID, assetManagerName, dataFlowGUID, "dataFlowGUID", methodName);
    }

    public List<DataFlowElement> getDataFlowConsumers(String userId, String dataSupplierGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataSupplierGUID, "dataSupplierGUID", methodName);
        return this.processHandler.getDataFlowConsumers(userId, dataSupplierGUID, "dataSupplierGUID", methodName);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String userId, String dataConsumerGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataConsumerGUID, "dataConsumerGUID", methodName);
        return this.processHandler.getDataFlowSuppliers(userId, dataConsumerGUID, "dataConsumerGUID", methodName);
    }

    public String setupControlFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, String qualifiedName, String description, String guard, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", methodName);
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupControlFlow(userId, externalSourceGUID, externalSourceName, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", qualifiedName, description, guard, methodName);
    }

    public ControlFlowElement getControlFlow(String userId, String currentStepGUID, String nextStepGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", methodName);
        this.invalidParameterHandler.validateGUID(nextStepGUID, "nextStepGUID", methodName);
        return (ControlFlowElement)this.processHandler.getControlFlow(userId, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", qualifiedName, methodName);
    }

    public void updateControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, String qualifiedName, String description, String guard, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", methodName);
        this.processHandler.updateControlFlow(userId, assetManagerGUID, assetManagerName, controlFlowGUID, "controlFlowGUID", qualifiedName, description, guard, methodName);
    }

    public void clearControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(controlFlowGUID, "controlFlowGUID", methodName);
        this.processHandler.clearControlFlow(userId, assetManagerGUID, assetManagerName, controlFlowGUID, "controlFlowGUID", methodName);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String userId, String currentStepGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", methodName);
        return this.processHandler.getControlFlowNextSteps(userId, currentStepGUID, "currentStepGUID", methodName);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String userId, String currentStepGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(currentStepGUID, "currentStepGUID", methodName);
        return this.processHandler.getControlFlowPreviousSteps(userId, currentStepGUID, "currentStepGUID", methodName);
    }

    public String setupProcessCall(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String callerGUID, String calledGUID, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", methodName);
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupProcessCall(userId, externalSourceGUID, externalSourceName, callerGUID, "callerGUID", calledGUID, "calledGUID", qualifiedName, description, formula, methodName);
    }

    public ProcessCallElement getProcessCall(String userId, String callerGUID, String calledGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", methodName);
        return (ProcessCallElement)this.processHandler.getProcessCall(userId, callerGUID, "callerGUID", calledGUID, "calledGUID", qualifiedName, methodName);
    }

    public void updateProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, String qualifiedName, String description, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", methodName);
        this.processHandler.updateProcessCall(userId, assetManagerGUID, assetManagerName, processCallGUID, "processCallGUID", qualifiedName, description, formula, methodName);
    }

    public void clearProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processCallGUIDParameterName = "processCallGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processCallGUID, "processCallGUID", methodName);
        this.processHandler.clearProcessCall(userId, assetManagerGUID, assetManagerName, processCallGUID, "processCallGUID", methodName);
    }

    public List<ProcessCallElement> getProcessCalled(String userId, String callerGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(callerGUID, "callerGUID", methodName);
        return this.processHandler.getProcessCallers(userId, callerGUID, "callerGUID", methodName);
    }

    public List<ProcessCallElement> getProcessCallers(String userId, String calledGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String calledGUIDParameterName = "calledGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(calledGUID, "calledGUID", methodName);
        return this.processHandler.getProcessCallers(userId, calledGUID, "calledGUID", methodName);
    }

    public void setupLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", methodName);
        this.processHandler.setupLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "LineageMapping", sourceElementGUID, "Referenceable", destinationElementGUID, "Referenceable", methodName);
    }

    public void clearLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", methodName);
        this.processHandler.clearLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "LineageMapping", sourceElementGUID, "Referenceable", destinationElementGUID, "Referenceable", methodName);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String userId, String sourceElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(sourceElementGUID, "sourceElementGUID", methodName);
        return this.processHandler.getDestinationLineageMappings(userId, sourceElementGUID, "sourceElementGUID", methodName);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String userId, String destinationElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String destinationElementGUIDParameterName = "destinationElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(destinationElementGUID, "destinationElementGUID", methodName);
        return this.processHandler.getSourceLineageMappings(userId, destinationElementGUID, "destinationElementGUID", methodName);
    }
}

