/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.ProcessExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class LineageExchangeRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(LineageExchangeRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createProcess(String serverName, String userId, boolean assetManagerIsHome, ProcessStatus initialStatus, ProcessRequestBody requestBody) {
        String methodName = "createProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProcess");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createProcess");
                response.setGUID(handler.createProcess(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), initialStatus, "createProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createProcessFromTemplate(String serverName, String userId, boolean assetManagerIsHome, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createProcessFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProcessFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProcessFromTemplate");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createProcessFromTemplate");
                response.setGUID(handler.createProcessFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createProcessFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createProcessFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createProcessFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcess(String serverName, String userId, String processGUID, boolean isMergeUpdate, ProcessRequestBody requestBody) {
        String methodName = "updateProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcess");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcess");
                handler.updateProcess(userId, requestBody.getMetadataCorrelationProperties(), processGUID, isMergeUpdate, requestBody.getElementProperties(), "updateProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcessStatus(String serverName, String userId, String processGUID, ProcessStatusRequestBody requestBody) {
        String methodName = "updateProcessStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcessStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcessStatus");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcessStatus");
                handler.updateProcessStatus(userId, requestBody.getMetadataCorrelationProperties(), processGUID, requestBody.getProcessStatus(), "updateProcessStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcessStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateProcessStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProcessParent(String serverName, String userId, String parentProcessGUID, String childProcessGUID, boolean assetManagerIsHome, ProcessContainmentType containmentType, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessParent");
            if (requestBody != null) {
                handler.setupProcessParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentType, "setupProcessParent");
            } else {
                handler.setupProcessParent(userId, null, null, assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentType, "setupProcessParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessParent(String serverName, String userId, String parentProcessGUID, String childProcessGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessParent");
            if (requestBody != null) {
                handler.clearProcessParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), parentProcessGUID, childProcessGUID, "clearProcessParent");
            } else {
                handler.clearProcessParent(userId, null, null, parentProcessGUID, childProcessGUID, "clearProcessParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishProcess(String serverName, String userId, String processGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "publishProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "publishProcess");
            handler.publishProcess(userId, processGUID, "publishProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "publishProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawProcess(String serverName, String userId, String processGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "withdrawProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "withdrawProcess");
            handler.withdrawProcess(userId, processGUID, "withdrawProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "withdrawProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeProcess(String serverName, String userId, String processGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "removeProcess");
            handler.removeProcess(userId, requestBody, processGUID, "removeProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removeProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse findProcesses(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findProcesses");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProcesses");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "findProcesses");
                response.setElementList(handler.findProcesses(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, "findProcesses"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getProcessesForAssetManager(String serverName, String userId, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getProcessesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessesForAssetManager");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessesForAssetManager");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessesForAssetManager");
                response.setElementList(handler.getProcessesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, "getProcessesForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getProcessesForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getProcessesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getProcessesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessesByName");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessesByName");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessesByName");
                response.setElementList(handler.getProcessesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, "getProcessesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementResponse getProcessByGUID(String serverName, String userId, String processGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getProcessByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessByGUID");
        ProcessElementResponse response = new ProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessByGUID");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessByGUID");
            if (requestBody != null) {
                response.setElement(handler.getProcessByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, "getProcessByGUID"));
            } else {
                response.setElement(handler.getProcessByGUID(userId, null, null, processGUID, "getProcessByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementResponse getProcessParent(String serverName, String userId, String processGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessParent");
        ProcessElementResponse response = new ProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessParent");
            if (requestBody != null) {
                response.setElement(handler.getProcessParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, "getProcessParent"));
            } else {
                response.setElement(handler.getProcessParent(userId, null, null, processGUID, "getProcessParent"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getSubProcesses(String serverName, String userId, String processGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSubProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubProcesses");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubProcesses");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getSubProcesses");
            if (requestBody != null) {
                response.setElementList(handler.getSubProcesses(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, startFrom, pageSize, "getSubProcesses"));
            } else {
                response.setElementList(handler.getSubProcesses(userId, null, null, processGUID, startFrom, pageSize, "getSubProcesses"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSubProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createPort(String serverName, String userId, boolean assetManagerIsHome, String processGUID, PortRequestBody requestBody) {
        String methodName = "createPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPort");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createPort");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createPort");
                response.setGUID(handler.createPort(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, processGUID, requestBody.getElementProperties(), "createPort"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPort", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updatePort(String serverName, String userId, String portGUID, PortRequestBody requestBody) {
        String methodName = "updatePort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updatePort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePort");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updatePort");
                handler.updatePort(userId, requestBody.getMetadataCorrelationProperties(), portGUID, requestBody.getElementProperties(), "updatePort");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updatePort", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updatePort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProcessPort(String serverName, String userId, boolean assetManagerIsHome, String processGUID, String portGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupProcessPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessPort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessPort");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessPort");
            if (requestBody != null) {
                handler.setupProcessPort(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, processGUID, portGUID, "setupProcessPort");
            } else {
                handler.setupProcessPort(userId, null, null, assetManagerIsHome, processGUID, portGUID, "setupProcessPort");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupProcessPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessPort(String serverName, String userId, String processGUID, String portGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearProcessPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessPort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessPort");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessPort");
            if (requestBody != null) {
                handler.clearProcessPort(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, portGUID, "clearProcessPort");
            } else {
                handler.clearProcessPort(userId, null, null, processGUID, portGUID, "clearProcessPort");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearProcessPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupPortDelegation(String serverName, String userId, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupPortDelegation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupPortDelegation");
            if (requestBody != null) {
                handler.setupPortDelegation(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, portOneGUID, portTwoGUID, "setupPortDelegation");
            } else {
                handler.setupPortDelegation(userId, null, null, assetManagerIsHome, portOneGUID, portTwoGUID, "setupPortDelegation");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearPortDelegation(String serverName, String userId, String portOneGUID, String portTwoGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearPortDelegation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearPortDelegation");
            if (requestBody != null) {
                handler.clearPortDelegation(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portOneGUID, portTwoGUID, "clearPortDelegation");
            } else {
                handler.clearPortDelegation(userId, null, null, portOneGUID, portTwoGUID, "clearPortDelegation");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupPortSchemaType(String serverName, String userId, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupPortSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupPortSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupPortSchemaType");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupPortSchemaType");
            if (requestBody != null) {
                handler.setupPortSchemaType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, portGUID, schemaTypeGUID, "setupPortSchemaType");
            } else {
                handler.setupPortSchemaType(userId, null, null, assetManagerIsHome, portGUID, schemaTypeGUID, "setupPortSchemaType");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupPortSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearPortSchemaType(String serverName, String userId, String portGUID, String schemaTypeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearPortSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearPortSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearPortSchemaType");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearPortSchemaType");
            if (requestBody != null) {
                handler.clearPortSchemaType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, schemaTypeGUID, "clearPortSchemaType");
            } else {
                handler.clearPortSchemaType(userId, null, null, portGUID, schemaTypeGUID, "clearPortSchemaType");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearPortSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removePort(String serverName, String userId, String portGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removePort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removePort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removePort");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "removePort");
            handler.removePort(userId, requestBody, portGUID, "removePort");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "removePort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse findPorts(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findPorts";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findPorts");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findPorts");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "findPorts");
                response.setElementList(handler.findPorts(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, "findPorts"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findPorts", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findPorts", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortsForProcess(String serverName, String userId, String processGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getPortsForProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortsForProcess");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortsForProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortsForProcess");
            if (requestBody != null) {
                response.setElementList(handler.getPortsForProcess(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, startFrom, pageSize, "getPortsForProcess"));
            } else {
                response.setElementList(handler.getPortsForProcess(userId, null, null, processGUID, startFrom, pageSize, "getPortsForProcess"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPortsForProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortUse(String serverName, String userId, String portGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getPortUse";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortUse");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortUse");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortUse");
            if (requestBody != null) {
                response.setElementList(handler.getPortUse(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, startFrom, pageSize, "getPortUse"));
            } else {
                response.setElementList(handler.getPortUse(userId, null, null, portGUID, startFrom, pageSize, "getPortUse"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPortUse", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementResponse getPortDelegation(String serverName, String userId, String portGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortDelegation");
        PortElementResponse response = new PortElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortDelegation");
            if (requestBody != null) {
                response.setElement(handler.getPortDelegation(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, "getPortDelegation"));
            } else {
                response.setElement(handler.getPortDelegation(userId, null, null, portGUID, "getPortDelegation"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getPortsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortsByName");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortsByName");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortsByName");
            if (requestBody != null) {
                response.setElementList(handler.getPortsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, "getPortsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getPortsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPortsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementResponse getPortByGUID(String serverName, String userId, String portGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getPortByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortByGUID");
        PortElementResponse response = new PortElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortByGUID");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortByGUID");
            if (requestBody != null) {
                response.setElement(handler.getPortByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, "getPortByGUID"));
            } else {
                response.setElement(handler.getPortByGUID(userId, null, null, portGUID, "getPortByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPortByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setBusinessSignificant(String serverName, String userId, String elementGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setBusinessSignificant";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setBusinessSignificant");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setBusinessSignificant");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setBusinessSignificant");
            handler.setBusinessSignificant(userId, requestBody, elementGUID, "setBusinessSignificant");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setBusinessSignificant", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearBusinessSignificant(String serverName, String userId, String elementGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearBusinessSignificant";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearBusinessSignificant");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearBusinessSignificant");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearBusinessSignificant");
            handler.clearBusinessSignificant(userId, requestBody, elementGUID, "clearBusinessSignificant");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearBusinessSignificant", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, boolean assetManagerIsHome, DataFlowRequestBody requestBody) {
        String methodName = "setupDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupDataFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupDataFlow");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupDataFlow");
                response.setGUID(handler.setupDataFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), "setupDataFlow"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupDataFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementResponse getDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, NameRequestBody requestBody) {
        String methodName = "getDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlow");
        DataFlowElementResponse response = new DataFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlow");
            if (requestBody != null) {
                response.setElement(handler.getDataFlow(userId, dataSupplierGUID, dataConsumerGUID, requestBody.getName(), "getDataFlow"));
            } else {
                response.setElement(handler.getDataFlow(userId, dataSupplierGUID, dataConsumerGUID, null, "getDataFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataFlow(String serverName, String userId, String dataFlowGUID, DataFlowRequestBody requestBody) {
        String methodName = "updateDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataFlow");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateDataFlow");
                handler.updateDataFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), dataFlowGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), "updateDataFlow");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDataFlow(String serverName, String userId, String dataFlowGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearDataFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearDataFlow");
            if (requestBody != null) {
                handler.clearDataFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), dataFlowGUID, "clearDataFlow");
            } else {
                handler.clearDataFlow(userId, null, null, dataFlowGUID, "clearDataFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowConsumers(String serverName, String userId, String dataSupplierGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getDataFlowConsumers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowConsumers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowConsumers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlowConsumers");
            response.setElementList(handler.getDataFlowConsumers(userId, dataSupplierGUID, "getDataFlowConsumers"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDataFlowConsumers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowSuppliers(String serverName, String userId, String dataConsumerGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getDataFlowSuppliers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowSuppliers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowSuppliers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlowSuppliers");
            response.setElementList(handler.getDataFlowSuppliers(userId, dataConsumerGUID, "getDataFlowSuppliers"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDataFlowSuppliers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, boolean assetManagerIsHome, ControlFlowRequestBody requestBody) {
        String methodName = "setupControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupControlFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupControlFlow");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupControlFlow");
                response.setGUID(handler.setupControlFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, currentStepGUID, nextStepGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getGuard(), "setupControlFlow"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupControlFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementResponse getControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, NameRequestBody requestBody) {
        String methodName = "getControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlow");
        ControlFlowElementResponse response = new ControlFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlow");
            if (requestBody != null) {
                response.setElement(handler.getControlFlow(userId, currentStepGUID, nextStepGUID, requestBody.getName(), "getControlFlow"));
            } else {
                response.setElement(handler.getControlFlow(userId, currentStepGUID, nextStepGUID, null, "getControlFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateControlFlow(String serverName, String userId, String controlFlowGUID, ControlFlowRequestBody requestBody) {
        String methodName = "updateControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateControlFlow");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateControlFlow");
                handler.updateControlFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), controlFlowGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getGuard(), "updateControlFlow");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateControlFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearControlFlow(String serverName, String userId, String controlFlowGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearControlFlow");
            if (requestBody != null) {
                handler.clearControlFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), controlFlowGUID, "clearControlFlow");
            } else {
                handler.clearControlFlow(userId, null, null, controlFlowGUID, "clearControlFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowNextSteps(String serverName, String userId, String currentStepGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getControlFlowNextSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowNextSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowNextSteps");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlowNextSteps");
            response.setElementList(handler.getControlFlowNextSteps(userId, currentStepGUID, "getControlFlowNextSteps"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getControlFlowNextSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowPreviousSteps(String serverName, String userId, String currentStepGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getControlFlowPreviousSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowPreviousSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowPreviousSteps");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlowPreviousSteps");
            response.setElementList(handler.getControlFlowPreviousSteps(userId, currentStepGUID, "getControlFlowPreviousSteps"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getControlFlowPreviousSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupProcessCall(String serverName, String userId, String callerGUID, String calledGUID, boolean assetManagerIsHome, ProcessCallRequestBody requestBody) {
        String methodName = "setupProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessCall");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessCall");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessCall");
                response.setGUID(handler.setupProcessCall(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, callerGUID, calledGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), "setupProcessCall"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupProcessCall", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementResponse getProcessCall(String serverName, String userId, String callerGUID, String calledGUID, NameRequestBody requestBody) {
        String methodName = "getProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCall");
        ProcessCallElementResponse response = new ProcessCallElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCall");
            if (requestBody != null) {
                response.setElement(handler.getProcessCall(userId, callerGUID, calledGUID, requestBody.getName(), "getProcessCall"));
            } else {
                response.setElement(handler.getProcessCall(userId, callerGUID, calledGUID, null, "getProcessCall"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcessCall(String serverName, String userId, String processCallGUID, ProcessCallRequestBody requestBody) {
        String methodName = "updateProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcessCall");
            if (requestBody != null && requestBody.getProperties() != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcessCall");
                handler.updateProcessCall(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processCallGUID, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getFormula(), "updateProcessCall");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcessCall", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessCall(String serverName, String userId, String processCallGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessCall");
            if (requestBody != null) {
                handler.clearProcessCall(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processCallGUID, "clearProcessCall");
            } else {
                handler.clearProcessCall(userId, null, null, processCallGUID, "clearProcessCall");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCalled(String serverName, String userId, String callerGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getProcessCalled";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCalled");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCalled");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCalled");
            response.setElementList(handler.getProcessCalled(userId, callerGUID, "getProcessCalled"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessCalled", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCallers(String serverName, String userId, String calledGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getProcessCallers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCallers");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCallers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCallers");
            response.setElementList(handler.getProcessCallers(userId, calledGUID, "getProcessCallers"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getProcessCallers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupLineageMapping");
            if (requestBody != null) {
                handler.setupLineageMapping(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), sourceElementGUID, destinationElementGUID, "setupLineageMapping");
            } else {
                handler.setupLineageMapping(userId, null, null, sourceElementGUID, destinationElementGUID, "setupLineageMapping");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "setupLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearLineageMapping");
            if (requestBody != null) {
                handler.clearLineageMapping(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), sourceElementGUID, destinationElementGUID, "clearLineageMapping");
            } else {
                handler.clearLineageMapping(userId, null, null, sourceElementGUID, destinationElementGUID, "clearLineageMapping");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "clearLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getDestinationLineageMappings(String serverName, String userId, String sourceElementGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getDestinationLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDestinationLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDestinationLineageMappings");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDestinationLineageMappings");
            response.setElementList(handler.getDestinationLineageMappings(userId, sourceElementGUID, "getDestinationLineageMappings"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDestinationLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getSourceLineageMappings(String serverName, String userId, String destinationElementGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSourceLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSourceLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceLineageMappings");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getSourceLineageMappings");
            response.setElementList(handler.getSourceLineageMappings(userId, destinationElementGUID, "getSourceLineageMappings"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSourceLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

