/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SimpleSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class SchemaExchangeHandler
extends ExchangeHandlerBase {
    private SchemaTypeHandler<SchemaTypeElement> schemaTypeHandler;
    private SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> schemaAttributeHandler;
    private static final String schemaTypeGUIDParameterName = "schemaTypeGUID";
    private static final String schemaAttributeGUIDParameterName = "schemaAttributeGUID";

    public SchemaExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeHandler = new SchemaTypeHandler(new SchemaTypeConverter(repositoryHelper, serviceName, serverName), SchemaTypeElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaAttributeHandler = new SchemaAttributeHandler(new SchemaAttributeConverter(repositoryHelper, serviceName, serverName), SchemaAttributeElement.class, new SchemaTypeConverter(repositoryHelper, serviceName, serverName), SchemaTypeElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToSchemaTypes(String userId, String assetManagerGUID, String assetManagerName, List<SchemaTypeElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, List<SchemaAttributeElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), schemaAttributeGUIDParameterName, "SchemaAttribute", assetManagerGUID, assetManagerName, methodName));
            }
        }
    }

    public String createSchemaType(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, SchemaTypeProperties schemaTypeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", methodName);
        SchemaTypeBuilder builder = this.getSchemaTypeBuilder(schemaTypeProperties, this.repositoryHelper, this.serviceName, this.serverName, methodName);
        String schemaTypeGUID = this.schemaTypeHandler.addSchemaType(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), builder, methodName);
        if (schemaTypeGUID != null) {
            this.maintainSupplementaryProperties(userId, schemaTypeGUID, schemaTypeProperties.getQualifiedName(), (SupplementaryProperties)schemaTypeProperties, false, methodName);
            this.createExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, methodName);
        }
        return schemaTypeGUID;
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaTypeProperties schemaType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String typeName = "SchemaType";
        if (schemaType.getTypeName() != null) {
            typeName = schemaType.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", serviceName, methodName, repositoryHelper);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.getIsDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), typeGUID, typeName, schemaType.getExtendedProperties(), repositoryHelper, serviceName, serverName);
        if (schemaType instanceof LiteralSchemaTypeProperties) {
            LiteralSchemaTypeProperties literalSchemaTypeProperties = (LiteralSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(literalSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setFixedValue(literalSchemaTypeProperties.getFixedValue());
        } else if (schemaType instanceof SimpleSchemaTypeProperties) {
            SimpleSchemaTypeProperties simpleSchemaTypeProperties = (SimpleSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(simpleSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setDefaultValue(simpleSchemaTypeProperties.getDefaultValue());
            if (schemaType instanceof EnumSchemaTypeProperties) {
                EnumSchemaTypeProperties enumSchemaTypeProperties = (EnumSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setValidValuesSetGUID(enumSchemaTypeProperties.getValidValueSetGUID());
            } else if (schemaType instanceof ExternalSchemaTypeProperties) {
                ExternalSchemaTypeProperties externalSchemaTypeProperties = (ExternalSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setExternalSchemaTypeGUID(externalSchemaTypeProperties.getExternalSchemaTypeGUID());
            }
        } else if (schemaType instanceof SchemaTypeChoiceProperties) {
            SchemaTypeChoiceProperties schemaTypeChoiceProperties = (SchemaTypeChoiceProperties)schemaType;
            if (schemaTypeChoiceProperties.getSchemaOptions() != null) {
                ArrayList<SchemaTypeBuilder> schemaOptionBuilders = new ArrayList<SchemaTypeBuilder>();
                for (SchemaTypeProperties schemaOption : schemaTypeChoiceProperties.getSchemaOptions()) {
                    if (schemaOption == null) continue;
                    schemaOptionBuilders.add(this.getSchemaTypeBuilder(schemaOption, repositoryHelper, serviceName, serverName, methodName));
                }
                if (!schemaOptionBuilders.isEmpty()) {
                    schemaTypeBuilder.setSchemaOptions(schemaOptionBuilders);
                }
            }
        } else if (schemaType instanceof MapSchemaTypeProperties) {
            MapSchemaTypeProperties mapSchemaTypeProperties = (MapSchemaTypeProperties)schemaType;
            SchemaTypeBuilder mapFromBuilder = null;
            SchemaTypeBuilder mapToBuilder = null;
            if (mapSchemaTypeProperties.getMapFromElement() != null) {
                mapFromBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapFromElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            if (mapSchemaTypeProperties.getMapToElement() != null) {
                mapToBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapToElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            schemaTypeBuilder.setMapTypes(mapFromBuilder, mapToBuilder);
        }
        return schemaTypeBuilder;
    }

    public String createSchemaTypeFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String schemaTypeGUID = this.schemaTypeHandler.createSchemaTypeFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (schemaTypeGUID != null) {
            this.createExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, methodName);
        }
        return schemaTypeGUID;
    }

    public void updateSchemaType(String userId, MetadataCorrelationProperties correlationProperties, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, methodName);
        SchemaTypeBuilder builder = this.getSchemaTypeBuilder(schemaTypeProperties, this.repositoryHelper, this.serviceName, this.serverName, methodName);
        this.schemaTypeHandler.updateSchemaType(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaTypeGUID, schemaTypeGUIDParameterName, builder, isMergeUpdate, methodName);
    }

    public void setupSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.schemaTypeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, methodName);
        } else {
            this.schemaTypeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, methodName);
        }
    }

    public void clearSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.schemaTypeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", methodName);
        } else {
            this.schemaTypeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
        }
    }

    public void removeSchemaType(String userId, MetadataCorrelationProperties correlationProperties, String schemaTypeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, methodName);
        this.schemaAttributeHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, methodName);
    }

    public List<SchemaTypeElement> findSchemaType(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaTypeHandler.findSchemaTypes(userId, searchString, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToSchemaTypes(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public SchemaTypeElement getSchemaTypeForElement(String userId, String assetManagerGUID, String assetManagerName, String parentElementGUID, String parentElementTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", methodName);
        SchemaTypeElement schemaTypeElement = parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port") ? (SchemaTypeElement)this.schemaTypeHandler.getSchemaTypeForPort(userId, parentElementGUID, "parentElementGUID", methodName) : (SchemaTypeElement)this.schemaTypeHandler.getSchemaTypeForAsset(userId, parentElementGUID, "parentElementGUID", methodName);
        if (schemaTypeElement != null) {
            schemaTypeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaTypeElement.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, methodName));
        }
        return schemaTypeElement;
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaTypeHandler.getSchemaTypeByName(userId, name, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToSchemaTypes(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public SchemaTypeElement getSchemaTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaTypeGUIDParameterName;
        SchemaTypeElement schemaTypeElement = (SchemaTypeElement)this.schemaTypeHandler.getSchemaType(userId, schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        if (schemaTypeElement != null) {
            schemaTypeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, methodName));
        }
        return schemaTypeElement;
    }

    public ElementHeader getSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaTypeGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, schemaTypeGUID, "SchemaType", null, null, 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (relationship == null || relationship.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AssetSchemaType") && !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "PortSchema")) continue;
            String parentGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
            EntityDetail parentEntity = this.schemaTypeHandler.getEntityFromRepository(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", "Referenceable", methodName);
            ElementHeaderConverter<ElementHeader> headerConverter = new ElementHeaderConverter<ElementHeader>(this.repositoryHelper, this.serviceName, this.serverName);
            return headerConverter.getNewBean(ElementHeader.class, parentEntity, methodName);
        }
        return null;
    }

    public String createSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, schemaAttributeProperties, methodName);
        String schemaAttributeGUID = this.schemaAttributeHandler.createNestedSchemaAttribute(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", schemaAttributeBuilder, methodName);
        if (schemaAttributeGUID != null) {
            this.createExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, methodName);
        }
        return schemaAttributeGUID;
    }

    private SchemaAttributeBuilder getSchemaAttributeBuilder(String userId, SchemaAttributeProperties schemaAttributeProperties, String methodName) throws InvalidParameterException {
        String typeName = "SchemaAttribute";
        if (schemaAttributeProperties.getTypeName() != null) {
            typeName = schemaAttributeProperties.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaAttribute", this.serviceName, methodName, this.repositoryHelper);
        int sortOrder = 0;
        if (schemaAttributeProperties.getSortOrder() != null) {
            sortOrder = schemaAttributeProperties.getSortOrder().getOpenTypeOrdinal();
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(schemaAttributeProperties.getQualifiedName(), schemaAttributeProperties.getDisplayName(), schemaAttributeProperties.getDescription(), schemaAttributeProperties.getElementPosition(), schemaAttributeProperties.getMinCardinality(), schemaAttributeProperties.getMaxCardinality(), schemaAttributeProperties.getIsDeprecated(), schemaAttributeProperties.getDefaultValueOverride(), schemaAttributeProperties.getAllowsDuplicateValues(), schemaAttributeProperties.getOrderedValues(), sortOrder, schemaAttributeProperties.getMinimumLength(), schemaAttributeProperties.getLength(), schemaAttributeProperties.getPrecision(), schemaAttributeProperties.getIsNullable(), schemaAttributeProperties.getNativeJavaClass(), schemaAttributeProperties.getAliases(), schemaAttributeProperties.getAdditionalProperties(), typeGUID, typeName, schemaAttributeProperties.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        if (schemaAttributeProperties.getSchemaType() != null) {
            SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaAttributeProperties.getSchemaType(), this.repositoryHelper, this.serviceName, this.serverName, methodName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        }
        return schemaAttributeBuilder;
    }

    public String createSchemaAttributeFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String scehmaElementGUIDParameterName = "schemaElementGUID";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String schemaAttributeGUID = this.schemaAttributeHandler.createSchemaAttributeFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (schemaAttributeGUID != null) {
            this.createExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, methodName);
        }
        return schemaAttributeGUID;
    }

    public void updateSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, schemaAttributeProperties, methodName);
        this.schemaAttributeHandler.updateSchemaAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaAttributeGUID, schemaAttributeGUIDParameterName, schemaAttributeBuilder.getInstanceProperties(methodName), isMergeUpdate, methodName);
    }

    public void setSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, String formula, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "formula", formula, methodName);
        this.schemaAttributeHandler.setClassificationInRepository(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", "SchemaElement", "CalculatedValue", "4814bec8-482d-463d-8376-160b0358e139", properties, false, methodName);
    }

    public void clearSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, String schemaElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.schemaAttributeHandler.removeClassificationFromRepository(userId, assetManagerGUID, assetManagerName, schemaElementGUID, "schemaElementGUID", "SchemaElement", "4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", methodName);
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String primaryKeyName, KeyPattern primaryKeyPattern, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", primaryKeyName, methodName);
        int keyPatternOrdinal = 0;
        if (primaryKeyPattern != null) {
            keyPatternOrdinal = primaryKeyPattern.getOpenTypeOrdinal();
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "keyPattern", "8904df8f-1aca-4de8-9abd-1ef2aadba300", "KeyPattern", keyPatternOrdinal, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)classificationNotSupported, "keyPattern");
        }
        this.schemaAttributeHandler.setClassificationInRepository(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", properties, false, methodName);
    }

    public void clearColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.schemaAttributeHandler.removeClassificationFromRepository(userId, assetManagerGUID, assetManagerName, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", methodName);
    }

    public void setupForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        this.schemaAttributeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "SchemaAttribute", "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", this.getForeignKeyProperties(foreignKeyProperties, methodName), methodName);
    }

    private InstanceProperties getForeignKeyProperties(ForeignKeyProperties foreignKeyProperties, String methodName) {
        InstanceProperties properties = null;
        if (foreignKeyProperties != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", foreignKeyProperties.getName(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", foreignKeyProperties.getDescription(), methodName);
            properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", foreignKeyProperties.getConfidence(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", foreignKeyProperties.getSteward(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", foreignKeyProperties.getSource(), methodName);
        }
        return properties;
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        this.schemaAttributeHandler.updateElementToElementLink(userId, assetManagerGUID, assetManagerName, primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "SchemaAttribute", "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", this.getForeignKeyProperties(foreignKeyProperties, methodName), methodName);
    }

    public void clearForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        this.schemaAttributeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", methodName);
    }

    public void removeSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, String schemaAttributeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, methodName);
        this.schemaAttributeHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaAttributeGUID, schemaAttributeGUIDParameterName, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, methodName);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List results = this.schemaAttributeHandler.findSchemaAttributes(userId, searchString, "searchString", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<SchemaAttributeElement> getAttributesForSchemaType(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaAttributeHandler.getSchemaAttributesForComplexSchemaType(userId, schemaTypeGUID, schemaTypeGUIDParameterName, null, null, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaAttributeHandler.getSchemaAttributesByName(userId, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", name, null, null, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaAttributeGUIDParameterName;
        SchemaAttributeElement schemaAttributeElement = (SchemaAttributeElement)this.schemaAttributeHandler.getBeanFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", methodName);
        if (schemaAttributeElement != null) {
            schemaAttributeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", assetManagerGUID, assetManagerName, methodName));
        }
        return schemaAttributeElement;
    }
}

