/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.listener;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.outtopic.AssetManagerOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetManagerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(AssetManagerOMRSTopicListener.class);
    private final AssetManagerOutTopicPublisher eventPublisher;
    private final AssetHandler assetHandler;
    private final String localServerUserId;
    private final List<String> supportedZones;

    public AssetManagerOMRSTopicListener(String serviceName, String localServerUserId, AssetManagerOutTopicPublisher eventPublisher, AssetHandler assetHandler, List<String> supportedZones, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.assetHandler = assetHandler;
        this.localServerUserId = localServerUserId;
        this.eventPublisher = eventPublisher;
        this.supportedZones = supportedZones;
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Received new Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing new Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.NEW_ELEMENT_CREATED);
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        log.debug("Received updated Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, newEntity, null);
        if (eventEntity != null) {
            log.debug("Publishing updated Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_UPDATED, eventEntity, oldEntity, null, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification classification) {
        log.debug("Processing classified EntityProxy event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, classification);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        log.debug("Received classified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing classified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_CLASSIFIED, eventEntity, null, classification, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Received classified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing classified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_CLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, originalClassification);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, originalClassification);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_DECLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entityProxy, Classification originalClassification, Classification classification) {
        log.debug("Processing reclassified EntityProxy event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, null, entityProxy);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, classification, originalClassification);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        log.debug("Receiving reclassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, classification, originalClassification);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving reclassified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_RECLASSIFIED, eventEntity, null, null, null);
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving deleted Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing deleted Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_DELETED);
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing delete-purge entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing delete-purge entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_DELETED);
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving restored Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing restored Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_RESTORED);
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        log.debug("Processing re-identified Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing re-identified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_GUID_CHANGED);
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        log.debug("Processing re-typed Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing re-typed Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_TYPE_CHANGED);
        }
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        log.debug("Processing re-homed Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing re-homed Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.ELEMENT_HOME_CHANGED);
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving refresh Entity event from: " + sourceName);
        EntityDetail eventEntity = this.entityOfInterest(this.localServerUserId, entity, null);
        if (eventEntity != null) {
            log.debug("Publishing refresh Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(eventEntity, AssetManagerEventType.REFRESH_ELEMENT_EVENT);
        }
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Receiving new relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.NEW_ELEMENT_CREATED, relationship, null);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        log.debug("Receiving updated relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_UPDATED, newRelationship, oldRelationship);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Receiving deleted relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_DELETED, relationship, null);
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Receiving delete-purge relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_DELETED, relationship, null);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        log.debug("Receiving reidentified relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_GUID_CHANGED, relationship, null);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        log.debug("Receiving retyped relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_TYPE_CHANGED, relationship, null);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        log.debug("Receiving rehomed relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_HOME_CHANGED, relationship, null);
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing refresh relationship event from: " + sourceName);
        this.processRelationshipEvent(AssetManagerEventType.ELEMENT_HOME_CHANGED, relationship, null);
    }

    private EntityDetail entityOfInterest(String userId, EntityDetail entity, EntityProxy entityProxy) {
        String methodName = "entityOfInterest";
        String guidParameterName = "entity.getGUID()";
        try {
            EntityDetail fullEntity = null;
            Date effectiveTime = new Date();
            if (entity != null) {
                fullEntity = entity;
                this.assetHandler.validateAnchorEntity(userId, fullEntity.getGUID(), "OpenMetadataRoot", fullEntity, "entity.getGUID()", false, true, false, this.supportedZones, effectiveTime, "entityOfInterest");
            } else if (entityProxy != null) {
                fullEntity = this.assetHandler.getEntityFromRepository(userId, entityProxy.getGUID(), "entity.getGUID()", entityProxy.getType().getTypeDefName(), null, null, false, false, this.supportedZones, effectiveTime, "entityOfInterest");
            }
            return fullEntity;
        }
        catch (Exception error) {
            if (entity != null) {
                log.debug("Element " + entity.getGUID() + " not visible");
            } else {
                log.debug("Element " + entityProxy.getGUID() + " not visible");
            }
            return null;
        }
    }

    private void processRelationshipEvent(AssetManagerEventType eventType, Relationship relationship, Relationship previousRelationship) {
        EntityDetail end1 = this.entityOfInterest(this.localServerUserId, null, relationship.getEntityOneProxy());
        EntityDetail end2 = this.entityOfInterest(this.localServerUserId, null, relationship.getEntityTwoProxy());
        if (end1 != null && end2 != null) {
            log.debug("Publishing " + eventType.getEventTypeName() + " relationship event");
            this.eventPublisher.publishRelationshipEvent(eventType, relationship, previousRelationship, end1, end2);
        }
    }
}

