/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExternalReferenceExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ExternalReferenceExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ExternalReferenceExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createExternalReference(String serverName, String userId, boolean assetManagerIsHome, ExternalReferenceRequestBody requestBody) {
        String methodName = "createExternalReference";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalReference");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalReference");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "createExternalReference");
                response.setGUID(handler.createExternalReference(userId, assetManagerIsHome, requestBody.getMetadataCorrelationProperties(), requestBody.getElementProperties(), requestBody.getAnchorGUID(), "createExternalReference"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalReference", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalReference(String serverName, String userId, String externalReferenceGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ExternalReferenceRequestBody requestBody) {
        String methodName = "updateExternalReference";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalReference");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "updateExternalReference");
                handler.updateExternalReference(userId, requestBody.getMetadataCorrelationProperties(), externalReferenceGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateExternalReference");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalReference", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteExternalReference(String serverName, String userId, String externalReferenceGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "deleteExternalReference";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteExternalReference");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteExternalReference");
            ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "deleteExternalReference");
            if (requestBody != null) {
                handler.removeExternalReference(userId, requestBody.getMetadataCorrelationProperties(), externalReferenceGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "deleteExternalReference");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteExternalReference", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteExternalReference", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse linkExternalReferenceToElement(String serverName, String userId, boolean assetManagerIsHome, String attachedToGUID, String externalReferenceGUID, boolean forLineage, boolean forDuplicateProcessing, ExternalReferenceLinkRequestBody requestBody) {
        String methodName = "linkExternalReferenceToElement";
        String attachedToGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkExternalReferenceToElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkExternalReferenceToElement");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "linkExternalReferenceToElement");
                if (assetManagerIsHome) {
                    response.setGUID(handler.linkExternalReferenceToElement(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), attachedToGUID, "attachedToGUID", externalReferenceGUID, "externalReferenceGUID", requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "linkExternalReferenceToElement"));
                } else {
                    response.setGUID(handler.linkExternalReferenceToElement(userId, null, null, attachedToGUID, "attachedToGUID", externalReferenceGUID, "externalReferenceGUID", requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "linkExternalReferenceToElement"));
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkExternalReferenceToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalReferenceToElementLink(String serverName, String userId, String externalReferenceLinkGUID, boolean forLineage, boolean forDuplicateProcessing, ExternalReferenceLinkRequestBody requestBody) {
        String methodName = "linkExternalReferenceToElement";
        String externalReferenceGUIDParameterName = "externalReferenceLinkGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkExternalReferenceToElement");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "linkExternalReferenceToElement");
                handler.updateExternalReferenceToElementLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalReferenceLinkGUID, "externalReferenceLinkGUID", requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "linkExternalReferenceToElement");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkExternalReferenceToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkExternalReferenceFromElement(String serverName, String userId, String externalReferenceLinkGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "linkExternalReferenceToElement";
        String externalReferenceGUIDParameterName = "externalReferenceLinkGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkExternalReferenceToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkExternalReferenceToElement");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "linkExternalReferenceToElement");
                handler.unlinkExternalReferenceFromElement(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalReferenceLinkGUID, "externalReferenceLinkGUID", forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "linkExternalReferenceToElement");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkExternalReferenceToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkExternalReferenceToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse getExternalReferences(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getExternalReferences";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferences");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferences");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferences");
                response.setElementList(handler.getExternalReferences(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferences"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferences", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse getExternalReferencesById(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getExternalReferencesById";
        String nameParameterName = "resourceId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesById");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesById");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferencesById");
                response.setElementList(handler.getExternalReferencesById(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), "resourceId", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferencesById"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesById", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferencesById", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse getExternalReferencesByURL(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getExternalReferencesByURL";
        String nameParameterName = "url";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesByURL");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesByURL");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferencesByURL");
                response.setElementList(handler.getExternalReferencesByURL(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), "url", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferencesByURL"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesByURL", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferencesByURL", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse getExternalReferencesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getExternalReferencesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesByName");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesByName");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferencesByName");
                response.setElementList(handler.getExternalReferencesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), "name", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferencesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferencesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse getExternalReferencesForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getExternalReferencesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferencesForAssetManager");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferencesForAssetManager");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferencesForAssetManager");
                response.setElementList(handler.getExternalReferencesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferencesForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferencesForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferencesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementsResponse findExternalReferences(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findExternalReferences";
        String searchStringParameterName = "requestBody";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findExternalReferences");
        ExternalReferenceElementsResponse response = new ExternalReferenceElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findExternalReferences");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "findExternalReferences");
                response.setElementList(handler.findExternalReferences(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), "requestBody", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findExternalReferences"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findExternalReferences", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceLinkElementsResponse retrieveAttachedExternalReferences(String serverName, String userId, String attachedToGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "retrieveAttachedExternalReferences";
        String guidParameterName = "attachedToGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "retrieveAttachedExternalReferences");
        ExternalReferenceLinkElementsResponse response = new ExternalReferenceLinkElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "retrieveAttachedExternalReferences");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "retrieveAttachedExternalReferences");
                response.setElementList(handler.retrieveAttachedExternalReferences(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), attachedToGUID, "attachedToGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "retrieveAttachedExternalReferences"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "retrieveAttachedExternalReferences", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "retrieveAttachedExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferenceElementResponse getExternalReferenceByGUID(String serverName, String userId, String externalReferenceGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getExternalReferenceByGUID";
        String guidParameterName = "externalReferenceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferenceByGUID");
        ExternalReferenceElementResponse response = new ExternalReferenceElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferenceByGUID");
            if (requestBody != null) {
                ExternalReferenceExchangeHandler handler = instanceHandler.getExternalReferenceExchangeHandler(userId, serverName, "getExternalReferenceByGUID");
                response.setElement(handler.getExternalReferenceByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalReferenceGUID, "externalReferenceGUID", forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalReferenceByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getExternalReferenceByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferenceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

