/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceActionStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class AssetManagerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public AssetManagerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "sortOrder", instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOpenTypeOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return DataItemSortOrder.UNKNOWN;
    }

    KeyPattern removeKeyPattern(InstanceProperties instanceProperties) {
        String methodName = "removeKeyPattern";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "keyPattern", instanceProperties, "removeKeyPattern");
            for (KeyPattern keyPattern : KeyPattern.values()) {
                if (keyPattern.getOpenTypeOrdinal() != ordinal) continue;
                return keyPattern;
            }
        }
        return KeyPattern.LOCAL_KEY;
    }

    SynchronizationDirection removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "permittedSynchronization", instanceProperties, "removePermittedSynchronization");
            for (SynchronizationDirection synchronizationDirection : SynchronizationDirection.values()) {
                if (synchronizationDirection.getOpenTypeOrdinal() != ordinal) continue;
                return synchronizationDirection;
            }
        }
        return SynchronizationDirection.BOTH_DIRECTIONS;
    }

    PortType removePortType(InstanceProperties instanceProperties) {
        String methodName = "removePortType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "portType", instanceProperties, "removePortType");
            for (PortType portType : PortType.values()) {
                if (portType.getOpenTypeOrdinal() != ordinal) continue;
                return portType;
            }
        }
        return PortType.OTHER;
    }

    ProcessContainmentType removeProcessContainmentType(InstanceProperties instanceProperties) {
        String methodName = "removeProcessContainmentType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "containmentType", instanceProperties, "removeProcessContainmentType");
            for (ProcessContainmentType containmentType : ProcessContainmentType.values()) {
                if (containmentType.getOpenTypeOrdinal() != ordinal) continue;
                return containmentType;
            }
        }
        return ProcessContainmentType.OTHER;
    }

    GovernanceActionStatus removeActionStatus(String propertyName, InstanceProperties properties) {
        GovernanceActionStatus ownerCategory = this.getActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerCategory;
    }

    private GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                    break;
                }
                case 99: {
                    governanceActionStatus = GovernanceActionStatus.OTHER;
                }
            }
        }
        return governanceActionStatus;
    }
}

