/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SimpleSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class SchemaExchangeHandler
extends ExchangeHandlerBase {
    private final SchemaTypeHandler<SchemaTypeElement> schemaTypeHandler;
    private final SchemaAttributeHandler<SchemaAttributeElement, SchemaTypeElement> schemaAttributeHandler;
    private static final String schemaTypeGUIDParameterName = "schemaTypeGUID";
    private static final String schemaAttributeGUIDParameterName = "schemaAttributeGUID";

    public SchemaExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeHandler = new SchemaTypeHandler(new SchemaTypeConverter(repositoryHelper, serviceName, serverName), SchemaTypeElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaAttributeHandler = new SchemaAttributeHandler(new SchemaAttributeConverter(repositoryHelper, serviceName, serverName), SchemaAttributeElement.class, new SchemaTypeConverter(repositoryHelper, serviceName, serverName), SchemaTypeElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToSchemaTypes(String userId, String assetManagerGUID, String assetManagerName, List<SchemaTypeElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (SchemaTypeElement element : results) {
                if (element == null || element.getElementHeader() == null || element.getElementHeader().getGUID() == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", (SupplementaryProperties)element.getSchemaTypeProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private void addCorrelationPropertiesToSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, List<SchemaAttributeElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (SchemaAttributeElement element : results) {
                if (element == null || element.getElementHeader() == null || element.getElementHeader().getGUID() == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), schemaAttributeGUIDParameterName, "SchemaAttribute", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), schemaAttributeGUIDParameterName, "SchemaAttribute", (SupplementaryProperties)element.getSchemaAttributeProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public String createSchemaType(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, SchemaTypeProperties schemaTypeProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", methodName);
        SchemaTypeBuilder builder = this.getSchemaTypeBuilder(schemaTypeProperties, this.repositoryHelper, this.serviceName, this.serverName, methodName);
        builder.setEffectivityDates(schemaTypeProperties.getEffectiveFrom(), schemaTypeProperties.getEffectiveTo());
        String schemaTypeGUID = this.schemaTypeHandler.addSchemaType(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), builder, schemaTypeProperties.getEffectiveFrom(), schemaTypeProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (schemaTypeGUID != null) {
            this.maintainSupplementaryProperties(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", schemaTypeProperties.getQualifiedName(), (SupplementaryProperties)schemaTypeProperties, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.createExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaTypeGUID;
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaTypeProperties schemaType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String methodName) throws InvalidParameterException {
        String typeName = "SchemaType";
        if (schemaType.getTypeName() != null) {
            typeName = schemaType.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaType", serviceName, methodName, repositoryHelper);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.getIsDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), typeGUID, typeName, schemaType.getExtendedProperties(), repositoryHelper, serviceName, serverName);
        if (schemaType instanceof LiteralSchemaTypeProperties) {
            LiteralSchemaTypeProperties literalSchemaTypeProperties = (LiteralSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(literalSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setFixedValue(literalSchemaTypeProperties.getFixedValue());
        } else if (schemaType instanceof SimpleSchemaTypeProperties) {
            SimpleSchemaTypeProperties simpleSchemaTypeProperties = (SimpleSchemaTypeProperties)schemaType;
            schemaTypeBuilder.setDataType(simpleSchemaTypeProperties.getDataType());
            schemaTypeBuilder.setDefaultValue(simpleSchemaTypeProperties.getDefaultValue());
            if (schemaType instanceof EnumSchemaTypeProperties) {
                EnumSchemaTypeProperties enumSchemaTypeProperties = (EnumSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setValidValuesSetGUID(enumSchemaTypeProperties.getValidValueSetGUID());
            } else if (schemaType instanceof ExternalSchemaTypeProperties) {
                ExternalSchemaTypeProperties externalSchemaTypeProperties = (ExternalSchemaTypeProperties)schemaType;
                schemaTypeBuilder.setExternalSchemaTypeGUID(externalSchemaTypeProperties.getExternalSchemaTypeGUID());
            }
        } else if (schemaType instanceof SchemaTypeChoiceProperties) {
            SchemaTypeChoiceProperties schemaTypeChoiceProperties = (SchemaTypeChoiceProperties)schemaType;
            if (schemaTypeChoiceProperties.getSchemaOptions() != null) {
                ArrayList<SchemaTypeBuilder> schemaOptionBuilders = new ArrayList<SchemaTypeBuilder>();
                for (SchemaTypeProperties schemaOption : schemaTypeChoiceProperties.getSchemaOptions()) {
                    if (schemaOption == null) continue;
                    schemaOptionBuilders.add(this.getSchemaTypeBuilder(schemaOption, repositoryHelper, serviceName, serverName, methodName));
                }
                if (!schemaOptionBuilders.isEmpty()) {
                    schemaTypeBuilder.setSchemaOptions(schemaOptionBuilders);
                }
            }
        } else if (schemaType instanceof MapSchemaTypeProperties) {
            MapSchemaTypeProperties mapSchemaTypeProperties = (MapSchemaTypeProperties)schemaType;
            SchemaTypeBuilder mapFromBuilder = null;
            SchemaTypeBuilder mapToBuilder = null;
            if (mapSchemaTypeProperties.getMapFromElement() != null) {
                mapFromBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapFromElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            if (mapSchemaTypeProperties.getMapToElement() != null) {
                mapToBuilder = this.getSchemaTypeBuilder(mapSchemaTypeProperties.getMapToElement(), repositoryHelper, serviceName, serverName, methodName);
            }
            schemaTypeBuilder.setMapTypes(mapFromBuilder, mapToBuilder);
        }
        return schemaTypeBuilder;
    }

    public String createSchemaTypeFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String schemaTypeGUID = this.schemaTypeHandler.createSchemaTypeFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (schemaTypeGUID != null) {
            this.createExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, false, false, null, methodName);
        }
        return schemaTypeGUID;
    }

    public void updateSchemaType(String userId, MetadataCorrelationProperties correlationProperties, String schemaTypeGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, SchemaTypeProperties schemaTypeProperties, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaTypeProperties, "schemaTypeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaTypeBuilder builder = this.getSchemaTypeBuilder(schemaTypeProperties, this.repositoryHelper, this.serviceName, this.serverName, methodName);
        this.schemaTypeHandler.updateSchemaType(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaTypeGUID, schemaTypeGUIDParameterName, builder, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.maintainSupplementaryProperties(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", schemaTypeProperties.getQualifiedName(), (SupplementaryProperties)schemaTypeProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.schemaTypeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", forLineage, forDuplicateProcessing, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        } else {
            this.schemaTypeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", forLineage, forDuplicateProcessing, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
    }

    public void clearSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = schemaTypeGUIDParameterName;
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port")) {
            this.schemaTypeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", forLineage, forDuplicateProcessing, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", effectiveTime, methodName);
        } else {
            this.schemaTypeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", forLineage, forDuplicateProcessing, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", effectiveTime, methodName);
        }
    }

    public void removeSchemaType(String userId, MetadataCorrelationProperties correlationProperties, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.schemaAttributeHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaTypeGUID, schemaTypeGUIDParameterName, "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SchemaTypeElement> findSchemaType(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaTypeHandler.findSchemaTypes(userId, null, searchString, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToSchemaTypes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public SchemaTypeElement getSchemaTypeForElement(String userId, String assetManagerGUID, String assetManagerName, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", methodName);
        SchemaTypeElement schemaTypeElement = parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, "Port") ? (SchemaTypeElement)this.schemaTypeHandler.getSchemaTypeForPort(userId, parentElementGUID, "parentElementGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName) : (SchemaTypeElement)this.schemaTypeHandler.getSchemaTypeForAsset(userId, parentElementGUID, "parentElementGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (schemaTypeElement != null) {
            schemaTypeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaTypeElement.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(schemaTypeElement.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", (SupplementaryProperties)schemaTypeElement.getSchemaTypeProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaTypeElement;
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaTypeHandler.getSchemaTypeByName(userId, null, name, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToSchemaTypes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public SchemaTypeElement getSchemaTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaTypeGUIDParameterName;
        SchemaTypeElement schemaTypeElement = (SchemaTypeElement)this.schemaTypeHandler.getSchemaType(userId, schemaTypeGUID, schemaTypeGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (schemaTypeElement != null) {
            schemaTypeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaTypeGUID, schemaTypeGUIDParameterName, "SchemaType", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(schemaTypeElement.getElementHeader().getGUID(), schemaTypeGUIDParameterName, "SchemaType", (SupplementaryProperties)schemaTypeElement.getSchemaTypeProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaTypeElement;
    }

    public ElementHeader getSchemaTypeParent(String userId, String assetManagerGUID, String assetManagerName, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaTypeGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, schemaTypeGUIDParameterName, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, schemaTypeGUID, "SchemaType", null, null, 1, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (relationship == null || relationship.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "AssetSchemaType") && !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "PortSchema")) continue;
            String parentGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
            EntityDetail parentEntity = this.schemaTypeHandler.getEntityFromRepository(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", "Referenceable", null, null, false, false, effectiveTime, methodName);
            ElementHeaderConverter<ElementHeader> headerConverter = new ElementHeaderConverter<ElementHeader>(this.repositoryHelper, this.serviceName, this.serverName);
            return headerConverter.getNewBean(ElementHeader.class, parentEntity, methodName);
        }
        return null;
    }

    public String createSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, schemaAttributeProperties, methodName);
        String schemaAttributeGUID = this.schemaAttributeHandler.createNestedSchemaAttribute(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", schemaAttributeBuilder, schemaAttributeProperties.getEffectiveFrom(), schemaAttributeProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (schemaAttributeGUID != null) {
            this.createExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.maintainSupplementaryProperties(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", schemaAttributeProperties.getQualifiedName(), (SupplementaryProperties)schemaAttributeProperties, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaAttributeGUID;
    }

    private SchemaAttributeBuilder getSchemaAttributeBuilder(String userId, SchemaAttributeProperties schemaAttributeProperties, String methodName) throws InvalidParameterException {
        String typeName = "SchemaAttribute";
        if (schemaAttributeProperties.getTypeName() != null) {
            typeName = schemaAttributeProperties.getTypeName();
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "SchemaAttribute", this.serviceName, methodName, this.repositoryHelper);
        int sortOrder = 0;
        if (schemaAttributeProperties.getSortOrder() != null) {
            sortOrder = schemaAttributeProperties.getSortOrder().getOpenTypeOrdinal();
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(schemaAttributeProperties.getQualifiedName(), schemaAttributeProperties.getDisplayName(), schemaAttributeProperties.getDescription(), schemaAttributeProperties.getElementPosition(), schemaAttributeProperties.getMinCardinality(), schemaAttributeProperties.getMaxCardinality(), schemaAttributeProperties.getIsDeprecated(), schemaAttributeProperties.getDefaultValueOverride(), schemaAttributeProperties.getAllowsDuplicateValues(), schemaAttributeProperties.getOrderedValues(), sortOrder, schemaAttributeProperties.getMinimumLength(), schemaAttributeProperties.getLength(), schemaAttributeProperties.getPrecision(), schemaAttributeProperties.getIsNullable(), schemaAttributeProperties.getNativeJavaClass(), schemaAttributeProperties.getAliases(), schemaAttributeProperties.getAdditionalProperties(), typeGUID, typeName, schemaAttributeProperties.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        if (schemaAttributeProperties.getSchemaType() != null) {
            SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaAttributeProperties.getSchemaType(), this.repositoryHelper, this.serviceName, this.serverName, methodName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        }
        return schemaAttributeBuilder;
    }

    public String createSchemaAttributeFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String schemaAttributeGUID = this.schemaAttributeHandler.createSchemaAttributeFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (schemaAttributeGUID != null) {
            this.createExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaAttributeGUID;
    }

    public void updateSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)schemaAttributeProperties, "schemaAttributeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(userId, schemaAttributeProperties, methodName);
        this.schemaAttributeHandler.updateSchemaAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaAttributeGUID, schemaAttributeGUIDParameterName, forLineage, forDuplicateProcessing, this.supportedZones, schemaAttributeBuilder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
        this.maintainSupplementaryProperties(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", schemaAttributeProperties.getQualifiedName(), (SupplementaryProperties)schemaAttributeProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaElementGUID, String formula, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "formula", formula, methodName);
        this.schemaAttributeHandler.setClassificationInRepository(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), schemaElementGUID, "schemaElementGUID", "SchemaElement", "CalculatedValue", "4814bec8-482d-463d-8376-160b0358e139", properties, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearSchemaElementAsCalculatedValue(String userId, String assetManagerGUID, String assetManagerName, String schemaElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.schemaAttributeHandler.removeClassificationFromRepository(userId, assetManagerGUID, assetManagerName, schemaElementGUID, "schemaElementGUID", "SchemaElement", "4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String primaryKeyName, KeyPattern primaryKeyPattern, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", primaryKeyName, methodName);
        int keyPatternOrdinal = 0;
        if (primaryKeyPattern != null) {
            keyPatternOrdinal = primaryKeyPattern.getOpenTypeOrdinal();
        }
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "keyPattern", "8904df8f-1aca-4de8-9abd-1ef2aadba300", "KeyPattern", keyPatternOrdinal, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)classificationNotSupported, "keyPattern");
        }
        this.schemaAttributeHandler.setClassificationInRepository(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", properties, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.schemaAttributeHandler.removeClassificationFromRepository(userId, assetManagerGUID, assetManagerName, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", "b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        Date effectiveFrom = null;
        Date effectiveTo = null;
        if (foreignKeyProperties != null) {
            effectiveFrom = foreignKeyProperties.getEffectiveFrom();
            effectiveTo = foreignKeyProperties.getEffectiveTo();
        }
        this.schemaAttributeHandler.linkElementToElement(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "SchemaAttribute", forLineage, forDuplicateProcessing, "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", this.getForeignKeyProperties(foreignKeyProperties, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    private InstanceProperties getForeignKeyProperties(ForeignKeyProperties foreignKeyProperties, String methodName) {
        InstanceProperties properties = null;
        if (foreignKeyProperties != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "name", foreignKeyProperties.getName(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", foreignKeyProperties.getDescription(), methodName);
            properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "confidence", foreignKeyProperties.getConfidence(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", foreignKeyProperties.getSteward(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", foreignKeyProperties.getSource(), methodName);
        }
        return properties;
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        this.schemaAttributeHandler.updateElementToElementLink(userId, assetManagerGUID, assetManagerName, primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "SchemaAttribute", forLineage, forDuplicateProcessing, this.supportedZones, "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", false, this.getForeignKeyProperties(foreignKeyProperties, methodName), effectiveTime, methodName);
    }

    public void clearForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryKeyGUIDParameterName = "primaryKeyGUID";
        String foreignKeyGUIDParameterName = "foreignKeyGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyGUID, "primaryKeyGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyGUID, "foreignKeyGUID", methodName);
        this.schemaAttributeHandler.unlinkElementFromElement(userId, false, assetManagerGUID, assetManagerName, primaryKeyGUID, "primaryKeyGUID", "SchemaAttribute", foreignKeyGUID, "foreignKeyGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", forLineage, forDuplicateProcessing, "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", effectiveTime, methodName);
    }

    public void removeSchemaAttribute(String userId, MetadataCorrelationProperties correlationProperties, String schemaAttributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.schemaAttributeHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), schemaAttributeGUID, schemaAttributeGUIDParameterName, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List results = this.schemaAttributeHandler.findSchemaAttributes(userId, searchString, "searchString", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<SchemaAttributeElement> getNestedAttributes(String userId, String assetManagerGUID, String assetManagerName, String parentSchemaElementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = schemaAttributeGUIDParameterName;
        List results = this.schemaAttributeHandler.getAttachedSchemaAttributes(userId, parentSchemaElementGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.schemaAttributeHandler.getSchemaAttributesByName(userId, "ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", name, null, null, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToSchemaAttributes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String assetManagerGUID, String assetManagerName, String schemaAttributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = schemaAttributeGUIDParameterName;
        SchemaAttributeElement schemaAttributeElement = (SchemaAttributeElement)this.schemaAttributeHandler.getBeanFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", false, false, effectiveTime, methodName);
        if (schemaAttributeElement != null) {
            schemaAttributeElement.setCorrelationHeaders(this.getCorrelationProperties(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, "SchemaAttribute", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(schemaAttributeElement.getElementHeader().getGUID(), schemaAttributeGUIDParameterName, "SchemaAttribute", (SupplementaryProperties)schemaAttributeElement.getSchemaAttributeProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return schemaAttributeElement;
    }
}

