/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessCallProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessCallConverter<B>
extends AssetManagerOMASConverter<B> {
    public ProcessCallConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProcessCallElement) {
                ProcessCallElement bean = (ProcessCallElement)returnBean;
                ProcessCallProperties processCallProperties = new ProcessCallProperties();
                if (relationship != null) {
                    bean.setProcessCallHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                    EntityProxy entityProxy = relationship.getEntityOneProxy();
                    if (entityProxy != null) {
                        bean.setCaller(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    if ((entityProxy = relationship.getEntityTwoProxy()) != null) {
                        bean.setCalled(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
                    processCallProperties.setQualifiedName(this.getQualifiedName(instanceProperties));
                    processCallProperties.setDescription(this.getDescription(instanceProperties));
                    processCallProperties.setFormula(this.getFormula(instanceProperties));
                    bean.setProcessCallProperties(processCallProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

