/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.connectors.outtopic.AssetManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.assetmanager.connectors.outtopic.AssetManagerOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerAuditCode;
import org.odpi.openmetadata.accessservices.assetmanager.listener.AssetManagerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetmanager.outtopic.AssetManagerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetManagerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private AssetManagerServicesInstance instance = null;
    private OpenMetadataTopicConnector inTopicConnector = null;
    private String serverName = null;
    private AssetManagerOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Asset Manager OMAS service.";
        auditLog.logMessage("Initialize Asset Manager OMAS service.", AssetManagerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new AssetManagerServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName(), AssetManagerOutTopicServerProvider.class.getName(), auditLog);
                AssetManagerOutTopicServerConnector outTopicServerConnector = (AssetManagerOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, AssetManagerOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName(), "Initialize Asset Manager OMAS service.");
                this.eventPublisher = new AssetManagerOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new AssetManagerOMRSTopicListener(AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName(), this.eventPublisher, supportedZones, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("Initialize Asset Manager OMAS service.", AssetManagerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initialize Asset Manager OMAS service.", AssetManagerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("Initialize Asset Manager OMAS service.", AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        try {
            if (this.inTopicConnector != null) {
                this.inTopicConnector.disconnect();
            }
        }
        catch (ConnectorCheckedException error) {
            this.auditLog.logException("shutdown", AssetManagerAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE.getMessageDefinition(new String[]{this.serverName}), (Throwable)error);
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", AssetManagerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

