/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataAssetExchangeHandler
extends ExchangeHandlerBase {
    private AssetHandler<DataAssetElement> assetHandler;
    private static final String assetGUIDParameterName = "assetGUID";

    public DataAssetExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.assetHandler = new AssetHandler(new AssetConverter(repositoryHelper, serviceName, serverName), DataAssetElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToDataAssets(String userId, String assetManagerGUID, String assetManagerName, List<DataAssetElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), assetGUIDParameterName, "Asset", assetManagerGUID, assetManagerName, null, methodName));
            }
        }
    }

    public String createDataAsset(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, DataAssetProperties assetProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUID;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        String typeName = "Asset";
        if (assetProperties.getTypeName() != null) {
            typeName = assetProperties.getTypeName();
        }
        if ((assetGUID = this.assetHandler.createAssetInRepository(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getTechnicalDescription(), assetProperties.getAdditionalProperties(), typeName, assetProperties.getExtendedProperties(), InstanceStatus.ACTIVE, methodName)) != null) {
            this.maintainSupplementaryProperties(userId, assetGUID, assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, false, methodName);
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        }
        return assetGUID;
    }

    public String createDataAssetFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String assetGUID = this.assetHandler.addAssetFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, "templateGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), templateProperties.getNetworkAddress(), methodName);
        if (assetGUID != null) {
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        }
        return assetGUID;
    }

    public void updateDataAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, boolean isMergeUpdate, DataAssetProperties assetProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        this.assetHandler.updateAsset(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), assetGUID, assetGUIDParameterName, assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getTechnicalDescription(), assetProperties.getAdditionalProperties(), "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", assetProperties.getExtendedProperties(), isMergeUpdate, methodName);
        this.maintainSupplementaryProperties(userId, assetGUID, assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, isMergeUpdate, methodName);
    }

    public void publishDataAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.assetHandler.publishAsset(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void withdrawDataAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.withdrawAsset(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void removeDataAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, methodName);
        this.assetHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", null, null, false, false, new Date(), methodName);
    }

    public void setDataAssetAsReferenceData(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public void clearDataAssetAsReferenceData(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, methodName);
    }

    public List<DataAssetElement> findDataAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List results = this.assetHandler.findAssets(userId, searchString, "searchString", startFrom, pageSize, new Date(), methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<DataAssetElement> scanDataAssets(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.assetHandler.assetScan(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", startFrom, pageSize, new Date(), methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<DataAssetElement> getDataAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        List results = this.assetHandler.findAssetsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, new Date(), methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String assetEntityParameterName = "assetEntity";
        String assetGUIDParameterName = "assetEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        Date effectiveTime = new Date();
        ArrayList<DataAssetElement> results = new ArrayList<DataAssetElement>();
        List assetEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareServerCapability", "Asset", startFrom, pageSize, effectiveTime, methodName);
        if (assetEntities != null) {
            for (EntityDetail assetEntity : assetEntities) {
                DataAssetElement dataAssetElement;
                if (assetEntity == null || (dataAssetElement = (DataAssetElement)this.assetHandler.getBeanFromEntity(userId, assetEntity, "assetEntity", methodName)) == null) continue;
                dataAssetElement.setCorrelationHeaders(this.getCorrelationProperties(userId, assetEntity.getGUID(), "assetEntity.getGUID()", "Asset", assetManagerGUID, assetManagerName, effectiveTime, methodName));
                results.add(dataAssetElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        Date effectiveTime = new Date();
        DataAssetElement asset = (DataAssetElement)this.assetHandler.getBeanFromRepository(userId, openMetadataGUID, "openMetadataGUID", "Asset", false, false, effectiveTime, methodName);
        if (asset != null) {
            asset.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "Asset", assetManagerGUID, assetManagerName, effectiveTime, methodName));
        }
        return asset;
    }
}

