/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeadersResponse;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.LoggerFactory;

public class AssetManagerRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetManagerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createExternalAssetManager(String serverName, String userId, AssetManagerProperties assetManagerProperties) {
        String methodName = "createExternalAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalAssetManager");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalAssetManager");
            if (assetManagerProperties != null) {
                SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "createExternalAssetManager");
                response.setGUID(handler.createSoftwareServerCapability(userId, null, null, "f4fffcc0-d9eb-4bb9-8aff-0718932f689e", "Catalog", "AssetManager", assetManagerProperties.getQualifiedName(), assetManagerProperties.getDisplayName(), assetManagerProperties.getDescription(), assetManagerProperties.getTypeDescription(), assetManagerProperties.getVersion(), assetManagerProperties.getPatchLevel(), assetManagerProperties.getSource(), assetManagerProperties.getAdditionalProperties(), assetManagerProperties.getVendorProperties(), null, null, "createExternalAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalAssetManager", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createExternalAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getExternalAssetManagerGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalAssetManagerGUID";
        String nameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalAssetManagerGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalAssetManagerGUID");
            SoftwareServerCapabilityHandler<SoftwareServerCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "getExternalAssetManagerGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", qualifiedName, "qualifiedName", false, false, new Date(), "getExternalAssetManagerGUID"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalAssetManagerGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addExternalIdentifier(String serverName, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, MetadataCorrelationProperties requestBody) {
        String methodName = "addExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addExternalIdentifier");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "addExternalIdentifier");
                int permittedSynchronizationOrdinal = SynchronizationDirection.BOTH_DIRECTIONS.getOpenTypeOrdinal();
                if (requestBody.getSynchronizationDirection() != null) {
                    permittedSynchronizationOrdinal = requestBody.getSynchronizationDirection().getOpenTypeOrdinal();
                }
                int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
                if (requestBody.getKeyPattern() != null) {
                    keyPatternOrdinal = requestBody.getKeyPattern().getOpenTypeOrdinal();
                }
                handler.setUpExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getExternalIdentifier(), "correlationProperties.externalIdentifier", keyPatternOrdinal, requestBody.getExternalIdentifierName(), requestBody.getExternalIdentifierUsage(), requestBody.getExternalIdentifierSource(), requestBody.getMappingProperties(), requestBody.getAssetManagerGUID(), "assetManagerGUID", requestBody.getAssetManagerName(), "SoftwareServerCapability", permittedSynchronizationOrdinal, requestBody.getSynchronizationDescription(), null, "addExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalIdentifier(String serverName, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, MetadataCorrelationProperties requestBody) {
        String methodName = "updateExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalIdentifier");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "updateExternalIdentifier");
                int permittedSynchronizationOrdinal = SynchronizationDirection.BOTH_DIRECTIONS.getOpenTypeOrdinal();
                if (requestBody.getSynchronizationDirection() != null) {
                    permittedSynchronizationOrdinal = requestBody.getSynchronizationDirection().getOpenTypeOrdinal();
                }
                int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
                if (requestBody.getKeyPattern() != null) {
                    keyPatternOrdinal = requestBody.getKeyPattern().getOpenTypeOrdinal();
                }
                handler.setUpExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getExternalIdentifier(), "correlationProperties.externalIdentifier", keyPatternOrdinal, requestBody.getExternalIdentifierName(), requestBody.getExternalIdentifierUsage(), requestBody.getExternalIdentifierSource(), requestBody.getMappingProperties(), requestBody.getAssetManagerGUID(), "assetManagerGUID", requestBody.getAssetManagerName(), "SoftwareServerCapability", permittedSynchronizationOrdinal, requestBody.getSynchronizationDescription(), null, "updateExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeExternalIdentifier(String serverName, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, MetadataCorrelationProperties requestBody) {
        String methodName = "removeExternalIdentifier";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeExternalIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeExternalIdentifier");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "removeExternalIdentifier");
                int permittedSynchronizationOrdinal = SynchronizationDirection.BOTH_DIRECTIONS.getOpenTypeOrdinal();
                if (requestBody.getSynchronizationDirection() != null) {
                    permittedSynchronizationOrdinal = requestBody.getSynchronizationDirection().getOpenTypeOrdinal();
                }
                int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
                if (requestBody.getKeyPattern() != null) {
                    keyPatternOrdinal = requestBody.getKeyPattern().getOpenTypeOrdinal();
                }
                handler.removeExternalIdentifier(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getExternalIdentifier(), "correlationProperties.externalIdentifier", keyPatternOrdinal, requestBody.getExternalIdentifierName(), requestBody.getExternalIdentifierUsage(), requestBody.getExternalIdentifierSource(), requestBody.getMappingProperties(), requestBody.getAssetManagerGUID(), "assetManagerGUID", requestBody.getAssetManagerName(), "AssetManager", permittedSynchronizationOrdinal, requestBody.getSynchronizationDescription(), "removeExternalIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse confirmSynchronization(String serverName, String userId, String openMetadataElementGUID, String openMetadataElementTypeName, MetadataCorrelationProperties requestBody) {
        String methodName = "confirmSynchronization";
        String openMetadataElementGUIDParameterName = "openMetadataElementGUID";
        String externalIdentifierParameterName = "externalIdentifier";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "confirmSynchronization");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "confirmSynchronization");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "confirmSynchronization");
                handler.confirmSynchronization(userId, openMetadataElementGUID, "openMetadataElementGUID", openMetadataElementTypeName, requestBody.getExternalIdentifier(), "externalIdentifier", requestBody.getAssetManagerGUID(), "assetManagerGUID", requestBody.getAssetManagerName(), "SoftwareServerCapability", null, "confirmSynchronization");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "confirmSynchronization", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "confirmSynchronization", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementHeadersResponse getElementsForExternalIdentifier(String serverName, String userId, int startFrom, int pageSize, MetadataCorrelationProperties requestBody) {
        String methodName = "getElementsForExternalIdentifier";
        String assetManagerGUIDParameterName = "assetManagerGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsForExternalIdentifier");
        ElementHeadersResponse response = new ElementHeadersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsForExternalIdentifier");
            if (requestBody != null) {
                ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "getElementsForExternalIdentifier");
                response.setElementList(handler.getElementsForExternalIdentifier(userId, requestBody.getAssetManagerGUID(), "assetManagerGUID", "AssetManager", requestBody.getAssetManagerName(), requestBody.getExternalIdentifier(), startFrom, pageSize, null, "getElementsForExternalIdentifier"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getElementsForExternalIdentifier", serverName);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsForExternalIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

