/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SoftwareServerCapabilityElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SoftwareServerCapabilitiesProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetManagerConverter<B>
extends AssetManagerOMASConverter<B> {
    public AssetManagerConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SoftwareServerCapabilityElement) {
                SoftwareServerCapabilityElement bean = (SoftwareServerCapabilityElement)returnBean;
                AssetManagerProperties assetManagerProperties = new AssetManagerProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    assetManagerProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    assetManagerProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    assetManagerProperties.setDisplayName(this.removeName(instanceProperties));
                    assetManagerProperties.setDescription(this.removeDescription(instanceProperties));
                    assetManagerProperties.setTypeDescription(this.removeDeployedImplementationType(instanceProperties));
                    assetManagerProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    assetManagerProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    assetManagerProperties.setSource(this.removeSource(instanceProperties));
                    assetManagerProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    assetManagerProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setSoftwareServerCapabilitiesProperties((SoftwareServerCapabilitiesProperties)assetManagerProperties);
                } else {
                    this.handleMissingMetadataInstance(AssetManagerProperties.class.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

