/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.listener;

import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.outtopic.AssetManagerOutTopicPublisher;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetManagerOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(AssetManagerOMRSTopicListener.class);
    private AssetManagerOutTopicPublisher eventPublisher;
    private DataAssetExchangeHandler dataAssetExchangeHandler;
    private String localServerUserId;

    public AssetManagerOMRSTopicListener(String serviceName, String localServerUserId, AssetManagerOutTopicPublisher eventPublisher, DataAssetExchangeHandler dataAssetExchangeHandler, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.dataAssetExchangeHandler = dataAssetExchangeHandler;
        this.localServerUserId = localServerUserId;
        this.eventPublisher = eventPublisher;
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Received new Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing new Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.NEW_ELEMENT_CREATED);
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        log.debug("Received updated Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, newEntity)) {
            log.debug("Publishing updated Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_UPDATED, newEntity, oldEntity, null, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        log.debug("Received classified Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing classified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_CLASSIFIED, entity, null, classification, null);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        this.processClassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        log.debug("Receiving declassified Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing declassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_DECLASSIFIED, entity, null, null, originalClassification);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        this.processDeclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        log.debug("Receiving reclassified Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing reclassified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(AssetManagerEventType.ELEMENT_RECLASSIFIED, entity, null, classification, originalClassification);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        this.processReclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, null);
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving deleted Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing deleted Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.ELEMENT_DELETED);
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing delete-purge entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing delete-purge entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.ELEMENT_DELETED);
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving restored Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing restored Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.ELEMENT_RESTORED);
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        log.debug("Processing re-identified Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing re-identified Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.ELEMENT_GUID_CHANGED);
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        log.debug("Processing re-typed Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing re-typed Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.ELEMENT_TYPE_CHANGED);
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Receiving refresh Entity event from: " + sourceName);
        if (this.dataAssetExchangeHandler.entityOfInterest(this.localServerUserId, entity)) {
            log.debug("Publishing refresh Entity event from: " + sourceName);
            this.eventPublisher.publishEntityEvent(entity, AssetManagerEventType.REFRESH_ELEMENT_EVENT);
        }
    }
}

