/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class DataAssetExchangeRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataAssetExchangeRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDataAsset(String serverName, String userId, boolean assetManagerIsHome, DataAssetRequestBody requestBody) {
        String methodName = "createDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "createDataAsset");
                response.setGUID(handler.createDataAsset(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createDataAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDataAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataAssetFromTemplate(String serverName, String userId, boolean assetManagerIsHome, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDataAssetFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataAssetFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataAssetFromTemplate");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "createDataAssetFromTemplate");
                response.setGUID(handler.createDataAssetFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createDataAssetFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDataAssetFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createDataAssetFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataAsset(String serverName, String userId, String assetGUID, boolean isMergeUpdate, DataAssetRequestBody requestBody) {
        String methodName = "updateDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "updateDataAsset");
                handler.updateDataAsset(userId, requestBody.getMetadataCorrelationProperties(), assetGUID, isMergeUpdate, requestBody.getElementProperties(), "updateDataAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataAsset", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDataAsset(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "publishDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "publishDataAsset");
            handler.publishDataAsset(userId, assetGUID, "publishDataAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDataAsset(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "withdrawDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "withdrawDataAsset");
            handler.withdrawDataAsset(userId, assetGUID, "withdrawDataAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDataAsset(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "removeDataAsset");
            handler.removeDataAsset(userId, requestBody, assetGUID, "removeDataAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setDataAssetAsReferenceData(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "setDataAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDataAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setDataAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "setDataAssetAsReferenceData");
            handler.setDataAssetAsReferenceData(userId, assetGUID, "setDataAssetAsReferenceData");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setDataAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDataAssetAsReferenceData(String serverName, String userId, String assetGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearDataAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDataAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearDataAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "clearDataAssetAsReferenceData");
            handler.clearDataAssetAsReferenceData(userId, assetGUID, "clearDataAssetAsReferenceData");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearDataAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse findDataAssets(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findDataAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDataAssets");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataAssets");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "findDataAssets");
                response.setElementList(handler.findDataAssets(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, "findDataAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDataAssets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findDataAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse scanDataAssets(String serverName, String userId, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "scanDataAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "scanDataAssets");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "scanDataAssets");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "scanDataAssets");
                response.setElementList(handler.scanDataAssets(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, "scanDataAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "scanDataAssets", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "scanDataAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse getDataAssetsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getDataAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetsByName");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetsByName");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetsByName");
            if (requestBody != null) {
                response.setElementList(handler.getDataAssetsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, "getDataAssetsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDataAssetsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse getDataAssetsForAssetManager(String serverName, String userId, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getDataAssetsForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetsForAssetManager");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetsForAssetManager");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetsForAssetManager");
                response.setElementList(handler.getDataAssetsForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, "getDataAssetsForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDataAssetsForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataAssetsForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementResponse getDataAssetByGUID(String serverName, String userId, String assetGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getDataAssetByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetByGUID");
        DataAssetElementResponse response = new DataAssetElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetByGUID");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetByGUID");
            if (requestBody != null) {
                response.setElement(handler.getDataAssetByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetGUID, "getDataAssetByGUID"));
            } else {
                response.setElement(handler.getDataAssetByGUID(userId, null, null, assetGUID, "getDataAssetByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataAssetByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

