/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.SchemaExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ForeignKeyRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PrimaryKeyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaAttributeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class SchemaExchangeRESTServices {
    private static AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SchemaExchangeRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createSchemaType(String serverName, String userId, boolean assetManagerIsHome, SchemaTypeRequestBody requestBody) {
        String methodName = "createSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaType");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "createSchemaType");
                response.setGUID(handler.createSchemaType(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createSchemaType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaTypeFromTemplate(String serverName, String userId, String templateGUID, boolean assetManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createSchemaTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaTypeFromTemplate");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "createSchemaTypeFromTemplate");
                response.setGUID(handler.createSchemaTypeFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createSchemaTypeFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSchemaTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaType(String serverName, String userId, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeRequestBody requestBody) {
        String methodName = "updateSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaType");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "updateSchemaType");
                handler.updateSchemaType(userId, requestBody.getMetadataCorrelationProperties(), schemaTypeGUID, isMergeUpdate, requestBody.getElementProperties(), "updateSchemaType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSchemaTypeParent(String serverName, String userId, String parentElementGUID, String parentElementTypeName, String schemaTypeGUID, boolean assetManagerIsHome, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "setupSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSchemaTypeParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSchemaTypeParent");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "setupSchemaTypeParent");
                handler.setupSchemaTypeParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, schemaTypeGUID, parentElementGUID, parentElementTypeName, "setupSchemaTypeParent");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupSchemaTypeParent", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaTypeParent(String serverName, String userId, String parentElementGUID, String parentElementTypeName, String schemaTypeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaTypeParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaTypeParent");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "clearSchemaTypeParent");
                handler.clearSchemaTypeParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaTypeGUID, parentElementGUID, parentElementTypeName, "clearSchemaTypeParent");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearSchemaTypeParent", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaType(String serverName, String userId, String schemaTypeGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaType");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "removeSchemaType");
                handler.removeSchemaType(userId, requestBody, schemaTypeGUID, "removeSchemaType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementsResponse findSchemaType(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaType");
        SchemaTypeElementsResponse response = new SchemaTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaType");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "findSchemaType");
                response.setElementList(handler.findSchemaType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, "findSchemaType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementResponse getSchemaTypeForElement(String serverName, String userId, String parentElementGUID, String parentElementTypeName, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSchemaTypeForElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeForElement");
        SchemaTypeElementResponse response = new SchemaTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeForElement");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaTypeForElement");
                response.setElement(handler.getSchemaTypeForElement(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), parentElementGUID, parentElementTypeName, "getSchemaTypeForElement"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeForElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaTypeForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementsResponse getSchemaTypeByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getSchemaTypeByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByName");
        SchemaTypeElementsResponse response = new SchemaTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByName");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaTypeByName");
                response.setElementList(handler.getSchemaTypeByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, "getSchemaTypeByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaTypeByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaTypeElementResponse getSchemaTypeByGUID(String serverName, String userId, String schemaTypeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSchemaTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeByGUID");
        SchemaTypeElementResponse response = new SchemaTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeByGUID");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaTypeByGUID");
                response.setElement(handler.getSchemaTypeByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaTypeGUID, "getSchemaTypeByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementHeaderResponse getSchemaTypeParent(String serverName, String userId, String schemaTypeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSchemaTypeParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaTypeParent");
        ElementHeaderResponse response = new ElementHeaderResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaTypeParent");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaTypeParent");
                response.setElement(handler.getSchemaTypeParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaTypeGUID, "getSchemaTypeParent"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaTypeParent", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaTypeParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttribute(String serverName, String userId, String schemaElementGUID, boolean assetManagerIsHome, SchemaAttributeRequestBody requestBody) {
        String methodName = "createSchemaAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttribute");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttribute");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "createSchemaAttribute");
                response.setGUID(handler.createSchemaAttribute(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, schemaElementGUID, requestBody.getElementProperties(), "createSchemaAttribute"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSchemaAttributeFromTemplate(String serverName, String userId, String schemaElementGUID, String templateGUID, boolean assetManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createSchemaAttributeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSchemaAttributeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSchemaAttributeFromTemplate");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "createSchemaAttributeFromTemplate");
                response.setGUID(handler.createSchemaAttributeFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, schemaElementGUID, templateGUID, requestBody.getElementProperties(), "createSchemaAttributeFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSchemaAttributeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSchemaAttributeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeRequestBody requestBody) {
        String methodName = "updateSchemaAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSchemaAttribute");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "updateSchemaAttribute");
                handler.updateSchemaAttribute(userId, requestBody.getMetadataCorrelationProperties(), schemaAttributeGUID, isMergeUpdate, requestBody.getElementProperties(), "updateSchemaAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setSchemaElementAsCalculatedValue(String serverName, String userId, String schemaElementGUID, boolean assetManagerIsHome, MetadataCorrelationProperties requestBody) {
        String methodName = "setSchemaElementAsCalculatedValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setSchemaElementAsCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setSchemaElementAsCalculatedValue");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "setSchemaElementAsCalculatedValue");
                handler.setSchemaElementAsCalculatedValue(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, schemaElementGUID, requestBody.getExternalIdentifier(), "setSchemaElementAsCalculatedValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setSchemaElementAsCalculatedValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setSchemaElementAsCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSchemaElementAsCalculatedValue(String serverName, String userId, String schemaElementGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearSchemaElementAsCalculatedValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSchemaElementAsCalculatedValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSchemaElementAsCalculatedValue");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "clearSchemaElementAsCalculatedValue");
                handler.clearSchemaElementAsCalculatedValue(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaElementGUID, "clearSchemaElementAsCalculatedValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearSchemaElementAsCalculatedValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSchemaElementAsCalculatedValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupColumnAsPrimaryKey(String serverName, String userId, String schemaAttributeGUID, boolean assetManagerIsHome, PrimaryKeyClassificationRequestBody requestBody) {
        String methodName = "setupColumnAsPrimaryKey";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupColumnAsPrimaryKey");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupColumnAsPrimaryKey");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "setupColumnAsPrimaryKey");
                handler.setupColumnAsPrimaryKey(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, schemaAttributeGUID, requestBody.getPrimaryKeyProperties().getName(), requestBody.getPrimaryKeyProperties().getKeyPattern(), "setupColumnAsPrimaryKey");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupColumnAsPrimaryKey", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupColumnAsPrimaryKey", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearColumnAsPrimaryKey(String serverName, String userId, String schemaAttributeGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "clearColumnAsPrimaryKey";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearColumnAsPrimaryKey");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearColumnAsPrimaryKey");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "clearColumnAsPrimaryKey");
                handler.clearColumnAsPrimaryKey(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaAttributeGUID, "clearColumnAsPrimaryKey");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearColumnAsPrimaryKey", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearColumnAsPrimaryKey", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupForeignKeyRelationship(String serverName, String userId, String primaryKeyGUID, String foreignKeyGUID, boolean assetManagerIsHome, ForeignKeyRequestBody requestBody) {
        String methodName = "setupForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupForeignKeyRelationship");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "setupForeignKeyRelationship");
                handler.setupForeignKeyRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, primaryKeyGUID, foreignKeyGUID, requestBody.getProperties(), "setupForeignKeyRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupForeignKeyRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateForeignKeyRelationship(String serverName, String userId, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyRequestBody requestBody) {
        String methodName = "updateForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateForeignKeyRelationship");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "updateForeignKeyRelationship");
                handler.updateForeignKeyRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), primaryKeyGUID, foreignKeyGUID, requestBody.getProperties(), "updateForeignKeyRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateForeignKeyRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearForeignKeyRelationship(String serverName, String userId, String primaryKeyGUID, String foreignKeyGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "clearForeignKeyRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearForeignKeyRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearForeignKeyRelationship");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "clearForeignKeyRelationship");
                handler.clearForeignKeyRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), primaryKeyGUID, foreignKeyGUID, "clearForeignKeyRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearForeignKeyRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearForeignKeyRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSchemaAttribute(String serverName, String userId, String schemaAttributeGUID, MetadataCorrelationProperties requestBody) {
        String methodName = "removeSchemaAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSchemaAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSchemaAttribute");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "removeSchemaAttribute");
                handler.removeSchemaAttribute(userId, requestBody, schemaAttributeGUID, "removeSchemaAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeSchemaAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeSchemaAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeElementsResponse findSchemaAttributes(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSchemaAttributes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSchemaAttributes");
        SchemaAttributeElementsResponse response = new SchemaAttributeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findSchemaAttributes");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "findSchemaAttributes");
                handler.findSchemaAttributes(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, "findSchemaAttributes");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findSchemaAttributes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeElementsResponse getAttributesForSchemaType(String serverName, String userId, String schemaTypeGUID, int startFrom, int pageSize, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getAttributesForSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAttributesForSchemaType");
        SchemaAttributeElementsResponse response = new SchemaAttributeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttributesForSchemaType");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getAttributesForSchemaType");
                handler.getAttributesForSchemaType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaTypeGUID, startFrom, pageSize, "getAttributesForSchemaType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAttributesForSchemaType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttributesForSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeElementsResponse getSchemaAttributesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getSchemaAttributesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributesByName");
        SchemaAttributeElementsResponse response = new SchemaAttributeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributesByName");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaAttributesByName");
                handler.getSchemaAttributesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, "getSchemaAttributesByName");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaAttributesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaAttributesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributeElementResponse getSchemaAttributeByGUID(String serverName, String userId, String schemaAttributeGUID, AssetManagerIdentifiersRequestBody requestBody) {
        String methodName = "getSchemaAttributeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributeByGUID");
        SchemaAttributeElementResponse response = new SchemaAttributeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributeByGUID");
            if (requestBody != null) {
                SchemaExchangeHandler handler = instanceHandler.getSchemaExchangeHandler(userId, serverName, "getSchemaAttributeByGUID");
                handler.getSchemaAttributeByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), schemaAttributeGUID, "getSchemaAttributeByGUID");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getSchemaAttributeByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaAttributeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

