/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ExternalIdentifierConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class ExchangeHandlerBase {
    InvalidParameterHandler invalidParameterHandler;
    ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> externalIdentifierHandler;
    String serviceName;
    String serverName;
    OMRSRepositoryHelper repositoryHelper;
    RepositoryHandler repositoryHandler;
    List<String> supportedZones;

    ExchangeHandlerBase(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.externalIdentifierHandler = new ExternalIdentifierHandler(new ExternalIdentifierConverter(repositoryHelper, serviceName, serverName), MetadataCorrelationHeader.class, new ElementHeaderConverter(repositoryHelper, serviceName, serverName), ElementHeader.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.invalidParameterHandler = invalidParameterHandler;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    String getExternalSourceGUID(MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome) {
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerGUID();
        }
        return null;
    }

    String getExternalSourceGUID(String assetManagerGUID, boolean assetManagerIsHome) {
        if (assetManagerIsHome) {
            return assetManagerGUID;
        }
        return null;
    }

    String getExternalSourceGUID(MetadataCorrelationProperties correlationProperties) {
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerGUID();
        }
        return null;
    }

    String getExternalSourceName(MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome) {
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerName();
        }
        return null;
    }

    String getExternalSourceName(String assetManagerName, boolean assetManagerIsHome) {
        if (assetManagerIsHome) {
            return assetManagerName;
        }
        return null;
    }

    String getExternalSourceName(MetadataCorrelationProperties correlationProperties) {
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerName();
        }
        return null;
    }

    void createExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, MetadataCorrelationProperties correlationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        String typeNameParameterName = "elementTypeName";
        String assetManagerGUIDParameterName = "correlationProperties.assetManagerGUID";
        String assetManagerNameParameterName = "correlationProperties.assetManagerName";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.invalidParameterHandler.validateName(elementTypeName, "elementTypeName", methodName);
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null && correlationProperties.getExternalIdentifier() != null) {
            this.invalidParameterHandler.validateName(correlationProperties.getAssetManagerName(), "correlationProperties.assetManagerName", methodName);
            this.externalIdentifierHandler.setUpExternalIdentifier(userId, elementGUID, elementGUIDParameterName, elementTypeName, correlationProperties.getExternalIdentifier(), "correlationProperties.externalIdentifier", this.getKeyPattern(correlationProperties.getKeyPattern()), correlationProperties.getExternalIdentifierName(), correlationProperties.getExternalIdentifierUsage(), correlationProperties.getExternalIdentifierSource(), correlationProperties.getMappingProperties(), correlationProperties.getAssetManagerGUID(), "correlationProperties.assetManagerGUID", correlationProperties.getAssetManagerName(), "SoftwareCapability", this.getPermittedSynchronization(correlationProperties.getSynchronizationDirection()), correlationProperties.getSynchronizationDescription(), null, methodName);
        }
    }

    private int getPermittedSynchronization(SynchronizationDirection synchronizationDirection) {
        int permittedSynchronization = SynchronizationDirection.BOTH_DIRECTIONS.getOpenTypeOrdinal();
        if (synchronizationDirection != null) {
            permittedSynchronization = synchronizationDirection.getOpenTypeOrdinal();
        }
        return permittedSynchronization;
    }

    private int getKeyPattern(KeyPattern keyPattern) {
        int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
        if (keyPattern != null) {
            keyPatternOrdinal = keyPattern.getOpenTypeOrdinal();
        }
        return keyPatternOrdinal;
    }

    EntityDetail validateExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, MetadataCorrelationProperties correlationProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdentifierParameterName = "correlationProperties.getExternalIdentifier()";
        String scopeGUIDParameterName = "correlationProperties.getAssetManagerGUID()";
        if (correlationProperties != null && correlationProperties.getExternalIdentifier() != null && correlationProperties.getAssetManagerGUID() != null && correlationProperties.getAssetManagerName() != null) {
            return this.externalIdentifierHandler.confirmSynchronization(userId, elementGUID, elementGUIDParameterName, elementTypeName, correlationProperties.getExternalIdentifier(), "correlationProperties.getExternalIdentifier()", correlationProperties.getAssetManagerGUID(), "correlationProperties.getAssetManagerGUID()", correlationProperties.getAssetManagerName(), "SoftwareCapability", null, methodName);
        }
        return null;
    }

    List<MetadataCorrelationHeader> getCorrelationProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String assetManagerGUID, String assetManagerName, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalIdentifierHandler.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, assetManagerGUID, "SoftwareCapability", assetManagerName, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
    }

    void maintainSupplementaryProperties(String userId, String elementGUID, String elementQualifiedName, SupplementaryProperties supplementaryProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (supplementaryProperties != null) {
            this.externalIdentifierHandler.maintainSupplementaryProperties(userId, elementGUID, elementQualifiedName, supplementaryProperties.getDisplayName(), supplementaryProperties.getSummary(), supplementaryProperties.getDescription(), supplementaryProperties.getAbbreviation(), supplementaryProperties.getUsage(), isMergeUpdate, methodName);
        } else if (!isMergeUpdate) {
            this.externalIdentifierHandler.maintainSupplementaryProperties(userId, elementGUID, elementQualifiedName, null, null, null, null, null, false, methodName);
        }
    }
}

