/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.connectors.outtopic.AssetManagerOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ExternalIdentifierConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GovernanceActionConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GovernanceActionProcessConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GovernanceActionTypeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerErrorCode;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.GlossaryExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ProcessExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.SchemaExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetManagerServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_MANAGER_OMAS;
    private SoftwareCapabilityHandler<SoftwareCapabilityElement> assetManagerHandler;
    private ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> externalIdentifierHandler;
    private DataAssetExchangeHandler dataAssetExchangeHandler;
    private GlossaryExchangeHandler glossaryExchangeHandler;
    private ProcessExchangeHandler processExchangeHandler;
    private SchemaExchangeHandler schemaExchangeHandler;
    private GovernanceActionHandler<GovernanceActionElement> governanceActionHandler;
    private AssetHandler<GovernanceActionProcessElement> governanceActionProcessHandler;
    private GovernanceActionTypeHandler<GovernanceActionTypeElement> governanceActionTypeHandler;

    public AssetManagerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicConnection) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, localServerUserId, maxPageSize, null, null, AssetManagerOutTopicClientProvider.class.getName(), outTopicConnection);
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(AssetManagerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.assetManagerHandler = new SoftwareCapabilityHandler(new AssetManagerConverter(this.repositoryHelper, this.serviceName, this.serverName), SoftwareCapabilityElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.externalIdentifierHandler = new ExternalIdentifierHandler(new ExternalIdentifierConverter(this.repositoryHelper, this.serviceName, this.serverName), MetadataCorrelationHeader.class, new ElementHeaderConverter(this.repositoryHelper, this.serviceName, this.serverName), ElementHeader.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.dataAssetExchangeHandler = new DataAssetExchangeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryExchangeHandler = new GlossaryExchangeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.processExchangeHandler = new ProcessExchangeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaExchangeHandler = new SchemaExchangeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceActionHandler = new GovernanceActionHandler(new GovernanceActionConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceActionProcessHandler = new AssetHandler(new GovernanceActionProcessConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionProcessElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceActionTypeHandler = new GovernanceActionTypeHandler(new GovernanceActionTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionTypeElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    SoftwareCapabilityHandler<SoftwareCapabilityElement> getAssetManagerIntegratorHandler() throws PropertyServerException {
        String methodName = "getAssetManagerIntegratorHandler";
        this.validateActiveRepository("getAssetManagerIntegratorHandler");
        return this.assetManagerHandler;
    }

    ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> getExternalIdentifierHandler() throws PropertyServerException {
        String methodName = "getExternalIdentifierHandler";
        this.validateActiveRepository("getExternalIdentifierHandler");
        return this.externalIdentifierHandler;
    }

    DataAssetExchangeHandler getDataAssetExchangeHandler() throws PropertyServerException {
        String methodName = "getDataAssetExchangeHandler";
        this.validateActiveRepository("getDataAssetExchangeHandler");
        return this.dataAssetExchangeHandler;
    }

    GlossaryExchangeHandler getGlossaryExchangeHandler() throws PropertyServerException {
        String methodName = "getGlossaryExchangeHandler";
        this.validateActiveRepository("getGlossaryExchangeHandler");
        return this.glossaryExchangeHandler;
    }

    ProcessExchangeHandler getProcessExchangeHandler() throws PropertyServerException {
        String methodName = "getProcessExchangeHandler";
        this.validateActiveRepository("getProcessExchangeHandler");
        return this.processExchangeHandler;
    }

    SchemaExchangeHandler getSchemaExchangeHandler() throws PropertyServerException {
        String methodName = "getSchemaExchangeHandler";
        this.validateActiveRepository("getSchemaExchangeHandler");
        return this.schemaExchangeHandler;
    }

    public AssetHandler<GovernanceActionProcessElement> getGovernanceActionProcessHandler() {
        return this.governanceActionProcessHandler;
    }

    GovernanceActionTypeHandler<GovernanceActionTypeElement> getGovernanceActionTypeHandler() {
        return this.governanceActionTypeHandler;
    }

    GovernanceActionHandler<GovernanceActionElement> getGovernanceActionHandler() {
        return this.governanceActionHandler;
    }
}

