/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalReferenceLinkConverter<B>
extends AssetManagerOMASConverter<B> {
    public ExternalReferenceLinkConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ExternalReferenceLinkElement) {
                InstanceProperties instanceProperties;
                ExternalReferenceLinkElement bean = (ExternalReferenceLinkElement)returnBean;
                ExternalReferenceProperties externalReferenceProperties = new ExternalReferenceProperties();
                ExternalReferenceLinkProperties linkProperties = new ExternalReferenceLinkProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    externalReferenceProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    externalReferenceProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    externalReferenceProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    externalReferenceProperties.setDescription(this.removeDescription(instanceProperties));
                    externalReferenceProperties.setUrl(this.removeURL(instanceProperties));
                    externalReferenceProperties.setVersion(this.removeReferenceVersion(instanceProperties));
                    externalReferenceProperties.setOrganization(this.removeOrganization(instanceProperties));
                    bean.setProperties(externalReferenceProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    linkProperties.setLinkId(this.removeReferenceId(instanceProperties));
                    linkProperties.setLinkDescription(this.removeDescription(instanceProperties));
                    bean.setLink(linkProperties);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

