/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GlossaryCategoryConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GlossaryConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.GlossaryTermConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermActivityType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryExchangeHandler
extends ExchangeHandlerBase {
    private final GlossaryHandler<GlossaryElement> glossaryHandler;
    private final GlossaryCategoryHandler<GlossaryCategoryElement> glossaryCategoryHandler;
    private final GlossaryTermHandler<GlossaryTermElement> glossaryTermHandler;
    private static final String glossaryGUIDParameterName = "glossaryGUID";
    private static final String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
    private static final String glossaryTermGUIDParameterName = "glossaryTermGUID";

    public GlossaryExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryHandler = new GlossaryHandler(new GlossaryConverter(repositoryHelper, serviceName, serverName), GlossaryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryCategoryHandler = new GlossaryCategoryHandler(new GlossaryCategoryConverter(repositoryHelper, serviceName, serverName), GlossaryCategoryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryTermHandler = new GlossaryTermHandler(new GlossaryTermConverter(repositoryHelper, serviceName, serverName), GlossaryTermElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToGlossaries(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryGUIDParameterName, "Glossary", assetManagerGUID, assetManagerName, false, false, null, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryCategoryElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryCategoryGUIDParameterName, "GlossaryCategory", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryTermElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), glossaryTermGUIDParameterName, "GlossaryTerm", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    public String createGlossary(String userId, MetadataCorrelationProperties correlationProperties, GlossaryProperties glossaryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossary(userId, glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        }
        return glossaryGUID;
    }

    public String createGlossaryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossaryFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        }
        return glossaryGUID;
    }

    public void updateGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, GlossaryProperties glossaryProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        this.glossaryHandler.updateGlossary(userId, glossaryGUID, glossaryGUIDParameterName, glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), isMergeUpdate, methodName);
    }

    public void removeGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        if (correlationProperties != null) {
            this.glossaryHandler.removeGlossary(userId, correlationProperties.getAssetManagerGUID(), correlationProperties.getAssetManagerName(), glossaryGUID, glossaryGUIDParameterName, methodName);
        } else {
            this.glossaryHandler.removeGlossary(userId, null, null, glossaryGUID, glossaryGUIDParameterName, methodName);
        }
    }

    public void setGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String organizingPrinciple, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        this.glossaryHandler.addTaxonomyClassificationToGlossary(userId, glossaryGUID, glossaryGUIDParameterName, organizingPrinciple, methodName);
    }

    public void clearGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        this.glossaryHandler.removeTaxonomyClassificationFromGlossary(userId, glossaryGUID, glossaryGUIDParameterName, methodName);
    }

    public void setGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String scope, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        this.glossaryHandler.addCanonicalVocabClassificationToGlossary(userId, glossaryGUID, glossaryGUIDParameterName, scope, methodName);
    }

    public void clearGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, "Glossary", correlationProperties, false, false, null, methodName);
        this.glossaryHandler.removeCanonicalVocabClassificationFromGlossary(userId, glossaryGUID, glossaryGUIDParameterName, methodName);
    }

    public List<GlossaryElement> findGlossaries(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.findGlossaries(userId, searchString, searchStringParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.getGlossariesByName(userId, name, nameParameterName, startFrom, pageSize, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String glossaryEntityParameterName = "glossaryEntity";
        String glossaryGUIDParameterName = "glossaryEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<GlossaryElement> results = new ArrayList<GlossaryElement>();
        List glossaryEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareCapability", "Glossary", startFrom, pageSize, null, false, false, methodName);
        if (glossaryEntities != null) {
            for (EntityDetail glossaryEntity : glossaryEntities) {
                GlossaryElement glossaryElement;
                if (glossaryEntity == null || (glossaryElement = (GlossaryElement)this.glossaryHandler.getBeanFromEntity(userId, glossaryEntity, "glossaryEntity", methodName)) == null) continue;
                glossaryElement.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryEntity.getGUID(), "glossaryEntity.getGUID()", "Glossary", assetManagerGUID, assetManagerName, false, false, null, methodName));
                results.add(glossaryElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public GlossaryElement getGlossaryByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        GlossaryElement glossary = (GlossaryElement)this.glossaryHandler.getGlossaryByGUID(userId, openMetadataGUID, "openMetadataGUID", methodName);
        if (glossary != null) {
            glossary.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "Glossary", assetManagerGUID, assetManagerName, false, false, null, methodName));
        }
        return glossary;
    }

    public String createGlossaryCategory(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryCategoryProperties glossaryCategoryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategory(userId, glossaryGUID, glossaryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), glossaryCategoryProperties.getEffectiveFrom(), glossaryCategoryProperties.getEffectiveTo(), new Date(), methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, false, false, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategoryFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, false, false, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public void updateGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, GlossaryCategoryProperties glossaryCategoryProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryCategoryHandler.updateGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), glossaryCategoryProperties.getEffectiveFrom(), glossaryCategoryProperties.getEffectiveTo(), effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    public void setupCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryParentCategoryGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildCategoryGUIDParameterName = "glossaryChildCategoryGUID";
        this.glossaryCategoryHandler.setupCategoryParent(userId, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", glossaryChildCategoryGUID, "glossaryChildCategoryGUID", effectiveFrom, effectiveTo, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "CategoryHierarchyLink", glossaryParentCategoryGUID, "GlossaryCategory", glossaryChildCategoryGUID, "GlossaryCategory", methodName);
    }

    public void clearCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryParentCategoryGUIDParameterName = "glossaryParentCategoryGUID";
        String glossaryChildCategoryGUIDParameterName = "glossaryChildCategoryGUID";
        this.glossaryCategoryHandler.clearCategoryParent(userId, glossaryParentCategoryGUID, "glossaryParentCategoryGUID", glossaryChildCategoryGUID, "glossaryChildCategoryGUID", effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "CategoryHierarchyLink", glossaryParentCategoryGUID, "GlossaryCategory", glossaryChildCategoryGUID, "GlossaryCategory", methodName);
    }

    public void removeGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryCategoryHandler.removeGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.findGlossaryCategories(userId, searchString, searchStringParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getCategoriesForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossaryCategoriesByName(userId, name, nameParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, "GlossaryCategory", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryCategory;
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossarySubCategories(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryByGUID(userId, openMetadataGUID, "openMetadataGUID", effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "GlossaryCategory", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryCategory;
    }

    public String createGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryTermProperties glossaryTermProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), glossaryTermProperties.getTypeName(), glossaryTermProperties.getExtendedProperties(), InstanceStatus.ACTIVE, glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), new Date(), methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, false, false, new Date(), methodName);
        }
        return glossaryTermGUID;
    }

    private InstanceStatus getInstanceStatus(GlossaryTermStatus status) {
        if (status != null) {
            switch (status) {
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case PREPARED: {
                    return InstanceStatus.PREPARED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case REJECTED: {
                    return InstanceStatus.REJECTED;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
                case DEPRECATED: {
                    return InstanceStatus.DEPRECATED;
                }
                case OTHER: {
                    return InstanceStatus.OTHER;
                }
            }
        }
        return null;
    }

    public String createControlledGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermGUID;
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        String initialStatusParameterName = "initialStatus";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateObject((Object)initialStatus, "initialStatus", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String typeName = "ControlledGlossaryTerm";
        if (glossaryTermProperties.getTypeName() != null) {
            typeName = glossaryTermProperties.getTypeName();
        }
        if ((glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), typeName, glossaryTermProperties.getExtendedProperties(), this.getInstanceStatus(initialStatus), glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), new Date(), methodName)) != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, false, false, new Date(), methodName);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTermFromTemplate(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, false, false, new Date(), methodName);
        }
        return glossaryTermGUID;
    }

    public void updateGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermProperties glossaryTermProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.updateGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getAdditionalProperties(), "GlossaryTerm", glossaryTermProperties.getExtendedProperties(), glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateGlossaryTermStatus(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermStatus glossaryTermStatus, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermStatusParameterName = "glossaryTermStatus";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermStatus, "glossaryTermStatus", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.updateGlossaryTermStatus(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, this.getInstanceStatus(glossaryTermStatus), "glossaryTermStatus", effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    private int getTermRelationshipStatus(GlossaryTermRelationshipStatus status) {
        if (status != null) {
            return status.getOpenTypeOrdinal();
        }
        return GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal();
    }

    public void setupTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUIDParameterName = glossaryCategoryGUIDParameterName;
        String glossaryTermGUIDParameterName = glossaryTermGUIDParameterName;
        if (categorizationProperties != null) {
            this.glossaryTermHandler.setupTermCategory(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, categorizationProperties.getDescription(), this.getTermRelationshipStatus(categorizationProperties.getStatus()), categorizationProperties.getEffectiveFrom(), categorizationProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.setupTermCategory(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "TermCategorization", glossaryCategoryGUID, "GlossaryCategory", glossaryTermGUID, "GlossaryTerm", methodName);
    }

    public void clearTermCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUIDParameterName = glossaryCategoryGUIDParameterName;
        String glossaryTermGUIDParameterName = glossaryTermGUIDParameterName;
        this.glossaryTermHandler.clearTermCategory(userId, assetManagerGUID, assetManagerName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "TermCategorization", glossaryCategoryGUID, "GlossaryCategory", glossaryTermGUID, "GlossaryTerm", methodName);
    }

    public void setupTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        if (relationshipsProperties != null) {
            this.glossaryTermHandler.setupTermRelationship(userId, null, null, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", relationshipsProperties.getExpression(), relationshipsProperties.getDescription(), this.getTermRelationshipStatus(relationshipsProperties.getStatus()), relationshipsProperties.getSteward(), relationshipsProperties.getSource(), relationshipsProperties.getEffectiveFrom(), relationshipsProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.setupTermRelationship(userId, null, null, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", null, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, relationshipTypeName, glossaryTermOneGUID, "GlossaryTerm", glossaryTermTwoGUID, "GlossaryTerm", methodName);
    }

    public void updateTermRelationship(String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        if (relationshipsProperties != null) {
            this.glossaryTermHandler.updateTermRelationship(userId, null, null, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", relationshipsProperties.getExpression(), relationshipsProperties.getDescription(), this.getTermRelationshipStatus(relationshipsProperties.getStatus()), relationshipsProperties.getSteward(), relationshipsProperties.getSource(), relationshipsProperties.getEffectiveFrom(), relationshipsProperties.getEffectiveTo(), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.updateTermRelationship(userId, null, null, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", null, null, GlossaryTermRelationshipStatus.ACTIVE.getOpenTypeOrdinal(), null, null, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearTermRelationship(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermOneGUIDParameterName = "glossaryTermOneGUID";
        String glossaryTermTwoGUIDParameterName = "glossaryTermTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.glossaryTermHandler.clearTermRelationship(userId, assetManagerGUID, assetManagerName, glossaryTermOneGUID, "glossaryTermOneGUID", relationshipTypeName, "relationshipTypeName", glossaryTermTwoGUID, "glossaryTermTwoGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, relationshipTypeName, glossaryTermOneGUID, "GlossaryTerm", glossaryTermTwoGUID, "GlossaryTerm", methodName);
    }

    public void setTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsAbstractConcept(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsAbstractConcept(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsDataValue(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsDataValue(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private int getActivityType(GlossaryTermActivityType activityType) {
        if (activityType != null) {
            return activityType.getOpenTypeOrdinal();
        }
        return GlossaryTermActivityType.ACTION.getOpenTypeOrdinal();
    }

    public void setTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermActivityType activityType, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsActivity(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, this.getActivityType(activityType), null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsActivity(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermContextDefinition contextDefinition, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (contextDefinition != null) {
            this.glossaryTermHandler.setTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, contextDefinition.getDescription(), contextDefinition.getScope(), null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.setTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsSpineObject(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsSpineObject(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsSpineAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsSpineAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsObjectIdentifier(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsObjectIdentifier(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, "GlossaryTerm", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.removeGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.findTerms(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        GlossaryTermElement glossaryTerm = (GlossaryTermElement)this.glossaryTermHandler.getTerm(userId, guid, "guid", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryTerm != null) {
            glossaryTerm.setCorrelationHeaders(this.getCorrelationProperties(userId, guid, "guid", "GlossaryTerm", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryTerm;
    }

    public String createExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, ExternalGlossaryLinkProperties linkProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, ExternalGlossaryLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeExternalGlossaryLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void attachExternalLinkToGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalLinkFromGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String userId, String assetManagerGUID, String assetManagerName, String externalLinkGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void attachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String externalLinkGUID, ExternalGlossaryElementLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalCategoryLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void attachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String externalLinkGUID, ExternalGlossaryElementLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void detachExternalTermLink(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

