/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.CommentConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CommentElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CommentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentExchangeHandler
extends ExchangeHandlerBase {
    private final CommentHandler<CommentElement> commentHandler;
    private static final String commentGUIDParameterName = "commentGUID";

    public CommentExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.commentHandler = new CommentHandler(new CommentConverter(repositoryHelper, serviceName, serverName), CommentElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToComments(String userId, String assetManagerGUID, String assetManagerName, List<CommentElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), commentGUIDParameterName, "Comment", assetManagerGUID, assetManagerName, false, false, null, methodName));
            }
        }
    }

    public String createComment(String userId, String guid, String guidParameterName, MetadataCorrelationProperties correlationProperties, boolean isPublic, CommentProperties commentProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String commentGUID;
        String propertiesParameterName = "commentProperties";
        String commentText = "commentProperties.getText";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)commentProperties, "commentProperties", methodName);
        this.invalidParameterHandler.validateName(commentProperties.getCommentText(), "commentProperties.getText", methodName);
        int commentType = CommentType.STANDARD_COMMENT.getOpenTypeOrdinal();
        if (commentProperties.getCommentType() != null) {
            commentType = commentProperties.getCommentType().getOpenTypeOrdinal();
        }
        if ((commentGUID = this.commentHandler.attachNewComment(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), guid, guid, guidParameterName, commentType, commentProperties.getCommentText(), isPublic, commentProperties.getEffectiveFrom(), commentProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.createExternalIdentifier(userId, commentGUID, commentGUIDParameterName, "Comment", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return commentGUID;
    }

    public void updateComment(String userId, MetadataCorrelationProperties correlationProperties, String commentGUID, CommentProperties commentProperties, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "commentProperties";
        String qualifiedNameParameterName = "commentProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(commentGUID, commentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)commentProperties, "commentProperties", methodName);
        this.invalidParameterHandler.validateName(commentProperties.getQualifiedName(), "commentProperties.qualifiedName", methodName);
        int commentType = CommentType.STANDARD_COMMENT.getOpenTypeOrdinal();
        if (commentProperties.getCommentType() != null) {
            commentType = commentProperties.getCommentType().getOpenTypeOrdinal();
        }
        this.validateExternalIdentifier(userId, commentGUID, commentGUIDParameterName, "Comment", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.commentHandler.updateComment(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), commentGUID, commentGUIDParameterName, commentProperties.getQualifiedName(), commentType, commentProperties.getCommentText(), isPublic, isMergeUpdate, commentProperties.getEffectiveFrom(), commentProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeComment(String userId, MetadataCorrelationProperties correlationProperties, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(commentGUID, commentGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, commentGUID, commentGUIDParameterName, "Comment", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (correlationProperties != null) {
            this.commentHandler.removeCommentFromElement(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), commentGUID, commentGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.commentHandler.removeCommentFromElement(userId, null, null, commentGUID, commentGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void setupAcceptedAnswer(String userId, String assetManagerGUID, String assetManagerName, String questionCommentGUID, String answerCommentGUID, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String questionCommentGUIDParameterName = "questionCommentGUID";
        String answerCommentGUIDParameterName = "answerCommentGUID";
        this.commentHandler.setupAcceptedAnswer(userId, assetManagerGUID, assetManagerName, questionCommentGUID, "questionCommentGUID", answerCommentGUID, "answerCommentGUID", isPublic, effectiveFrom, effectiveTo, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "ecf1a3ca-adc5-4747-82cf-10ec590c5c69", questionCommentGUID, "Comment", answerCommentGUID, "Comment", methodName);
    }

    public void clearAcceptedAnswer(String userId, String assetManagerGUID, String assetManagerName, String questionCommentGUID, String answerCommentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String questionCommentGUIDParameterName = "questionCommentGUID";
        String answerCommentGUIDParameterName = "answerCommentGUID";
        this.commentHandler.clearAcceptedAnswer(userId, assetManagerGUID, assetManagerName, questionCommentGUID, "questionCommentGUID", answerCommentGUID, "answerCommentGUID", effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, "AcceptedAnswer", questionCommentGUID, "Comment", answerCommentGUID, "Comment", methodName);
    }

    public List<CommentElement> findComments(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.commentHandler.findBeans(userId, searchString, searchStringParameterName, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", "qualifiedName", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToComments(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<CommentElement> getAttachedComments(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.commentHandler.getComments(userId, elementGUID, elementGUIDParameterName, "Referenceable", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToComments(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public CommentElement getCommentByGUID(String userId, String assetManagerGUID, String assetManagerName, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = commentGUIDParameterName;
        CommentElement comment = (CommentElement)this.commentHandler.getBeanFromRepository(userId, commentGUID, commentGUIDParameterName, "Comment", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (comment != null) {
            comment.setCorrelationHeaders(this.getCorrelationProperties(userId, commentGUID, commentGUIDParameterName, "Comment", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return comment;
    }
}

