/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ControlFlowConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.DataFlowConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.LineageMappingConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.PortConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ProcessCallConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProcessHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessExchangeHandler
extends ExchangeHandlerBase {
    private final ProcessHandler<ProcessElement, PortElement, DataFlowElement, ControlFlowElement, ProcessCallElement, LineageMappingElement> processHandler;
    private static final String processGUIDParameterName = "processGUID";
    private static final String portGUIDParameterName = "portGUID";

    public ProcessExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.processHandler = new ProcessHandler(new ProcessConverter(repositoryHelper, serviceName, serverName), ProcessElement.class, new PortConverter(repositoryHelper, serviceName, serverName), PortElement.class, new DataFlowConverter(repositoryHelper, serviceName, serverName), DataFlowElement.class, new ControlFlowConverter(repositoryHelper, serviceName, serverName), ControlFlowElement.class, new ProcessCallConverter(repositoryHelper, serviceName, serverName), ProcessCallElement.class, new LineageMappingConverter(repositoryHelper, serviceName, serverName), LineageMappingElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToProcesses(String userId, String assetManagerGUID, String assetManagerName, List<ProcessElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (ProcessElement element : results) {
                if (element == null || element.getElementHeader() == null || element.getElementHeader().getGUID() == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), processGUIDParameterName, "Process", (SupplementaryProperties)element.getProcessProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private void addCorrelationPropertiesToPorts(String userId, String assetManagerGUID, String assetManagerName, List<PortElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private InstanceStatus getInstanceStatus(ProcessStatus status) {
        if (status != null) {
            switch (status) {
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
            }
        }
        return InstanceStatus.UNKNOWN;
    }

    public String createProcess(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, ProcessProperties processProperties, ProcessStatus processStatus, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUID;
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", methodName);
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", methodName);
        String typeName = "DeployedSoftwareComponent";
        if (processProperties.getTypeName() != null) {
            typeName = processProperties.getTypeName();
        }
        if ((processGUID = this.processHandler.createProcess(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getVersionIdentifier(), processProperties.getTechnicalDescription(), processProperties.getFormula(), processProperties.getFormulaType(), processProperties.getImplementationLanguage(), processProperties.getAdditionalProperties(), typeName, processProperties.getExtendedProperties(), this.getInstanceStatus(processStatus), processProperties.getEffectiveFrom(), processProperties.getEffectiveTo(), effectiveTime, methodName)) != null) {
            this.maintainSupplementaryProperties(userId, processGUID, processGUIDParameterName, "Process", processProperties.getQualifiedName(), (SupplementaryProperties)processProperties, true, false, false, effectiveTime, methodName);
            this.createExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, false, false, null, methodName);
        }
        return processGUID;
    }

    public String createProcessFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String processGUID = this.processHandler.createProcessFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, "templateGUID", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getVersionIdentifier(), templateProperties.getDescription(), false, false, effectiveTime, methodName);
        if (processGUID != null) {
            this.createExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, false, false, null, methodName);
        }
        return processGUID;
    }

    public void updateProcess(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, boolean isMergeUpdate, ProcessProperties processProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processGUIDParameterName = processGUIDParameterName;
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String typeName = "DeployedSoftwareComponent";
        if (processProperties.getTypeName() != null) {
            typeName = processProperties.getTypeName();
        }
        this.processHandler.updateProcess(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), processGUID, processGUIDParameterName, isMergeUpdate, processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getVersionIdentifier(), processProperties.getTechnicalDescription(), processProperties.getFormula(), processProperties.getImplementationLanguage(), processProperties.getAdditionalProperties(), typeName, processProperties.getExtendedProperties(), processProperties.getEffectiveFrom(), processProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.maintainSupplementaryProperties(userId, processGUID, processGUIDParameterName, "Process", processProperties.getQualifiedName(), (SupplementaryProperties)processProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateProcessStatus(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, ProcessStatus processStatus, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "processStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)processStatus, "processStatus", methodName);
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Asset", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.processHandler.updateProcessStatus(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), processGUID, processGUIDParameterName, this.getInstanceStatus(processStatus), "processStatus", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupProcessParent(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", methodName);
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", methodName);
        int containmentTypeOrdinal = ProcessContainmentType.USED.getOpenTypeOrdinal();
        if (containmentType != null) {
            containmentTypeOrdinal = containmentType.getOpenTypeOrdinal();
        }
        this.processHandler.setupProcessParent(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), parentProcessGUID, "parentProcessGUID", childProcessGUID, "childProcessGUID", effectiveFrom, effectiveTo, containmentTypeOrdinal, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearProcessParent(String userId, String assetManagerGUID, String assetManagerName, String parentProcessGUID, String childProcessGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentProcessGUIDParameterName = "parentProcessGUID";
        String childProcessGUIDParameterName = "childProcessGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentProcessGUID, "parentProcessGUID", methodName);
        this.invalidParameterHandler.validateGUID(childProcessGUID, "childProcessGUID", methodName);
        this.processHandler.clearProcessParent(userId, assetManagerGUID, assetManagerName, parentProcessGUID, "parentProcessGUID", childProcessGUID, "childProcessGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void publishProcess(String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.processHandler.publishProcess(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawProcess(String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.processHandler.withdrawProcess(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeProcess(String userId, MetadataCorrelationProperties correlationProperties, String processGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, processGUID, processGUIDParameterName, "Process", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.processHandler.removeProcess(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ProcessElement> findProcesses(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.findProcesses(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ProcessElement> getProcessesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String processEntityParameterName = "processEntity";
        String processEntityGUIDParameterName = "processEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ProcessElement> results = new ArrayList<ProcessElement>();
        List processEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareCapability", "Process", startFrom, validatedPageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (processEntities != null) {
            for (EntityDetail processEntity : processEntities) {
                ProcessElement processElement;
                if (processEntity == null || (processElement = (ProcessElement)this.processHandler.getBeanFromEntity(userId, processEntity, "processEntity", methodName)) == null) continue;
                processElement.setCorrelationHeaders(this.getCorrelationProperties(userId, processEntity.getGUID(), "processEntity.getGUID()", "Asset", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(processElement.getElementHeader().getGUID(), processGUIDParameterName, "Process", (SupplementaryProperties)processElement.getProcessProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(processElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<ProcessElement> getProcessesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List results = this.processHandler.getProcessesByName(userId, name, nameParameterName, startFrom, validatedPageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public ProcessElement getProcessByGUID(String userId, String assetManagerGUID, String assetManagerName, String processGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        ProcessElement element = (ProcessElement)this.processHandler.getProcessByGUID(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(element.getElementHeader().getGUID(), processGUIDParameterName, "Process", (SupplementaryProperties)element.getProcessProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return element;
    }

    public ProcessElement getProcessParent(String userId, String assetManagerGUID, String assetManagerName, String processGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        ProcessElement element = (ProcessElement)this.processHandler.getProcessParent(userId, processGUID, processGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), processGUIDParameterName, "Process", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(element.getElementHeader().getGUID(), processGUIDParameterName, "Process", (SupplementaryProperties)element.getProcessProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return element;
    }

    public List<ProcessElement> getSubProcesses(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getSubProcesses(userId, processGUID, processGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToProcesses(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public String createPort(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String processGUID, PortProperties portProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUID;
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", methodName);
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", methodName);
        String typeName = "Port";
        if (portProperties.getTypeName() != null) {
            typeName = portProperties.getTypeName();
        }
        int portType = PortType.OTHER.getOpenTypeOrdinal();
        if (portProperties.getPortType() != null) {
            portType = portProperties.getPortType().getOpenTypeOrdinal();
        }
        if ((portGUID = this.processHandler.createPort(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), processGUID, processGUIDParameterName, portProperties.getQualifiedName(), portProperties.getDisplayName(), portType, portProperties.getAdditionalProperties(), typeName, portProperties.getExtendedProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.createExternalIdentifier(userId, portGUID, portGUIDParameterName, "Port", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return portGUID;
    }

    public void updatePort(String userId, MetadataCorrelationProperties correlationProperties, String portGUID, PortProperties portProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String propertiesParameterName = "portProperties";
        String qualifiedNameParameterName = "portProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)portProperties, "portProperties", methodName);
        this.invalidParameterHandler.validateName(portProperties.getQualifiedName(), "portProperties.qualifiedName", methodName);
        String typeName = "Port";
        if (portProperties.getTypeName() != null) {
            typeName = portProperties.getTypeName();
        }
        this.validateExternalIdentifier(userId, portGUID, portGUIDParameterName, typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        int portType = PortType.OTHER.getOpenTypeOrdinal();
        if (portProperties.getPortType() != null) {
            portType = portProperties.getPortType().getOpenTypeOrdinal();
        }
        this.processHandler.updatePort(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), portGUID, portGUIDParameterName, portProperties.getQualifiedName(), portProperties.getDisplayName(), portType, portProperties.getAdditionalProperties(), typeName, portProperties.getExtendedProperties(), portProperties.getEffectiveFrom(), portProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupProcessPort(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String processGUID, String portGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.processHandler.setupProcessPort(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearProcessPort(String userId, String assetManagerGUID, String assetManagerName, String processGUID, String portGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.processHandler.clearProcessPort(userId, assetManagerGUID, assetManagerName, processGUID, processGUIDParameterName, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupPortDelegation(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", methodName);
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", methodName);
        this.processHandler.setupPortDelegation(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), portOneGUID, "portOneGUID", portTwoGUID, "portTwoGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portOneGUID, String portTwoGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portOneGUIDParameterName = "portOneGUID";
        String portTwoGUIDParameterName = "portTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portOneGUID, "portOneGUID", methodName);
        this.invalidParameterHandler.validateGUID(portTwoGUID, "portTwoGUID", methodName);
        this.processHandler.clearPortDelegation(userId, assetManagerGUID, assetManagerName, portOneGUID, "portOneGUID", portTwoGUID, "portTwoGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        this.processHandler.setupPortSchemaType(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), portGUID, portGUIDParameterName, schemaTypeGUID, "schemaTypeGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearPortSchemaType(String userId, String assetManagerGUID, String assetManagerName, String portGUID, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String portGUIDParameterName = portGUIDParameterName;
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        this.processHandler.clearPortSchemaType(userId, assetManagerGUID, assetManagerName, portGUID, portGUIDParameterName, schemaTypeGUID, "schemaTypeGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removePort(String userId, MetadataCorrelationProperties correlationProperties, String portGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, portGUID, portGUIDParameterName, "Port", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.processHandler.removePort(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<PortElement> findPorts(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.findPorts(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<PortElement> getPortsForProcess(String userId, String assetManagerGUID, String assetManagerName, String processGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortsForProcess(userId, processGUID, processGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<PortElement> getPortUse(String userId, String assetManagerGUID, String assetManagerName, String portGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortUse(userId, portGUID, portGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public PortElement getPortDelegation(String userId, String assetManagerGUID, String assetManagerName, String portGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PortElement element = (PortElement)this.processHandler.getPortDelegation(userId, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null && element.getElementHeader() != null && element.getElementHeader().getGUID() != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return element;
    }

    public List<PortElement> getPortsByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.processHandler.getPortsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToPorts(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public PortElement getPortByGUID(String userId, String assetManagerGUID, String assetManagerName, String portGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PortElement element = (PortElement)this.processHandler.getPortByGUID(userId, portGUID, portGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null && element.getElementHeader() != null && element.getElementHeader().getGUID() != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), portGUIDParameterName, "Port", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return element;
    }

    public void setBusinessSignificant(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.validateExternalIdentifier(userId, elementGUID, "elementGUID", "Referenceable", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.processHandler.setBusinessSignificant(userId, elementGUID, "elementGUID", "Referenceable", null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearBusinessSignificant(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.validateExternalIdentifier(userId, elementGUID, "elementGUID", "Referenceable", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.processHandler.clearBusinessSignificant(userId, elementGUID, "elementGUID", "Referenceable", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupDataFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String description, String formula, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupDataFlow(userId, externalSourceGUID, externalSourceName, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", effectiveFrom, effectiveTo, qualifiedName, description, formula, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DataFlowElement getDataFlow(String userId, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        return (DataFlowElement)this.processHandler.getDataFlow(userId, dataSupplierGUID, "dataSupplierGUID", dataConsumerGUID, "dataConsumerGUID", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, String qualifiedName, String description, String formula, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.processHandler.updateDataFlow(userId, assetManagerGUID, assetManagerName, dataFlowGUID, "dataFlowGUID", effectiveFrom, effectiveTo, qualifiedName, description, formula, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearDataFlow(String userId, String assetManagerGUID, String assetManagerName, String dataFlowGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFlowGUIDParameterName = "dataFlowGUID";
        this.processHandler.clearDataFlow(userId, assetManagerGUID, assetManagerName, dataFlowGUID, "dataFlowGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DataFlowElement> getDataFlowConsumers(String userId, String dataSupplierGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataSupplierGUIDParameterName = "dataSupplierGUID";
        return this.processHandler.getDataFlowConsumers(userId, dataSupplierGUID, "dataSupplierGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String userId, String dataConsumerGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataConsumerGUIDParameterName = "dataConsumerGUID";
        return this.processHandler.getDataFlowSuppliers(userId, dataConsumerGUID, "dataConsumerGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupControlFlow(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, String qualifiedName, String description, String guard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupControlFlow(userId, externalSourceGUID, externalSourceName, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", effectiveFrom, effectiveTo, qualifiedName, description, guard, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public ControlFlowElement getControlFlow(String userId, String currentStepGUID, String nextStepGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        String nextStepGUIDParameterName = "nextStepGUID";
        return (ControlFlowElement)this.processHandler.getControlFlow(userId, currentStepGUID, "currentStepGUID", nextStepGUID, "nextStepGUID", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, String qualifiedName, String description, String guard, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.processHandler.updateControlFlow(userId, assetManagerGUID, assetManagerName, controlFlowGUID, "controlFlowGUID", effectiveFrom, effectiveTo, qualifiedName, description, guard, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearControlFlow(String userId, String assetManagerGUID, String assetManagerName, String controlFlowGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String controlFlowGUIDParameterName = "controlFlowGUID";
        this.processHandler.clearControlFlow(userId, assetManagerGUID, assetManagerName, controlFlowGUID, "controlFlowGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String userId, String currentStepGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        return this.processHandler.getControlFlowNextSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String userId, String currentStepGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String currentStepGUIDParameterName = "currentStepGUID";
        return this.processHandler.getControlFlowPreviousSteps(userId, currentStepGUID, "currentStepGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupProcessCall(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String callerGUID, String calledGUID, String qualifiedName, String description, String formula, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        String externalSourceGUID = null;
        String externalSourceName = null;
        if (assetManagerIsHome && assetManagerGUID != null) {
            externalSourceGUID = assetManagerGUID;
            externalSourceName = assetManagerName;
        }
        return this.processHandler.setupProcessCall(userId, externalSourceGUID, externalSourceName, callerGUID, "callerGUID", calledGUID, "calledGUID", effectiveFrom, effectiveTo, qualifiedName, description, formula, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public ProcessCallElement getProcessCall(String userId, String callerGUID, String calledGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        String calledGUIDParameterName = "calledGUID";
        return (ProcessCallElement)this.processHandler.getProcessCall(userId, callerGUID, "callerGUID", calledGUID, "calledGUID", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, String qualifiedName, String description, String formula, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processCallGUIDParameterName = "processCallGUID";
        this.processHandler.updateProcessCall(userId, assetManagerGUID, assetManagerName, processCallGUID, "processCallGUID", effectiveFrom, effectiveTo, qualifiedName, description, formula, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearProcessCall(String userId, String assetManagerGUID, String assetManagerName, String processCallGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processCallGUIDParameterName = "processCallGUID";
        this.processHandler.clearProcessCall(userId, assetManagerGUID, assetManagerName, processCallGUID, "processCallGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ProcessCallElement> getProcessCalled(String userId, String callerGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String callerGUIDParameterName = "callerGUID";
        return this.processHandler.getProcessCallers(userId, callerGUID, "callerGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ProcessCallElement> getProcessCallers(String userId, String calledGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String calledGUIDParameterName = "calledGUID";
        return this.processHandler.getProcessCallers(userId, calledGUID, "calledGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String sourceElementGUID, String destinationElementGUID, String qualifiedName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        String guid = this.processHandler.setupLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", qualifiedName, description, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, "LineageMapping", sourceElementGUID, "Referenceable", destinationElementGUID, "Referenceable", methodName);
        return guid;
    }

    public LineageMappingElement getLineageMapping(String userId, String sourceElementGUID, String destinationElementGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String destinationElementGUIDParameterName = "destinationElementGUID";
        return (LineageMappingElement)this.processHandler.getLineageMapping(userId, sourceElementGUID, "sourceElementGUID", destinationElementGUID, "destinationElementGUID", qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String lineageMappingGUID, String qualifiedName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String lineageMappingGUIDParameterName = "lineageMappingGUID";
        this.processHandler.updateLineageMapping(userId, lineageMappingGUID, "lineageMappingGUID", qualifiedName, description, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearLineageMapping(String userId, String assetManagerGUID, String assetManagerName, String lineageMappingGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String lineageMappingGUIDParameterName = "lineageMappingGUID";
        this.processHandler.clearLineageMapping(userId, lineageMappingGUID, "lineageMappingGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String userId, String sourceElementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String sourceElementGUIDParameterName = "sourceElementGUID";
        return this.processHandler.getDestinationLineageMappings(userId, sourceElementGUID, "sourceElementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String userId, String destinationElementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String destinationElementGUIDParameterName = "destinationElementGUID";
        return this.processHandler.getSourceLineageMappings(userId, destinationElementGUID, "destinationElementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

