/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.ConnectionExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ConnectionExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ConnectionExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createConnection(String serverName, String userId, boolean assetManagerIsHome, ConnectionRequestBody requestBody) {
        String methodName = "createConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createConnection");
                response.setGUID(handler.createConnection(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createConnection"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectionFromTemplate(String serverName, String userId, String templateGUID, boolean assetManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createConnectionFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectionFromTemplate");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createConnectionFromTemplate");
                response.setGUID(handler.createConnectionFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createConnectionFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnection(String serverName, String userId, String connectionGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ConnectionRequestBody requestBody) {
        String methodName = "updateConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "updateConnection");
                handler.updateConnection(userId, requestBody.getMetadataCorrelationProperties(), connectionGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupConnectorType");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "setupConnectorType");
                handler.setupConnectorType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, connectionGUID, connectorTypeGUID, requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConnectorType");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "clearConnectorType");
                handler.clearConnectorType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), connectionGUID, connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEndpoint");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "setupEndpoint");
                handler.setupEndpoint(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, connectionGUID, endpointGUID, requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEndpoint");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "clearEndpoint");
                handler.clearEndpoint(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), connectionGUID, endpointGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupEmbeddedConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEmbeddedConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "setupEmbeddedConnection");
                if (requestBody.getProperties() instanceof EmbeddedConnectionProperties) {
                    handler.setupEmbeddedConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, connectionGUID, embeddedConnectionGUID, (EmbeddedConnectionProperties)requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupEmbeddedConnection");
                } else {
                    handler.setupEmbeddedConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, connectionGUID, embeddedConnectionGUID, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupEmbeddedConnection");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearEmbeddedConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEmbeddedConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "clearEmbeddedConnection");
                handler.clearEmbeddedConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), connectionGUID, embeddedConnectionGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearEmbeddedConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetConnection(String serverName, String userId, boolean assetManagerIsHome, String assetGUID, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupAssetConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "setupAssetConnection");
                if (requestBody.getProperties() instanceof AssetConnectionProperties) {
                    handler.setupAssetConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, assetGUID, connectionGUID, (AssetConnectionProperties)requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupAssetConnection");
                } else {
                    handler.setupAssetConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetManagerIsHome, assetGUID, connectionGUID, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupAssetConnection");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAssetConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "clearAssetConnection");
                handler.clearAssetConnection(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetGUID, connectionGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearAssetConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnection(String serverName, String userId, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removeConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnection");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "removeConnection");
                handler.removeConnection(userId, requestBody.getMetadataCorrelationProperties(), connectionGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeConnection");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse findConnections(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findConnections";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnections");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "findConnections");
                response.setElementList(handler.findConnections(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findConnections"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnections", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getConnectionsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsByName");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsByName");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectionsByName");
                response.setElementList(handler.getConnectionsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getConnectionsForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsForAssetManager");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsForAssetManager");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectionsForAssetManager");
                response.setElementList(handler.getConnectionsForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectionsForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectionsForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionsForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getConnectionByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectionByGUID");
                response.setElement(handler.getConnectionByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), connectionGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectionByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectionByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpoint(String serverName, String userId, boolean assetManagerIsHome, EndpointRequestBody requestBody) {
        String methodName = "createEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createEndpoint");
                response.setGUID(handler.createEndpoint(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createEndpoint"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String templateGUID, boolean assetManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createEndpointFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createEndpointFromTemplate");
                response.setGUID(handler.createEndpointFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createEndpointFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, EndpointRequestBody requestBody) {
        String methodName = "updateEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "updateEndpoint");
                handler.updateEndpoint(userId, requestBody.getMetadataCorrelationProperties(), endpointGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removeEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "removeEndpoint");
                handler.removeEndpoint(userId, requestBody.getMetadataCorrelationProperties(), endpointGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeEndpoint");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeEndpoint", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findEndpoints";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "findEndpoints");
                response.setElementList(handler.findEndpoints(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findEndpoints"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findEndpoints", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getEndpointsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getEndpointsByName");
                response.setElementList(handler.getEndpointsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getEndpointsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getEndpointsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getEndpointsForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsForAssetManager");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsForAssetManager");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getEndpointsForAssetManager");
                response.setElementList(handler.getEndpointsForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getEndpointsForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getEndpointsForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getEndpointByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getEndpointByGUID");
                response.setElement(handler.getEndpointByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), endpointGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getEndpointByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getEndpointByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorType(String serverName, String userId, boolean assetManagerIsHome, ConnectorTypeRequestBody requestBody) {
        String methodName = "createConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorType");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createConnectorType");
                response.setGUID(handler.createConnectorType(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), "createConnectorType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorTypeFromTemplate(String serverName, String userId, String templateGUID, boolean assetManagerIsHome, TemplateRequestBody requestBody) {
        String methodName = "createConnectorTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorTypeFromTemplate");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "createConnectorTypeFromTemplate");
                response.setGUID(handler.createConnectorTypeFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createConnectorTypeFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createConnectorTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnectorType(String serverName, String userId, String connectorTypeGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ConnectorTypeRequestBody requestBody) {
        String methodName = "updateConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnectorType");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "updateConnectorType");
                handler.updateConnectorType(userId, requestBody.getMetadataCorrelationProperties(), connectorTypeGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnectorType(String serverName, String userId, String connectorTypeGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removeConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnectorType");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "removeConnectorType");
                handler.removeConnectorType(userId, requestBody.getMetadataCorrelationProperties(), connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeConnectorType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeConnectorType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse findConnectorTypes(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findConnectorTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnectorTypes");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnectorTypes");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "findConnectorTypes");
                response.setElementList(handler.findConnectorTypes(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findConnectorTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findConnectorTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnectorTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getConnectorTypesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesByName");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesByName");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectorTypesByName");
                response.setElementList(handler.getConnectorTypesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectorTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectorTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getConnectorTypesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesForAssetManager");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesForAssetManager");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectorTypesForAssetManager");
                response.setElementList(handler.getConnectorTypesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectorTypesForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectorTypesForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorTypeByGUID(String serverName, String userId, String connectorTypeGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getConnectorTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypeByGUID");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypeByGUID");
            if (requestBody != null) {
                ConnectionExchangeHandler handler = instanceHandler.getConnectionExchangeHandler(userId, serverName, "getConnectorTypeByGUID");
                response.setElement(handler.getConnectorTypeByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), connectorTypeGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConnectorTypeByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getConnectorTypeByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

