/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.GlossaryExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ActivityDescriptionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CanonicalVocabularyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EditingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.StagingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TaxonomyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.HistoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GlossaryExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGlossary(String serverName, String userId, boolean assetManagerIsHome, ReferenceableRequestBody requestBody) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossary");
                    response.setGUID(handler.createGlossary(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, glossaryProperties, "createGlossary"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "createGlossary");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryFromTemplate(String serverName, String userId, boolean assetManagerIsHome, String templateGUID, boolean deepCopy, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryFromTemplate");
                response.setGUID(handler.createGlossaryFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), deepCopy, "createGlossaryFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossary(String serverName, String userId, String glossaryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossary");
                    handler.updateGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, glossaryProperties, requestBody.getUpdateDescription(), isMergeUpdate, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateGlossary");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "updateGlossary");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossary");
            if (requestBody != null) {
                handler.removeGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeGlossary");
            } else {
                handler.removeGlossary(userId, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "removeGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsEditingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsEditingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof EditingGlossaryProperties) {
                    EditingGlossaryProperties properties = (EditingGlossaryProperties)classificationProperties;
                    handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsEditingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsEditingGlossary");
                } else if (requestBody.getProperties() == null) {
                    handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsEditingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsEditingGlossary");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(EditingGlossaryProperties.class.getName(), "setGlossaryAsEditingGlossary");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsEditingGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsEditingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsEditingGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsEditingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsEditingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearGlossaryAsEditingGlossary");
            } else {
                handler.clearGlossaryAsEditingGlossary(userId, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "clearGlossaryAsEditingGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsStagingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsEditingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof StagingGlossaryProperties) {
                    StagingGlossaryProperties properties = (StagingGlossaryProperties)classificationProperties;
                    handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsStagingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsEditingGlossary");
                } else if (requestBody.getProperties() == null) {
                    handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsStagingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsEditingGlossary");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(StagingGlossaryProperties.class.getName(), "setGlossaryAsEditingGlossary");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsEditingGlossary", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsStagingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsStagingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsStagingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsStagingGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsStagingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsStagingGlossary(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearGlossaryAsStagingGlossary");
            } else {
                handler.clearGlossaryAsEditingGlossary(userId, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "clearGlossaryAsStagingGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsStagingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsTaxonomy");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof TaxonomyProperties) {
                    TaxonomyProperties properties = (TaxonomyProperties)classificationProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsTaxonomy");
                    handler.setGlossaryAsTaxonomy(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsTaxonomy");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(TaxonomyProperties.class.getName(), "setGlossaryAsTaxonomy");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsTaxonomy", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsTaxonomy");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsTaxonomy");
            if (requestBody != null) {
                handler.clearGlossaryAsTaxonomy(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearGlossaryAsTaxonomy");
            } else {
                handler.clearGlossaryAsTaxonomy(userId, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "clearGlossaryAsTaxonomy");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsCanonical");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof CanonicalVocabularyProperties) {
                    CanonicalVocabularyProperties properties = (CanonicalVocabularyProperties)classificationProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setGlossaryAsCanonical");
                    handler.setGlossaryAsCanonical(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setGlossaryAsCanonical");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CanonicalVocabularyProperties.class.getName(), "setGlossaryAsCanonical");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsCanonical", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsCanonical");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearGlossaryAsCanonical");
            if (requestBody != null) {
                handler.clearGlossaryAsCanonical(userId, requestBody.getMetadataCorrelationProperties(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearGlossaryAsCanonical");
            } else {
                handler.clearGlossaryAsCanonical(userId, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "clearGlossaryAsCanonical");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse findGlossaries(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaries");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaries");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaries");
                response.setElementList(handler.findGlossaries(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findGlossaries"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaries", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getGlossariesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesByName");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesByName");
                response.setElementList(handler.getGlossariesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossariesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossariesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossariesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossariesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesForAssetManager");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesForAssetManager");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesForAssetManager");
            if (requestBody != null) {
                response.setElementList(handler.getGlossariesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossariesForAssetManager"));
            } else {
                response.setElementList(handler.getGlossariesForAssetManager(userId, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getGlossariesForAssetManager"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossariesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryByGUID(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryByGUID");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryByGUID"));
            } else {
                response.setElement(handler.getGlossaryByGUID(userId, null, null, glossaryGUID, forLineage, forDuplicateProcessing, null, "getGlossaryByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategory(String serverName, String userId, String glossaryGUID, boolean assetManagerIsHome, boolean isRootCategory, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategory");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryCategory");
                    response.setGUID(handler.createGlossaryCategory(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, properties, isRootCategory, requestBody.getUpdateDescription(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "createGlossaryCategory"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "createGlossaryCategory");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategoryFromTemplate(String serverName, String userId, String glossaryGUID, String templateGUID, boolean assetManagerIsHome, boolean deepCopy, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryCategoryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategoryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategoryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryCategoryFromTemplate");
                response.setGUID(handler.createGlossaryCategoryFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, glossaryGUID, templateGUID, requestBody.getElementProperties(), deepCopy, "createGlossaryCategoryFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategoryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryCategoryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryCategory");
                    handler.updateGlossaryCategory(userId, requestBody.getMetadataCorrelationProperties(), glossaryCategoryGUID, properties, requestBody.getUpdateDescription(), isMergeUpdate, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateGlossaryCategory");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "updateGlossaryCategory");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupCategoryParent");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupCategoryParent");
                } else {
                    handler.setupCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupCategoryParent");
                }
            } else {
                handler.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, null, forLineage, forDuplicateProcessing, null, "setupCategoryParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearCategoryParent");
            if (requestBody != null) {
                handler.clearCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearCategoryParent");
            } else {
                handler.clearCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, null, "clearCategoryParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossaryCategory");
            if (requestBody != null) {
                handler.removeGlossaryCategory(userId, requestBody.getMetadataCorrelationProperties(), glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeGlossaryCategory");
            } else {
                handler.removeGlossaryCategory(userId, null, glossaryCategoryGUID, forLineage, forDuplicateProcessing, null, "removeGlossaryCategory");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse findGlossaryCategories(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryCategories");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaryCategories");
                response.setElementList(handler.findGlossaryCategories(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getGlossaryGUID(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing, "findGlossaryCategories"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaryCategories", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoriesForGlossary");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getCategoriesForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getCategoriesForGlossary"));
            } else {
                response.setElementList(handler.getCategoriesForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getCategoriesForGlossary"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCategoriesForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryCategoriesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoriesByName");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoriesByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoriesByName");
                response.setElementList(handler.getGlossaryCategoriesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getGlossaryGUID(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryCategoriesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossaryCategoriesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryByGUID");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryCategoryByGUID"));
            } else {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, null, null, glossaryCategoryGUID, forLineage, forDuplicateProcessing, null, "getGlossaryCategoryByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryParent(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryParent");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryParent");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryCategoryParent");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryCategoryParent"));
            } else {
                response.setElement(handler.getGlossaryCategoryParent(userId, null, null, glossaryCategoryGUID, forLineage, forDuplicateProcessing, null, "getGlossaryCategoryParent"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossarySubCategories(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossarySubCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossarySubCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossarySubCategories");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossarySubCategories");
            if (requestBody != null) {
                response.setElementList(handler.getGlossarySubCategories(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossarySubCategories"));
            } else {
                response.setElementList(handler.getGlossarySubCategories(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getGlossarySubCategories"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossarySubCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTerm(String serverName, String userId, String glossaryGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTerm");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryTermProperties) {
                    GlossaryTermProperties properties = (GlossaryTermProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryTerm");
                    response.setGUID(handler.createGlossaryTerm(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, properties, requestBody.getUpdateDescription(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing, "createGlossaryTerm"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermProperties.class.getName(), "createGlossaryTerm");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createControlledGlossaryTerm(String serverName, String userId, String glossaryGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, ControlledGlossaryTermRequestBody requestBody) {
        String methodName = "createControlledGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createControlledGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createControlledGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createControlledGlossaryTerm");
                response.setGUID(handler.createControlledGlossaryTerm(userId, glossaryGUID, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), requestBody.getInitialStatus(), requestBody.getUpdateDescription(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing, "createControlledGlossaryTerm"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createControlledGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createControlledGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTermFromTemplate(String serverName, String userId, String glossaryGUID, String templateGUID, boolean assetManagerIsHome, boolean deepCopy, boolean templateSubstitute, GlossaryTemplateRequestBody requestBody) {
        String methodName = "createGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryTermFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createGlossaryTermFromTemplate");
                response.setGUID(handler.createGlossaryTermFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, glossaryGUID, templateGUID, requestBody.getElementProperties(), requestBody.getGlossaryTermStatus(), deepCopy, templateSubstitute, "createGlossaryTermFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTerm");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryTermProperties) {
                    GlossaryTermProperties properties = (GlossaryTermProperties)referenceableProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryTerm");
                    handler.updateGlossaryTerm(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, properties, requestBody.getUpdateDescription(), isMergeUpdate, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateGlossaryTerm");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermProperties.class.getName(), "updateGlossaryTerm");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermStatus(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermStatusRequestBody requestBody) {
        String methodName = "updateGlossaryTermStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTermStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermStatus");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryTermStatus");
                handler.updateGlossaryTermStatus(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getGlossaryTermStatus(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateGlossaryTermStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTermStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermFromTemplate(String serverName, String userId, String glossaryTermGUID, boolean isMergeClassifications, boolean isMergeProperties, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTermFromTemplate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateGlossaryTermFromTemplate");
                handler.updateGlossaryTermFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getParentGUID(), isMergeClassifications, isMergeProperties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateGlossaryTermFromTemplate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "moveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "moveGlossaryTerm");
                handler.moveGlossaryTerm(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getParentGUID(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "moveGlossaryTerm");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "moveGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "moveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermCategory");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermCategorization) {
                    GlossaryTermCategorization properties = (GlossaryTermCategorization)relationshipProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupTermCategory");
                    handler.setupTermCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, glossaryTermGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupTermCategory");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermCategorization.class.getName(), "setupTermCategory");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupTermCategory", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermCategory");
            if (requestBody != null) {
                handler.clearTermCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermCategory");
            } else {
                handler.clearTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, null, "clearTermCategory");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTermRelationshipTypeNames(String serverName, String userId) {
        String methodName = "getTermRelationshipTypeNames";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermRelationshipTypeNames");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermRelationshipTypeNames");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getTermRelationshipTypeNames");
            response.setNames(handler.getTermRelationshipTypeNames());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermRelationshipTypeNames", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setupTermRelationship");
                    handler.setupTermRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupTermRelationship");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "setupTermRelationship");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateTermRelationship");
                    handler.updateTermRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateTermRelationship");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "updateTermRelationship");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermRelationship");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermRelationship");
            if (requestBody != null) {
                handler.clearTermRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermRelationship");
            } else {
                handler.clearTermRelationship(userId, null, null, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, null, "clearTermRelationship");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsAbstractConcept");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsAbstractConcept");
            if (requestBody != null) {
                handler.setTermAsAbstractConcept(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsAbstractConcept");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsAbstractConcept", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsAbstractConcept");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsAbstractConcept");
            handler.clearTermAsAbstractConcept(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsAbstractConcept");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataField(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataField");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsDataField");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof DataFieldValuesProperties) {
                    DataFieldValuesProperties properties = (DataFieldValuesProperties)classificationProperties;
                    handler.setTermAsDataField(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsDataField");
                } else if (requestBody.getProperties() == null) {
                    handler.setTermAsDataField(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsDataField");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(DataFieldValuesProperties.class.getName(), "setTermAsDataField");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsDataField", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataField(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataField");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsDataField");
            if (requestBody != null) {
                handler.clearTermAsDataField(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsDataField");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsDataField", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataValue(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataValue");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsDataValue");
            if (requestBody != null) {
                handler.setTermAsDataValue(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsDataValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsDataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataValue(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataValue");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsDataValue");
            if (requestBody != null) {
                handler.clearTermAsDataValue(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsDataValue");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsDataValue", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsActivity(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsActivity");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof ActivityDescriptionProperties) {
                    ActivityDescriptionProperties properties = (ActivityDescriptionProperties)classificationProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsActivity");
                    handler.setTermAsActivity(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, properties.getActivityType(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsActivity");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ActivityDescriptionProperties.class.getName(), "setTermAsActivity");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsActivity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsActivity(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsActivity");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsActivity");
            if (requestBody != null) {
                handler.clearTermAsActivity(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsActivity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsActivity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsContext(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsContext");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GlossaryTermContextDefinition) {
                    GlossaryTermContextDefinition properties = (GlossaryTermContextDefinition)classificationProperties;
                    GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsContext");
                    handler.setTermAsContext(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, properties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsContext");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermContextDefinition.class.getName(), "setTermAsContext");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsContext", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsContext(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsContext");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsContext");
            if (requestBody != null) {
                handler.clearTermAsContext(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsContext");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsContext", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineObject");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsSpineObject");
            if (requestBody != null) {
                handler.setTermAsSpineObject(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsSpineObject");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsSpineObject", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineObject");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsSpineObject");
            if (requestBody != null) {
                handler.clearTermAsSpineObject(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsSpineObject");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsSpineObject", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineAttribute");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsSpineAttribute");
            if (requestBody != null) {
                handler.setTermAsSpineAttribute(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsSpineAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsSpineAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineAttribute");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsSpineAttribute");
            if (requestBody != null) {
                handler.clearTermAsSpineAttribute(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsSpineAttribute");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsSpineAttribute", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsObjectIdentifier");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "setTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.setTermAsObjectIdentifier(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setTermAsObjectIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setTermAsObjectIdentifier", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsObjectIdentifier");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "clearTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.clearTermAsObjectIdentifier(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearTermAsObjectIdentifier");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearTermAsObjectIdentifier", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse undoGlossaryTermUpdate(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "undoGlossaryTermUpdate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "undoGlossaryTermUpdate");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "undoGlossaryTermUpdate");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "undoGlossaryTermUpdate");
            if (requestBody != null) {
                response.setElement(handler.undoGlossaryTermUpdate(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "undoGlossaryTermUpdate"));
            } else {
                response.setElement(handler.undoGlossaryTermUpdate(userId, null, glossaryTermGUID, forLineage, forDuplicateProcessing, null, "undoGlossaryTermUpdate"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "undoGlossaryTermUpdate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forDuplicateProcessing, ArchiveRequestBody requestBody) {
        String methodName = "archiveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "archiveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveGlossaryTerm");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "archiveGlossaryTerm");
            if (requestBody != null) {
                handler.archiveGlossaryTerm(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, requestBody.getElementProperties(), forDuplicateProcessing, requestBody.getEffectiveTime(), "archiveGlossaryTerm");
            } else {
                handler.archiveGlossaryTerm(userId, null, glossaryTermGUID, null, forDuplicateProcessing, null, "archiveGlossaryTerm");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "archiveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryTerm");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeGlossaryTerm");
            if (requestBody != null) {
                handler.removeGlossaryTerm(userId, requestBody.getMetadataCorrelationProperties(), glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeGlossaryTerm");
            } else {
                handler.removeGlossaryTerm(userId, null, glossaryTermGUID, forLineage, forDuplicateProcessing, null, "removeGlossaryTerm");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse findGlossaryTerms(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryTerms");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "findGlossaryTerms");
                response.setElementList(handler.findGlossaryTerms(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getGlossaryGUID(), requestBody.getSearchString(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findGlossaryTerms"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGlossaryTerms", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getTermsForGlossary"));
            } else {
                response.setElementList(handler.getTermsForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getTermsForGlossary"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossaryCategory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossaryCategory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getTermsForGlossaryCategory");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getTermsForGlossaryCategory"));
            } else {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getTermsForGlossaryCategory"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getRelatedTerms(String serverName, String userId, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getRelatedTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedTerms");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getRelatedTerms");
            if (requestBody != null) {
                response.setElementList(handler.getRelatedTerms(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getRelatedTerms"));
            } else {
                response.setElementList(handler.getRelatedTerms(userId, null, null, glossaryTermGUID, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getRelatedTerms"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryTermsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermsByName");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermsByName");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryTermsByName");
                response.setElementList(handler.getGlossaryTermsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getGlossaryGUID(), requestBody.getName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryTermsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse getGlossaryTermByGUID(String serverName, String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryTermByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermByGUID");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermByGUID");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryTermByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryTermByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), guid, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryTermByGUID"));
            } else {
                response.setElement(handler.getGlossaryTermByGUID(userId, null, null, guid, forLineage, forDuplicateProcessing, null, "getGlossaryTermByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermHistory(String serverName, String userId, String guid, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, HistoryRequestBody requestBody) {
        String methodName = "getGlossaryTermHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermHistory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermHistory");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossaryTermHistory");
            if (requestBody != null) {
                response.setElementList(handler.getGlossaryTermHistory(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), guid, requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossaryTermHistory"));
            } else {
                response.setElementList(handler.getGlossaryTermHistory(userId, null, null, guid, null, null, startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, null, "getGlossaryTermHistory"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createExternalGlossaryLink(String serverName, String userId, ExternalGlossaryLinkRequestBody requestBody) {
        String methodName = "createExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalGlossaryLink");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalGlossaryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "createExternalGlossaryLink");
                response.setGUID(handler.createExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getElementProperties(), "createExternalGlossaryLink"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalGlossaryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateExternalGlossaryLink(String serverName, String userId, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, ExternalGlossaryLinkRequestBody requestBody) {
        String methodName = "updateExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateExternalGlossaryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateExternalGlossaryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "updateExternalGlossaryLink");
                handler.updateExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateExternalGlossaryLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateExternalGlossaryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeExternalGlossaryLink(String serverName, String userId, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeExternalGlossaryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeExternalGlossaryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeExternalGlossaryLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "removeExternalGlossaryLink");
            if (requestBody != null) {
                handler.removeExternalGlossaryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeExternalGlossaryLink");
            } else {
                handler.removeExternalGlossaryLink(userId, null, null, externalLinkGUID, forLineage, forDuplicateProcessing, null, "removeExternalGlossaryLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeExternalGlossaryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalLinkToGlossary(String serverName, String userId, String glossaryGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "attachExternalLinkToGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalLinkToGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalLinkToGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalLinkToGlossary");
            if (requestBody != null) {
                handler.attachExternalLinkToGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "attachExternalLinkToGlossary");
            } else {
                handler.attachExternalLinkToGlossary(userId, null, null, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, null, "attachExternalLinkToGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachExternalLinkToGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalLinkFromGlossary(String serverName, String userId, String externalLinkGUID, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "detachExternalLinkFromGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalLinkFromGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalLinkFromGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalLinkFromGlossary");
            if (requestBody != null) {
                handler.detachExternalLinkFromGlossary(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "detachExternalLinkFromGlossary");
            } else {
                handler.detachExternalLinkFromGlossary(userId, null, null, glossaryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, null, "detachExternalLinkFromGlossary");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachExternalLinkFromGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalGlossaryLinkElementsResponse getExternalLinksForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getExternalLinksForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalLinksForGlossary");
        ExternalGlossaryLinkElementsResponse response = new ExternalGlossaryLinkElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalLinksForGlossary");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getExternalLinksForGlossary");
            response.setElementList(handler.getExternalLinksForGlossary(userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getExternalLinksForGlossary"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalLinksForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesForExternalLink(String serverName, String userId, String externalLinkGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossariesForExternalLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesForExternalLink");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesForExternalLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getGlossariesForExternalLink");
            if (requestBody != null) {
                response.setElementList(handler.getGlossariesForExternalLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), externalLinkGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGlossariesForExternalLink"));
            } else {
                response.setElementList(handler.getGlossariesForExternalLink(userId, null, null, externalLinkGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getGlossariesForExternalLink"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossariesForExternalLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalCategoryLink(String serverName, String userId, String glossaryCategoryGUID, String externalLinkGUID, boolean forLineage, boolean forDuplicateProcessing, ExternalGlossaryElementLinkRequestBody requestBody) {
        String methodName = "attachExternalCategoryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalCategoryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalCategoryLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalCategoryLink");
                handler.attachExternalCategoryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, externalLinkGUID, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, null, "attachExternalCategoryLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "attachExternalCategoryLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachExternalCategoryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalCategoryLink(String serverName, String userId, String externalLinkGUID, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "detachExternalCategoryLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalCategoryLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalCategoryLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalCategoryLink");
            if (requestBody != null) {
                handler.detachExternalCategoryLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "detachExternalCategoryLink");
            } else {
                handler.detachExternalCategoryLink(userId, null, null, glossaryCategoryGUID, externalLinkGUID, forLineage, forDuplicateProcessing, null, "detachExternalCategoryLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachExternalCategoryLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachExternalTermLink(String serverName, String userId, String externalLinkGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ExternalGlossaryElementLinkRequestBody requestBody) {
        String methodName = "attachExternalTermLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachExternalTermLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachExternalTermLink");
            if (requestBody != null) {
                GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "attachExternalTermLink");
                handler.attachExternalTermLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermGUID, externalLinkGUID, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, null, "attachExternalTermLink");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "attachExternalTermLink", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "attachExternalTermLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachExternalTermLink(String serverName, String userId, String externalLinkGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "detachExternalTermLink";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachExternalTermLink");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachExternalTermLink");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "detachExternalTermLink");
            if (requestBody != null) {
                handler.detachExternalTermLink(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "detachExternalTermLink");
            } else {
                handler.detachExternalTermLink(userId, null, null, glossaryTermGUID, externalLinkGUID, forLineage, forDuplicateProcessing, null, "detachExternalTermLink");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "detachExternalTermLink", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

