/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataItemSortOrder;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceActionStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class AssetManagerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public AssetManagerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entity != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entity, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }

    DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "sortOrder", instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOpenTypeOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return DataItemSortOrder.UNKNOWN;
    }

    KeyPattern removeKeyPattern(InstanceProperties instanceProperties) {
        String methodName = "removeKeyPattern";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "keyPattern", instanceProperties, "removeKeyPattern");
            for (KeyPattern keyPattern : KeyPattern.values()) {
                if (keyPattern.getOpenTypeOrdinal() != ordinal) continue;
                return keyPattern;
            }
        }
        return KeyPattern.LOCAL_KEY;
    }

    SynchronizationDirection removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "permittedSynchronization", instanceProperties, "removePermittedSynchronization");
            for (SynchronizationDirection synchronizationDirection : SynchronizationDirection.values()) {
                if (synchronizationDirection.getOpenTypeOrdinal() != ordinal) continue;
                return synchronizationDirection;
            }
        }
        return SynchronizationDirection.BOTH_DIRECTIONS;
    }

    PortType removePortType(InstanceProperties instanceProperties) {
        String methodName = "removePortType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "portType", instanceProperties, "removePortType");
            for (PortType portType : PortType.values()) {
                if (portType.getOpenTypeOrdinal() != ordinal) continue;
                return portType;
            }
        }
        return PortType.OTHER;
    }

    ProcessContainmentType removeProcessContainmentType(InstanceProperties instanceProperties) {
        String methodName = "removeProcessContainmentType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "containmentType", instanceProperties, "removeProcessContainmentType");
            for (ProcessContainmentType containmentType : ProcessContainmentType.values()) {
                if (containmentType.getOpenTypeOrdinal() != ordinal) continue;
                return containmentType;
            }
        }
        return ProcessContainmentType.OTHER;
    }

    GovernanceActionStatus removeActionStatus(String propertyName, InstanceProperties properties) {
        GovernanceActionStatus ownerCategory = this.getActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerCategory;
    }

    private GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                    break;
                }
                case 99: {
                    governanceActionStatus = GovernanceActionStatus.OTHER;
                }
            }
        }
        return governanceActionStatus;
    }
}

