/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelationshipElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataContentForDataSetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataAssetExchangeHandler
extends ExchangeHandlerBase {
    private final AssetHandler<DataAssetElement> assetHandler;
    private static final String assetGUIDParameterName = "assetGUID";

    public DataAssetExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.assetHandler = new AssetHandler(new AssetConverter(repositoryHelper, serviceName, serverName), DataAssetElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToDataAssets(String userId, String assetManagerGUID, String assetManagerName, List<DataAssetElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (DataAssetElement element : results) {
                if (element == null || element.getElementHeader() == null || element.getElementHeader().getGUID() == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), assetGUIDParameterName, "Asset", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), assetGUIDParameterName, "Asset", (SupplementaryProperties)element.getDataAssetProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public String createDataAsset(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, DataAssetProperties assetProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUID;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        String typeName = "Asset";
        if (assetProperties.getTypeName() != null) {
            typeName = assetProperties.getTypeName();
        }
        if ((assetGUID = this.assetHandler.createAssetInRepository(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getVersionIdentifier(), assetProperties.getTechnicalDescription(), assetProperties.getAdditionalProperties(), typeName, assetProperties.getExtendedProperties(), InstanceStatus.ACTIVE, assetProperties.getEffectiveFrom(), assetProperties.getEffectiveTo(), effectiveTime, methodName)) != null) {
            this.maintainSupplementaryProperties(userId, assetGUID, assetGUIDParameterName, "Asset", assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return assetGUID;
    }

    public String createDataAssetFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String assetGUID = this.assetHandler.addAssetFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, "templateGUID", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getVersionIdentifier(), templateProperties.getDescription(), templateProperties.getPathName(), templateProperties.getNetworkAddress(), false, false, new Date(), methodName);
        if (assetGUID != null) {
            this.createExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, false, false, null, methodName);
        }
        return assetGUID;
    }

    public void updateDataAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, boolean isMergeUpdate, DataAssetProperties assetProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)assetProperties, "assetProperties", methodName);
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", methodName);
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.assetHandler.updateAsset(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), assetGUID, assetGUIDParameterName, assetProperties.getQualifiedName(), assetProperties.getTechnicalName(), assetProperties.getVersionIdentifier(), assetProperties.getTechnicalDescription(), assetProperties.getAdditionalProperties(), "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", this.supportedZones, assetProperties.getExtendedProperties(), assetProperties.getEffectiveFrom(), assetProperties.getEffectiveTo(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.maintainSupplementaryProperties(userId, assetGUID, assetGUIDParameterName, "Asset", assetProperties.getQualifiedName(), (SupplementaryProperties)assetProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, String organizationGUID, String organizationGUIDParameterName, String businessCapabilityGUID, String businessCapabilityGUIDParameterName, Map<String, String> otherOriginValues, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetHandler.addAssetOrigin(userId, assetGUID, assetGUIDParameterName, organizationGUID, organizationGUIDParameterName, businessCapabilityGUID, businessCapabilityGUIDParameterName, otherOriginValues, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetHandler.removeAssetOrigin(userId, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void publishDataAsset(String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.assetHandler.publishAsset(userId, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawDataAsset(String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.withdrawAsset(userId, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDataAsset(String userId, MetadataCorrelationProperties correlationProperties, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, assetGUID, assetGUIDParameterName, "Asset", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.assetHandler.deleteBeanInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), assetGUID, assetGUIDParameterName, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setDataAssetAsReferenceData(String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearDataAssetAsReferenceData(String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = assetGUIDParameterName;
        this.assetHandler.classifyAssetAsReferenceData(userId, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String setupRelatedDataAsset(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", methodName);
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        InstanceProperties instanceProperties = null;
        if (relationshipProperties != null && relationshipProperties instanceof DataContentForDataSetProperties) {
            DataContentForDataSetProperties dataContentForDataSetProperties = (DataContentForDataSetProperties)relationshipProperties;
            instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "queryId", dataContentForDataSetProperties.getQueryId(), methodName);
            instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "query", dataContentForDataSetProperties.getQuery(), methodName);
        }
        if (assetManagerIsHome) {
            return this.assetHandler.linkElementToElement(userId, assetManagerGUID, assetManagerName, fromAssetGUID, "fromAssetGUID", "Asset", toAssetGUID, "toAssetGUID", "Asset", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, instanceProperties, null, null, effectiveTime, methodName);
        }
        return this.assetHandler.linkElementToElement(userId, null, null, fromAssetGUID, "fromAssetGUID", "Asset", toAssetGUID, "toAssetGUID", "Asset", forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, instanceProperties, null, null, effectiveTime, methodName);
    }

    public RelationshipElement getAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", methodName);
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        Relationship relationship = this.assetHandler.getUniqueAttachmentLink(userId, fromAssetGUID, "fromAssetGUID", "Asset", relationshipTypeGUID, relationshipTypeName, toAssetGUID, "Asset", 2, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getRelationshipElement(relationship, methodName);
    }

    private RelationshipElement getRelationshipElement(Relationship relationship, String methodName) throws PropertyServerException {
        RelationshipElement relationshipElement = null;
        if (relationship != null) {
            ElementHeaderConverter<ElementHeader> elementHeaderConverter = new ElementHeaderConverter<ElementHeader>(this.repositoryHelper, this.serviceName, this.serverName);
            relationshipElement = new RelationshipElement();
            relationshipElement.setRelationshipHeader(elementHeaderConverter.getNewBean(ElementHeader.class, relationship, methodName));
            relationshipElement.setEnd1GUID(elementHeaderConverter.getNewBean(ElementHeader.class, relationship.getEntityOneProxy(), methodName));
            relationshipElement.setEnd2GUID(elementHeaderConverter.getNewBean(ElementHeader.class, relationship.getEntityTwoProxy(), methodName));
            if (relationship.getProperties() != null) {
                if ("DataContentForDataSet".equals(relationship.getType().getTypeDefName())) {
                    DataContentForDataSetProperties properties = new DataContentForDataSetProperties();
                    properties.setQueryId(this.repositoryHelper.getStringProperty(this.serviceName, "queryId", relationship.getProperties(), methodName));
                    properties.setQuery(this.repositoryHelper.getStringProperty(this.serviceName, "query", relationship.getProperties(), methodName));
                    properties.setEffectiveFrom(relationship.getProperties().getEffectiveFromTime());
                    properties.setEffectiveTo(relationship.getProperties().getEffectiveFromTime());
                    relationshipElement.setRelationshipProperties((RelationshipProperties)properties);
                } else {
                    RelationshipProperties properties = new RelationshipProperties();
                    properties.setEffectiveFrom(relationship.getProperties().getEffectiveFromTime());
                    properties.setEffectiveTo(relationship.getProperties().getEffectiveFromTime());
                    relationshipElement.setRelationshipProperties(properties);
                }
            }
        }
        return relationshipElement;
    }

    public void updateAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        InstanceProperties instanceProperties = null;
        if (relationshipProperties != null && relationshipProperties instanceof DataContentForDataSetProperties) {
            DataContentForDataSetProperties dataContentForDataSetProperties = (DataContentForDataSetProperties)relationshipProperties;
            instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "queryId", dataContentForDataSetProperties.getQueryId(), methodName);
            instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "query", dataContentForDataSetProperties.getQuery(), methodName);
        }
        this.assetHandler.updateElementToElementLink(userId, assetManagerGUID, assetManagerName, relationshipGUID, "relationshipGUID", relationshipTypeName, forLineage, forDuplicateProcessing, this.supportedZones, isMergeUpdate, instanceProperties, effectiveTime, methodName);
    }

    public void clearAssetRelationship(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        this.assetHandler.deleteRelationship(userId, assetManagerGUID, assetManagerName, relationshipGUID, "relationshipGUID", relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd2(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String fromAssetGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        List relationships = this.assetHandler.getAttachmentLinks(userId, fromAssetGUID, "fromAssetGUID", "Asset", relationshipTypeGUID, relationshipTypeName, null, "Asset", 2, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<RelationshipElement> relationshipElements = new ArrayList<RelationshipElement>();
            for (Relationship relationship : relationships) {
                relationshipElements.add(this.getRelationshipElement(relationship, methodName));
            }
            return relationshipElements;
        }
        return null;
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd1(String userId, String assetManagerGUID, String assetManagerName, String relationshipTypeName, String toAssetGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        List relationships = this.assetHandler.getAttachmentLinks(userId, toAssetGUID, "toAssetGUID", "Asset", relationshipTypeGUID, relationshipTypeName, null, "Asset", 1, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList<RelationshipElement> relationshipElements = new ArrayList<RelationshipElement>();
            for (Relationship relationship : relationships) {
                relationshipElements.add(this.getRelationshipElement(relationship, methodName));
            }
            return relationshipElements;
        }
        return null;
    }

    public List<DataAssetElement> findDataAssets(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        List results = this.assetHandler.findAssets(userId, searchString, "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<DataAssetElement> scanDataAssets(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.assetHandler.assetScan(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<DataAssetElement> getDataAssetsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        List results = this.assetHandler.findAssetsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToDataAssets(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String assetEntityParameterName = "assetEntity";
        String assetGUIDParameterName = "assetEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<DataAssetElement> results = new ArrayList<DataAssetElement>();
        List assetEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", "SoftwareCapability", "Asset", startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (assetEntities != null) {
            for (EntityDetail assetEntity : assetEntities) {
                DataAssetElement dataAssetElement;
                if (assetEntity == null || (dataAssetElement = (DataAssetElement)this.assetHandler.getBeanFromEntity(userId, assetEntity, "assetEntity", methodName)) == null) continue;
                dataAssetElement.setCorrelationHeaders(this.getCorrelationProperties(userId, assetEntity.getGUID(), "assetEntity.getGUID()", "Asset", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(dataAssetElement.getElementHeader().getGUID(), "assetEntity.getGUID()", "Asset", (SupplementaryProperties)dataAssetElement.getDataAssetProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(dataAssetElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        DataAssetElement asset = (DataAssetElement)this.assetHandler.getBeanFromRepository(userId, openMetadataGUID, "openMetadataGUID", "Asset", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (asset != null) {
            asset.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "Asset", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(asset.getElementHeader().getGUID(), assetGUIDParameterName, "Asset", (SupplementaryProperties)asset.getDataAssetProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return asset;
    }
}

