/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ExternalIdentifierConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.NoteConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.NoteLogConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataCorrelationHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteLogElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteLogHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class ExchangeHandlerBase {
    protected static final String elementGUIDParameterName = "elementGUID";
    final InvalidParameterHandler invalidParameterHandler;
    final ExternalIdentifierHandler<MetadataCorrelationHeader, ElementHeader> externalIdentifierHandler;
    private final NoteLogHandler<NoteLogElement> noteLogHandler;
    private final NoteHandler<NoteElement> noteHandler;
    String serviceName;
    String serverName;
    OMRSRepositoryHelper repositoryHelper;
    RepositoryHandler repositoryHandler;
    List<String> supportedZones;

    ExchangeHandlerBase(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.externalIdentifierHandler = new ExternalIdentifierHandler(new ExternalIdentifierConverter(repositoryHelper, serviceName, serverName), MetadataCorrelationHeader.class, new ElementHeaderConverter(repositoryHelper, serviceName, serverName), ElementHeader.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.noteLogHandler = new NoteLogHandler(new NoteLogConverter(repositoryHelper, serviceName, serverName), NoteLogElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.noteHandler = new NoteHandler(new NoteConverter(repositoryHelper, serviceName, serverName), NoteElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.invalidParameterHandler = invalidParameterHandler;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    String getExternalSourceGUID(MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome) {
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerGUID();
        }
        return null;
    }

    String getExternalSourceGUID(String assetManagerGUID, boolean assetManagerIsHome) {
        if (assetManagerIsHome) {
            return assetManagerGUID;
        }
        return null;
    }

    String getExternalSourceGUID(MetadataCorrelationProperties correlationProperties) {
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerGUID();
        }
        return null;
    }

    String getExternalSourceName(MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome) {
        if (assetManagerIsHome && correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerName();
        }
        return null;
    }

    String getExternalSourceName(String assetManagerName, boolean assetManagerIsHome) {
        if (assetManagerIsHome) {
            return assetManagerName;
        }
        return null;
    }

    String getExternalSourceName(MetadataCorrelationProperties correlationProperties) {
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null) {
            return correlationProperties.getAssetManagerName();
        }
        return null;
    }

    void createExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, MetadataCorrelationProperties correlationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = elementGUIDParameterName;
        String typeNameParameterName = "elementTypeName";
        String assetManagerGUIDParameterName = "correlationProperties.assetManagerGUID";
        String assetManagerNameParameterName = "correlationProperties.assetManagerName";
        String identifierParameterName = "correlationProperties.externalIdentifier";
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(elementTypeName, "elementTypeName", methodName);
        if (correlationProperties != null && correlationProperties.getAssetManagerGUID() != null && correlationProperties.getExternalIdentifier() != null) {
            this.invalidParameterHandler.validateName(correlationProperties.getAssetManagerName(), "correlationProperties.assetManagerName", methodName);
            this.externalIdentifierHandler.setUpExternalIdentifier(userId, elementGUID, elementGUIDParameterName, elementTypeName, correlationProperties.getExternalIdentifier(), "correlationProperties.externalIdentifier", this.getKeyPattern(correlationProperties.getKeyPattern()), correlationProperties.getExternalIdentifierName(), correlationProperties.getExternalIdentifierUsage(), correlationProperties.getExternalIdentifierSource(), correlationProperties.getMappingProperties(), correlationProperties.getAssetManagerGUID(), "correlationProperties.assetManagerGUID", correlationProperties.getAssetManagerName(), "SoftwareCapability", this.getPermittedSynchronization(correlationProperties.getSynchronizationDirection()), correlationProperties.getSynchronizationDescription(), null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    private int getPermittedSynchronization(SynchronizationDirection synchronizationDirection) {
        int permittedSynchronization = SynchronizationDirection.BOTH_DIRECTIONS.getOpenTypeOrdinal();
        if (synchronizationDirection != null) {
            permittedSynchronization = synchronizationDirection.getOpenTypeOrdinal();
        }
        return permittedSynchronization;
    }

    private int getKeyPattern(KeyPattern keyPattern) {
        int keyPatternOrdinal = KeyPattern.LOCAL_KEY.getOpenTypeOrdinal();
        if (keyPattern != null) {
            keyPatternOrdinal = keyPattern.getOpenTypeOrdinal();
        }
        return keyPatternOrdinal;
    }

    EntityDetail validateExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, MetadataCorrelationProperties correlationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdentifierParameterName = "correlationProperties.getExternalIdentifier()";
        String scopeGUIDParameterName = "correlationProperties.getAssetManagerGUID()";
        if (correlationProperties != null && correlationProperties.getExternalIdentifier() != null && correlationProperties.getAssetManagerGUID() != null && correlationProperties.getAssetManagerName() != null) {
            return this.externalIdentifierHandler.confirmSynchronization(userId, elementGUID, elementGUIDParameterName, elementTypeName, correlationProperties.getExternalIdentifier(), "correlationProperties.getExternalIdentifier()", correlationProperties.getAssetManagerGUID(), "correlationProperties.getAssetManagerGUID()", correlationProperties.getAssetManagerName(), "SoftwareCapability", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    List<MetadataCorrelationHeader> getCorrelationProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String assetManagerGUID, String assetManagerName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalIdentifierHandler.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, assetManagerGUID, "SoftwareCapability", assetManagerName, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
    }

    void maintainSupplementaryProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String elementQualifiedName, SupplementaryProperties supplementaryProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (supplementaryProperties != null) {
            this.externalIdentifierHandler.maintainSupplementaryProperties(userId, elementGUID, elementGUIDParameterName, elementTypeName, elementQualifiedName, supplementaryProperties.getDisplayName(), supplementaryProperties.getSummary(), supplementaryProperties.getDescription(), supplementaryProperties.getAbbreviation(), supplementaryProperties.getUsage(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (!isMergeUpdate) {
            this.externalIdentifierHandler.maintainSupplementaryProperties(userId, elementGUID, elementGUIDParameterName, elementTypeName, elementQualifiedName, null, null, null, null, null, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    void getSupplementaryProperties(String elementGUID, String elementGUIDParameterName, String elementTypeName, SupplementaryProperties supplementaryProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail glossaryEntity = this.externalIdentifierHandler.getSupplementaryProperties(elementGUID, elementGUIDParameterName, elementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryEntity != null && glossaryEntity.getProperties() != null) {
            supplementaryProperties.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, "displayName", glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setSummary(this.repositoryHelper.getStringProperty(this.serviceName, "summary", glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setDescription(this.repositoryHelper.getStringProperty(this.serviceName, "description", glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setAbbreviation(this.repositoryHelper.getStringProperty(this.serviceName, "abbreviation", glossaryEntity.getProperties(), methodName));
            supplementaryProperties.setUsage(this.repositoryHelper.getStringProperty(this.serviceName, "usage", glossaryEntity.getProperties(), methodName));
        }
    }

    void updateRevisionHistory(String userId, String elementGUID, String elementQualifiedName, String elementTypeName, String updateTitle, String updateDescription) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementParameterName = elementGUIDParameterName;
        String noteLogParameterName = "noteLogGUID";
        String methodName = "updateRevisionHistory";
        String noteLogQualifiedNamePrefix = "RevisionHistory:";
        String noteLogName = "Revision History";
        String noteText = "None";
        if (updateDescription != null) {
            noteText = updateDescription;
        }
        List noteLogs = this.noteLogHandler.getAttachedNoteLogs(userId, elementGUID, elementGUIDParameterName, "Referenceable", 0, 0, false, false, null, "updateRevisionHistory");
        String noteLogGUID = null;
        if (noteLogs != null) {
            for (NoteLogElement noteLogElement : noteLogs) {
                if (noteLogElement == null || noteLogElement.getProperties() == null || noteLogElement.getProperties().getQualifiedName() == null || noteLogElement.getElementHeader() == null || noteLogElement.getElementHeader().getGUID() == null || !noteLogElement.getProperties().getQualifiedName().startsWith("RevisionHistory:")) continue;
                noteLogGUID = noteLogElement.getElementHeader().getGUID();
                break;
            }
        }
        if (noteLogGUID == null) {
            noteLogGUID = this.noteLogHandler.attachNewNoteLog(userId, null, null, elementGUID, elementGUID, elementGUIDParameterName, "RevisionHistory:" + elementTypeName + ":" + elementQualifiedName, "Revision History", null, true, null, null, false, false, null, "updateRevisionHistory");
        }
        if (noteLogGUID != null) {
            this.noteHandler.attachNewNote(userId, null, null, elementGUID, noteLogGUID, "noteLogGUID", updateTitle, noteText, null, null, false, false, null, "updateRevisionHistory");
        }
    }

    public void setElementAsDataField(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, DataFieldValuesProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, elementGUID, elementGUIDParameterName, "Referenceable", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (properties != null) {
            this.externalIdentifierHandler.addDataFieldValuesClassification(userId, elementGUID, elementGUIDParameterName, "Referenceable", properties.getDefaultValue(), properties.getSampleValues(), properties.getDataPattern(), properties.getNamePattern(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.externalIdentifierHandler.addDataFieldValuesClassification(userId, elementGUID, elementGUIDParameterName, "Referenceable", null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearElementAsDataField(String userId, MetadataCorrelationProperties correlationProperties, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, elementGUID, elementGUIDParameterName, "Referenceable", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalIdentifierHandler.removeDataFieldValuesClassification(userId, elementGUID, elementGUIDParameterName, "Referenceable", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

