/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class GovernanceExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "findGovernanceActionProcesses");
                response.setElements(handler.findAssets(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "findGovernanceActionProcesses"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessesByName");
                response.setElements(handler.findAssetsByName(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getName(), "name", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getGovernanceActionProcessesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String userId, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessByGUID");
            handler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, new Date(), "getGovernanceActionProcessByGUID");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse findGovernanceActionTypes(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionTypes");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "findGovernanceActionTypes");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findGovernanceActionTypes(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "findGovernanceActionTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse getGovernanceActionTypesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypesByName");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypesByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getGovernanceActionTypesByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, null, "getGovernanceActionTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getGovernanceActionTypeByGUID(String serverName, String userId, String actionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypeByGUID");
            response.setElement((GovernanceActionTypeElement)handler.getGovernanceActionTypeByGUID(userId, actionTypeGUID, null, "getGovernanceActionTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getFirstActionType(String serverName, String userId, String processGUID) {
        String methodName = "getFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFirstActionType");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFirstActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getFirstActionType");
            response.setElement((GovernanceActionTypeElement)handler.getFirstActionType(userId, processGUID, null, null, "getFirstActionType"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NextGovernanceActionTypeElementsResponse getNextGovernanceActionTypes(String serverName, String userId, String actionTypeGUID, int startFrom, int pageSize) {
        String methodName = "getNextGovernanceActionTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNextGovernanceActionTypes");
        NextGovernanceActionTypeElementsResponse response = new NextGovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNextGovernanceActionTypes");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getNextGovernanceActionTypes");
            List relationships = handler.getNextGovernanceActionTypes(userId, actionTypeGUID, startFrom, pageSize, null, "getNextGovernanceActionTypes");
            if (relationships != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getNextGovernanceActionTypes");
                ArrayList<NextGovernanceActionTypeElement> elements = new ArrayList<NextGovernanceActionTypeElement>();
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    NextGovernanceActionTypeElement element = new NextGovernanceActionTypeElement();
                    element.setNextActionLinkGUID(relationship.getGUID());
                    element.setGuard(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "guard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setMandatoryGuard(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "mandatoryGuard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setIgnoreMultipleTriggers(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "ignoreMultipleTriggers", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setNextActionType((GovernanceActionTypeElement)handler.getGovernanceActionTypeByGUID(userId, relationship.getEntityTwoProxy().getGUID(), null, "getNextGovernanceActionTypes"));
                    elements.add(element);
                }
                response.setElements(elements);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNextGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementResponse getGovernanceAction(String serverName, String userId, String governanceActionGUID) {
        String methodName = "getGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceAction");
        AuditLog auditLog = null;
        GovernanceActionElementResponse response = new GovernanceActionElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceAction");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceAction");
            response.setElement((GovernanceActionElement)handler.getGovernanceAction(userId, governanceActionGUID, new Date(), "getGovernanceAction"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceActions");
            response.setElements(handler.getGovernanceActions(userId, startFrom, pageSize, new Date(), "getGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getActiveGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getActiveGovernanceActions");
            response.setElements(handler.getActiveGovernanceActions(userId, startFrom, pageSize, new Date(), "getActiveGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

