/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PortType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class AssetManagerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public AssetManagerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entity != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entity, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }

    DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.SORT_ORDER.name, instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return DataItemSortOrder.UNSORTED;
    }

    KeyPattern removeKeyPattern(InstanceProperties instanceProperties) {
        String methodName = "removeKeyPattern";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.KEY_PATTERN.name, instanceProperties, "removeKeyPattern");
            for (KeyPattern keyPattern : KeyPattern.values()) {
                if (keyPattern.getOrdinal() != ordinal) continue;
                return keyPattern;
            }
        }
        return KeyPattern.LOCAL_KEY;
    }

    SynchronizationDirection removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, instanceProperties, "removePermittedSynchronization");
            for (SynchronizationDirection synchronizationDirection : SynchronizationDirection.values()) {
                if (synchronizationDirection.getOpenTypeOrdinal() != ordinal) continue;
                return synchronizationDirection;
            }
        }
        return SynchronizationDirection.BOTH_DIRECTIONS;
    }

    PortType removePortType(InstanceProperties instanceProperties) {
        String methodName = "removePortType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "portType", instanceProperties, "removePortType");
            for (PortType portType : PortType.values()) {
                if (portType.getOpenTypeOrdinal() != ordinal) continue;
                return portType;
            }
        }
        return PortType.OTHER;
    }
}

