/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.NoteConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.NoteLogConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.NoteLogElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteLogProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteLogHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class NoteLogExchangeHandler
extends ExchangeHandlerBase {
    private final NoteLogHandler<NoteLogElement> noteLogHandler;
    private final NoteHandler<NoteElement> noteHandler;
    private static final String noteLogGUIDParameterName = "noteLogGUID";
    private static final String noteGUIDParameterName = "noteGUID";

    public NoteLogExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.noteLogHandler = new NoteLogHandler(new NoteLogConverter(repositoryHelper, serviceName, serverName), NoteLogElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.noteHandler = new NoteHandler(new NoteConverter(repositoryHelper, serviceName, serverName), NoteElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToNoteLogs(String userId, String assetManagerGUID, String assetManagerName, List<NoteLogElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), noteLogGUIDParameterName, "NoteLog", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToNotes(String userId, String assetManagerGUID, String assetManagerName, List<NoteElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (MetadataElement metadataElement : results) {
                if (metadataElement == null || metadataElement.getElementHeader() == null || metadataElement.getElementHeader().getGUID() == null) continue;
                metadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, metadataElement.getElementHeader().getGUID(), noteGUIDParameterName, "NoteEntry", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    public String createNoteLog(String userId, String elementGUID, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, NoteLogProperties noteLogProperties, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "noteLogProperties";
        String qualifiedNameParameterName = "noteLogProperties.qualifiedName";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateObject((Object)noteLogProperties, "noteLogProperties", methodName);
        this.invalidParameterHandler.validateName(noteLogProperties.getQualifiedName(), "noteLogProperties.qualifiedName", methodName);
        String noteLogGUID = this.noteLogHandler.attachNewNoteLog(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), elementGUID, elementGUID, "elementGUID", noteLogProperties.getQualifiedName(), noteLogProperties.getDisplayName(), noteLogProperties.getDescription(), isPublic, noteLogProperties.getEffectiveFrom(), noteLogProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (noteLogGUID != null) {
            this.createExternalIdentifier(userId, noteLogGUID, noteLogGUIDParameterName, "NoteLog", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return noteLogGUID;
    }

    public void updateNoteLog(String userId, MetadataCorrelationProperties correlationProperties, String noteLogGUID, NoteLogProperties noteLogProperties, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "noteLogProperties";
        String qualifiedNameParameterName = "noteLogProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(noteLogGUID, noteLogGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)noteLogProperties, "noteLogProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(noteLogProperties.getQualifiedName(), "noteLogProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, noteLogGUID, noteLogGUIDParameterName, "NoteLog", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.noteLogHandler.updateNoteLog(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), noteLogGUID, noteLogGUIDParameterName, noteLogProperties.getQualifiedName(), noteLogProperties.getDisplayName(), noteLogProperties.getDescription(), isPublic, isMergeUpdate, noteLogProperties.getEffectiveFrom(), noteLogProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeNoteLog(String userId, MetadataCorrelationProperties correlationProperties, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validateExternalIdentifier(userId, noteLogGUID, noteLogGUIDParameterName, "NoteLog", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.noteLogHandler.removeNoteLogFromElement(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), noteLogGUID, noteLogGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<NoteLogElement> findNoteLogs(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.noteLogHandler.findNoteLogs(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToNoteLogs(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<NoteLogElement> getNoteLogsByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.noteLogHandler.getNoteLogsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToNoteLogs(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<NoteLogElement> getNoteLogsForElement(String userId, String assetManagerGUID, String assetManagerName, String elementGUID, String elementParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.noteLogHandler.getAttachedNoteLogs(userId, elementGUID, elementParameterName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToNoteLogs(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public NoteLogElement getNoteLogByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        NoteLogElement noteLog = (NoteLogElement)this.noteLogHandler.getBeanFromRepository(userId, openMetadataGUID, "openMetadataGUID", "NoteLog", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (noteLog != null) {
            noteLog.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", "NoteLog", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return noteLog;
    }

    public String createNote(String userId, String noteLogGUID, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, NoteProperties noteProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "noteProperties";
        String qualifiedNameParameterName = "noteProperties.qualifiedName";
        String elementGUIDParameterName = noteLogGUIDParameterName;
        this.invalidParameterHandler.validateObject((Object)noteProperties, "noteProperties", methodName);
        this.invalidParameterHandler.validateName(noteProperties.getQualifiedName(), "noteProperties.qualifiedName", methodName);
        String noteGUID = this.noteHandler.attachNewNote(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), noteLogGUID, noteLogGUID, noteLogGUIDParameterName, noteProperties.getQualifiedName(), noteProperties.getTitle(), noteProperties.getText(), noteProperties.getEffectiveFrom(), noteProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (noteGUID != null) {
            this.createExternalIdentifier(userId, noteGUID, noteGUIDParameterName, "NoteEntry", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return noteGUID;
    }

    public void updateNote(String userId, MetadataCorrelationProperties correlationProperties, String noteGUID, NoteProperties noteProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "noteProperties";
        String qualifiedNameParameterName = "noteProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(noteGUID, noteGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)noteProperties, "noteProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(noteProperties.getQualifiedName(), "noteProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, noteGUID, noteGUIDParameterName, "NoteEntry", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.noteHandler.updateNote(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), noteGUID, noteGUIDParameterName, noteProperties.getQualifiedName(), noteProperties.getTitle(), noteProperties.getText(), isMergeUpdate, noteProperties.getEffectiveFrom(), noteProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeNote(String userId, MetadataCorrelationProperties correlationProperties, String noteGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(noteGUID, noteGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, noteGUID, noteGUIDParameterName, "NoteEntry", correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.noteHandler.removeNoteFromElement(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), noteGUID, noteGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<NoteElement> findNotes(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.noteHandler.findNotes(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToNotes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<NoteElement> getNotesForNoteLog(String userId, String assetManagerGUID, String assetManagerName, String noteLogGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.noteHandler.getNotes(userId, noteLogGUID, noteLogGUIDParameterName, "NoteLog", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToNotes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public NoteElement getNoteByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        NoteElement note = (NoteElement)this.noteHandler.getBeanFromRepository(userId, guid, "guid", "NoteEntry", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (note != null) {
            note.setCorrelationHeaders(this.getCorrelationProperties(userId, guid, "guid", "NoteEntry", assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return note;
    }
}

