/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.CommentExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.NoteLogExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LikeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RatingElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteLogProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TagProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RatingHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class CollaborationExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AssetManagerRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse addRatingToElement(String serverName, String userId, String guid, boolean isPublic, RatingProperties requestBody) {
        String methodName = "addRatingToElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                RatingHandler<RatingElement> handler = instanceHandler.getRatingHandler(userId, serverName, "addRatingToElement");
                int starRating = StarRating.NOT_RECOMMENDED.getOrdinal();
                if (requestBody.getStarRating() != null) {
                    starRating = requestBody.getStarRating().getOrdinal();
                }
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToElement");
                handler.saveRating(userId, null, null, guid, "guid", starRating, requestBody.getReview(), isPublic, false, false, new Date(), "addRatingToElement");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addRatingToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addRatingToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromElement(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler<RatingElement> handler = instanceHandler.getRatingHandler(userId, serverName, "removeRatingFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromElement");
            handler.removeRating(userId, null, null, guid, "guid", false, false, new Date(), "removeRatingFromElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeRatingFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToElement(String serverName, String userId, String guid, boolean isPublic, NullRequestBody requestBody) {
        String methodName = "addLikeToElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                LikeHandler<LikeElement> handler = instanceHandler.getLikeHandler(userId, serverName, "addLikeToElement");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToElement");
                handler.saveLike(userId, null, null, guid, "guid", isPublic, false, false, new Date(), "addLikeToElement");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLikeToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLikeToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromElement(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler<LikeElement> handler = instanceHandler.getLikeHandler(userId, serverName, "removeLikeFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromElement");
            handler.removeLike(userId, null, null, guid, "guid", false, false, new Date(), "removeLikeFromElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLikeFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToElement(String serverName, String userId, String guid, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentToElement";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToElement");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentToElement");
                    response.setGUID(handler.createComment(userId, guid, "elementGUID", requestBody.getMetadataCorrelationProperties(), isPublic, commentProperties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addCommentToElement"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentToElement");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentToElement", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String commentGUID, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "addCommentReply");
                    response.setGUID(handler.createComment(userId, commentGUID, "commentGUID", requestBody.getMetadataCorrelationProperties(), isPublic, commentProperties, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addCommentReply"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentReply");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String commentGUID, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "updateComment");
                    handler.updateComment(userId, requestBody.getMetadataCorrelationProperties(), commentGUID, commentProperties, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateComment");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "updateComment");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAcceptedAnswer(String serverName, String userId, String questionCommentGUID, String answerCommentGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAcceptedAnswer");
            CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "setupAcceptedAnswer");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof FeedbackProperties) {
                    FeedbackProperties feedbackProperties = (FeedbackProperties)relationshipProperties;
                    handler.setupAcceptedAnswer(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), questionCommentGUID, answerCommentGUID, feedbackProperties.getIsPublic(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupAcceptedAnswer");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "setupAcceptedAnswer");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupAcceptedAnswer", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAcceptedAnswer(String serverName, String userId, String questionCommentGUID, String answerCommentGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAcceptedAnswer");
            CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "clearAcceptedAnswer");
            if (requestBody != null) {
                handler.clearAcceptedAnswer(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearAcceptedAnswer");
            } else {
                handler.clearAcceptedAnswer(userId, null, null, questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, null, "clearAcceptedAnswer");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromElement(String serverName, String userId, String elementGUID, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeElementComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeElementComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementComment");
            CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "removeElementComment");
            if (requestBody != null) {
                handler.removeComment(userId, requestBody.getMetadataCorrelationProperties(), commentGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeElementComment");
            } else {
                handler.removeComment(userId, null, commentGUID, forLineage, forDuplicateProcessing, null, "removeElementComment");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementResponse getCommentByGUID(String serverName, String userId, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getComment";
        String guidParameterName = "commentGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getComment");
        CommentElementResponse response = new CommentElementResponse();
        AuditLog auditLog = null;
        try {
            CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "getComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getComment");
            if (requestBody != null) {
                response.setElement(handler.getCommentByGUID(userId, commentGUID, "commentGUID", OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getComment"));
            } else {
                response.setElement(handler.getCommentByGUID(userId, commentGUID, "commentGUID", OpenMetadataType.COMMENT.typeName, forLineage, forDuplicateProcessing, null, "getComment"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse getAttachedComments(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedComments";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAttachedComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            CommentExchangeHandler handler = instanceHandler.getCommentHandler(userId, serverName, "getAttachedComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedComments");
            if (requestBody != null) {
                response.setElementList(handler.getAttachedComments(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), elementGUID, "elementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getAttachedComments"));
            } else {
                response.setElementList(handler.getAttachedComments(userId, null, null, elementGUID, "elementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getAttachedComments"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createInformalTag(String serverName, String userId, TagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createTag(userId, null, null, requestBody.getName(), requestBody.getDescription(), !requestBody.getIsPrivateTag(), null, null, new Date(), "createTag"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, InformalTagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, null, null, tagGUID, "tagGUID", requestBody.getDescription(), null, null, false, false, new Date(), "updateTagDescription");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, null, null, tagGUID, "tagGUID", false, false, new Date(), "deleteTag");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag((InformalTagElement)handler.getTag(userId, guid, "guid", false, false, new Date(), "getTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getMyTagsByName(userId, requestBody.getName(), "tagName", startFrom, pageSize, false, false, new Date(), "getMyTagsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setTags(handler.findTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findMyTags";
        String nameParameterName = "tagName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setTags(handler.findMyTags(userId, requestBody.getSearchString(), "tagName", startFrom, pageSize, false, false, new Date(), "findMyTags"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String userId, String elementGUID, String tagGUID, FeedbackProperties requestBody) {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "addTagToElement"), isPublic, null, null, false, false, new Date(), "addTagToElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String userId, String elementGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.ASSET.typeName, tagGUID, "tagGUID", instanceHandler.getSupportedZones(userId, serverName, "removeTagFromElement"), false, false, new Date(), "removeTagFromElement");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getElementsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getElementsByTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTagElement> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getElementsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByTag");
            response.setGUIDs(handler.getAttachedElementGUIDs(userId, tagGUID, "tagGUID", "InformalTag", null, null, OpenMetadataType.REFERENCEABLE.typeName, false, false, startFrom, pageSize, new Date(), "getElementsByTag"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNoteLog(String serverName, String userId, String elementGUID, boolean assetManagerIsHome, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createNoteLog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createNoteLog");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteLogProperties) {
                    NoteLogProperties properties = (NoteLogProperties)referenceableProperties;
                    NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "createNoteLog");
                    response.setGUID(handler.createNoteLog(userId, elementGUID, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, properties, isPublic, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "createNoteLog"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(NoteLogProperties.class.getName(), "createNoteLog");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createNoteLog", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNoteLog(String serverName, String userId, String noteLogGUID, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNoteLog");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteLogProperties) {
                    NoteLogProperties properties = (NoteLogProperties)referenceableProperties;
                    NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "updateNoteLog");
                    handler.updateNoteLog(userId, requestBody.getMetadataCorrelationProperties(), noteLogGUID, properties, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateNoteLog");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(NoteLogProperties.class.getName(), "updateNoteLog");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateNoteLog", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNoteLog(String serverName, String userId, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNoteLog");
            NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "removeNoteLog");
            if (requestBody != null) {
                handler.removeNoteLog(userId, requestBody.getMetadataCorrelationProperties(), noteLogGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeNoteLog");
            } else {
                handler.removeNoteLog(userId, null, noteLogGUID, forLineage, forDuplicateProcessing, null, "removeNoteLog");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse findNoteLogs(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findNoteLogs";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findNoteLogs");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNoteLogs");
            if (requestBody != null) {
                NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "findNoteLogs");
                response.setElementList(handler.findNoteLogs(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), "searchString", startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing, "findNoteLogs"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findNoteLogs", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNoteLogs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse getNoteLogsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getNoteLogsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteLogsByName");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogsByName");
            if (requestBody != null) {
                NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNoteLogsByName");
                response.setElementList(handler.getNoteLogsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), "name", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getNoteLogsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getNoteLogsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse getNoteLogsForElement(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNotesForNoteLog");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNoteLogsForElement(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), elementGUID, "elementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getNotesForNoteLog"));
            } else {
                response.setElementList(handler.getNoteLogsForElement(userId, null, null, elementGUID, "elementGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getNotesForNoteLog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementResponse getNoteLogByGUID(String serverName, String userId, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteLogByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteLogByGUID");
        NoteLogElementResponse response = new NoteLogElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogByGUID");
            if (requestBody != null) {
                NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNoteLogByGUID");
                response.setElement(handler.getNoteLogByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), noteLogGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getNoteLogByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getNoteLogByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNote(String serverName, String userId, boolean assetManagerIsHome, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createNote");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createNote");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteProperties) {
                    NoteProperties properties = (NoteProperties)referenceableProperties;
                    NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "createNote");
                    response.setGUID(handler.createNote(userId, noteLogGUID, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing, "createNote"));
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(NoteProperties.class.getName(), "createNote");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createNote", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNote(String serverName, String userId, String noteGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNote");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteProperties) {
                    NoteProperties properties = (NoteProperties)referenceableProperties;
                    NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "updateNote");
                    handler.updateNote(userId, requestBody.getMetadataCorrelationProperties(), noteGUID, properties, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateNote");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(NoteProperties.class.getName(), "updateNote");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateNote", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNote(String serverName, String userId, String noteGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNote");
            NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "removeNote");
            if (requestBody != null) {
                handler.removeNote(userId, requestBody.getMetadataCorrelationProperties(), noteGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeNote");
            } else {
                handler.removeNote(userId, null, noteGUID, forLineage, forDuplicateProcessing, null, "removeNote");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementsResponse findNotes(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findNotes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findNotes");
        NoteElementsResponse response = new NoteElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNotes");
            if (requestBody != null) {
                NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "findNotes");
                response.setElementList(handler.findNotes(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findNotes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findNotes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNotes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementsResponse getNotesForNoteLog(String serverName, String userId, String noteLogGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNotesForNoteLog");
        NoteElementsResponse response = new NoteElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNotesForNoteLog(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), noteLogGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getNotesForNoteLog"));
            } else {
                response.setElementList(handler.getNotesForNoteLog(userId, null, null, noteLogGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getNotesForNoteLog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementResponse getNoteByGUID(String serverName, String userId, String noteGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteByGUID");
        NoteElementResponse response = new NoteElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteByGUID");
            if (requestBody != null) {
                NoteLogExchangeHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNoteByGUID");
                response.setElement(handler.getNoteByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), noteGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getNoteByGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getNoteByGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

