/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.LineageMappingProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LineageMappingConverter<B>
extends AssetManagerOMASConverter<B> {
    public LineageMappingConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof LineageMappingElement) {
                LineageMappingElement bean = (LineageMappingElement)returnBean;
                LineageMappingProperties lineageMappingProperties = new LineageMappingProperties();
                if (relationship != null) {
                    bean.setLineageMappingHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                    EntityProxy entityProxy = relationship.getEntityOneProxy();
                    if (entityProxy != null) {
                        bean.setSourceElement(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    if ((entityProxy = relationship.getEntityTwoProxy()) != null) {
                        bean.setTargetElement(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
                    lineageMappingProperties.setQualifiedName(this.getQualifiedName(instanceProperties));
                    lineageMappingProperties.setDescription(this.getDescription(instanceProperties));
                    bean.setLineageMappingProperties(lineageMappingProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

