/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.SoftwareCapabilityProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SoftwareCapabilityConverter<B>
extends AssetManagerOMASConverter<B> {
    public SoftwareCapabilityConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SoftwareCapabilityElement) {
                SoftwareCapabilityElement bean = (SoftwareCapabilityElement)returnBean;
                SoftwareCapabilityProperties softwareCapabilitiesProperties = new SoftwareCapabilityProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    softwareCapabilitiesProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    softwareCapabilitiesProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    softwareCapabilitiesProperties.setResourceName(this.removeName(instanceProperties));
                    softwareCapabilitiesProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    softwareCapabilitiesProperties.setDeployedImplementationType(this.removeCapabilityType(instanceProperties));
                    softwareCapabilitiesProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    softwareCapabilitiesProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    softwareCapabilitiesProperties.setSource(this.removeSource(instanceProperties));
                    softwareCapabilitiesProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    softwareCapabilitiesProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setSoftwareCapabilitiesProperties(softwareCapabilitiesProperties);
                } else {
                    this.handleMissingMetadataInstance(SoftwareCapabilityProperties.class.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

