/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ExternalReferenceConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ExternalReferenceLinkConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceLinkElement;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceLinkHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalReferenceExchangeHandler
extends ExchangeHandlerBase {
    private final ExternalReferenceHandler<ExternalReferenceElement> externalReferenceHandler;
    private final ExternalReferenceLinkHandler<ExternalReferenceLinkElement> externalReferenceLinkHandler;
    private static final String externalReferenceGUIDParameterName = "externalReferenceGUID";

    public ExternalReferenceExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.externalReferenceHandler = new ExternalReferenceHandler(new ExternalReferenceConverter(repositoryHelper, serviceName, serverName), ExternalReferenceElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.externalReferenceLinkHandler = new ExternalReferenceLinkHandler(new ExternalReferenceLinkConverter(repositoryHelper, serviceName, serverName), ExternalReferenceLinkElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToExternalReferences(String userId, String assetManagerGUID, String assetManagerName, List<ExternalReferenceElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (ExternalReferenceElement externalReference : results) {
                if (externalReference == null || externalReference.getElementHeader() == null || externalReference.getElementHeader().getGUID() == null) continue;
                externalReference.setCorrelationHeaders(this.getCorrelationProperties(userId, externalReference.getElementHeader().getGUID(), externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToExternalReferenceLinks(String userId, String assetManagerGUID, String assetManagerName, List<ExternalReferenceLinkElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    public String createExternalReference(String userId, boolean assetManagerIsHome, MetadataCorrelationProperties correlationProperties, ExternalReferenceProperties externalReferenceProperties, String anchorGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "externalReferenceProperties";
        String qualifiedNameParameterName = "externalReferenceProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)externalReferenceProperties, "externalReferenceProperties", methodName);
        this.invalidParameterHandler.validateName(externalReferenceProperties.getQualifiedName(), "externalReferenceProperties.qualifiedName", methodName);
        String externalReferenceGUID = this.externalReferenceHandler.createExternalReference(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), anchorGUID, externalReferenceProperties.getQualifiedName(), externalReferenceProperties.getDisplayName(), externalReferenceProperties.getResourceDescription(), externalReferenceProperties.getURI(), externalReferenceProperties.getVersion(), externalReferenceProperties.getOrganization(), externalReferenceProperties.getAdditionalProperties(), externalReferenceProperties.getTypeName(), externalReferenceProperties.getExtendedProperties(), externalReferenceProperties.getEffectiveFrom(), externalReferenceProperties.getEffectiveTo(), new Date(), methodName);
        if (externalReferenceGUID != null) {
            this.createExternalIdentifier(userId, externalReferenceGUID, externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, correlationProperties, false, false, null, methodName);
        }
        return externalReferenceGUID;
    }

    public void updateExternalReference(String userId, MetadataCorrelationProperties correlationProperties, String externalReferenceGUID, boolean isMergeUpdate, ExternalReferenceProperties externalReferenceProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "externalReferenceProperties";
        String qualifiedNameParameterName = "externalReferenceProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, externalReferenceGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)externalReferenceProperties, "externalReferenceProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(externalReferenceProperties.getQualifiedName(), "externalReferenceProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, externalReferenceGUID, externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalReferenceHandler.updateExternalReference(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), externalReferenceGUID, externalReferenceGUIDParameterName, externalReferenceProperties.getQualifiedName(), externalReferenceProperties.getDisplayName(), externalReferenceProperties.getResourceDescription(), externalReferenceProperties.getURI(), externalReferenceProperties.getVersion(), externalReferenceProperties.getOrganization(), externalReferenceProperties.getAdditionalProperties(), externalReferenceProperties.getTypeName(), externalReferenceProperties.getExtendedProperties(), externalReferenceProperties.getEffectiveFrom(), externalReferenceProperties.getEffectiveTo(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeExternalReference(String userId, MetadataCorrelationProperties correlationProperties, String externalReferenceGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, externalReferenceGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, externalReferenceGUID, externalReferenceGUIDParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (correlationProperties != null) {
            this.externalReferenceHandler.removeExternalReference(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), externalReferenceGUID, externalReferenceGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.externalReferenceHandler.removeExternalReference(userId, null, null, externalReferenceGUID, externalReferenceGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public String linkExternalReferenceToElement(String userId, String assetManagerGUID, String assetManagerName, String attachedToGUID, String attachedToGUIDParameterName, String externalReferenceGUID, String externalReferenceGUIDParameterName, ExternalReferenceLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(attachedToGUID, attachedToGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, externalReferenceGUIDParameterName, methodName);
        String relationshipGUID = linkProperties != null ? this.externalReferenceLinkHandler.setupExternalReferenceLink(userId, assetManagerGUID, assetManagerName, attachedToGUID, attachedToGUIDParameterName, externalReferenceGUID, externalReferenceGUIDParameterName, linkProperties.getLinkId(), linkProperties.getLinkDescription(), linkProperties.getEffectiveFrom(), linkProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName) : this.externalReferenceLinkHandler.setupExternalReferenceLink(userId, assetManagerGUID, assetManagerName, attachedToGUID, attachedToGUIDParameterName, externalReferenceGUID, externalReferenceGUIDParameterName, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.externalIdentifierHandler.logRelationshipCreation(assetManagerGUID, assetManagerName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, attachedToGUID, OpenMetadataType.REFERENCEABLE.typeName, externalReferenceGUID, OpenMetadataType.EXTERNAL_REFERENCE.typeName, methodName);
        return relationshipGUID;
    }

    public void updateExternalReferenceToElementLink(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceLinkGUID, String externalReferenceGUIDParameterName, ExternalReferenceLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceLinkGUID, externalReferenceGUIDParameterName, methodName);
        if (linkProperties != null) {
            this.externalReferenceLinkHandler.updateExternalReferenceLink(userId, assetManagerGUID, assetManagerName, externalReferenceLinkGUID, externalReferenceGUIDParameterName, linkProperties.getLinkId(), linkProperties.getLinkDescription(), linkProperties.getEffectiveFrom(), linkProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.externalReferenceLinkHandler.updateExternalReferenceLink(userId, assetManagerGUID, assetManagerName, externalReferenceLinkGUID, externalReferenceGUIDParameterName, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.externalIdentifierHandler.logRelationshipUpdate(assetManagerGUID, assetManagerName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, externalReferenceLinkGUID, methodName);
    }

    public void unlinkExternalReferenceFromElement(String userId, String assetManagerGUID, String assetManagerName, String externalReferenceLinkGUID, String externalReferenceGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalReferenceLinkGUID, externalReferenceGUIDParameterName, methodName);
        Relationship relationship = this.externalReferenceLinkHandler.clearExternalReferenceLink(userId, assetManagerGUID, assetManagerName, externalReferenceLinkGUID, externalReferenceGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            this.externalIdentifierHandler.logRelationshipRemoval(assetManagerGUID, assetManagerName, OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, relationship.getEntityOneProxy().getGUID(), OpenMetadataType.REFERENCEABLE.typeName, relationship.getEntityTwoProxy().getGUID(), OpenMetadataType.EXTERNAL_REFERENCE.typeName, methodName);
        }
    }

    public List<ExternalReferenceElement> getExternalReferences(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.externalReferenceHandler.getExternalReferences(userId, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferences(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ExternalReferenceElement> findExternalReferences(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.externalReferenceHandler.findExternalReferences(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferences(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ExternalReferenceElement> getExternalReferencesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.externalReferenceHandler.getExternalReferencesByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferences(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ExternalReferenceElement> getExternalReferencesById(String userId, String assetManagerGUID, String assetManagerName, String referenceId, String referenceIdParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.externalReferenceHandler.getExternalReferencesById(userId, referenceId, referenceIdParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferences(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String userId, String assetManagerGUID, String assetManagerName, String url, String urlParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.externalReferenceHandler.getExternalReferencesByURL(userId, url, urlParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferences(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ExternalReferenceElement> getExternalReferencesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String externalReferenceEntityParameterName = "externalReferenceEntity";
        String externalReferenceGUIDParameterName = "externalReferenceEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<ExternalReferenceElement> results = new ArrayList<ExternalReferenceElement>();
        List externalReferenceEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (externalReferenceEntities != null) {
            for (EntityDetail externalReferenceEntity : externalReferenceEntities) {
                ExternalReferenceElement externalReferenceElement;
                if (externalReferenceEntity == null || (externalReferenceElement = (ExternalReferenceElement)this.externalReferenceHandler.getBeanFromEntity(userId, externalReferenceEntity, "externalReferenceEntity", methodName)) == null) continue;
                externalReferenceElement.setCorrelationHeaders(this.getCorrelationProperties(userId, externalReferenceEntity.getGUID(), "externalReferenceEntity.getGUID()", OpenMetadataType.EXTERNAL_REFERENCE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                results.add(externalReferenceElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<ExternalReferenceLinkElement> retrieveAttachedExternalReferences(String userId, String assetManagerGUID, String assetManagerName, String attachedToGUID, String attachedToGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List results = this.externalReferenceLinkHandler.getExternalReferences(userId, attachedToGUID, attachedToGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToExternalReferenceLinks(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalReferenceElement externalReference = (ExternalReferenceElement)this.externalReferenceHandler.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, false, false, effectiveTime, methodName);
        if (externalReference != null) {
            externalReference.setCorrelationHeaders(this.getCorrelationProperties(userId, guid, guidParameterName, OpenMetadataType.EXTERNAL_REFERENCE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return externalReference;
    }
}

