/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.outtopic;

import org.odpi.openmetadata.accessservices.assetmanager.connectors.outtopic.AssetManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.ffdc.AssetManagerAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetManagerOutTopicPublisher {
    private final AssetManagerOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final ElementHeaderConverter<ElementHeader> headerConverter;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public AssetManagerOutTopicPublisher(AssetManagerOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        this.repositoryHelper = repositoryHelper;
        this.headerConverter = new ElementHeaderConverter(repositoryHelper, serviceName, serverName);
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", AssetManagerAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    public void publishEntityEvent(EntityDetail entity, AssetManagerEventType eventType) {
        this.publishEntityEvent(eventType, entity, null, null, null);
    }

    public void publishEntityEvent(AssetManagerEventType eventType, EntityDetail entity, EntityDetail previousEntity, Classification newClassification, Classification previousClassification) {
        String methodName = "publishEntityEvent";
        if (this.outTopicServerConnector != null) {
            AssetManagerOutTopicEvent event = new AssetManagerOutTopicEvent();
            try {
                event.setEventType(eventType);
                if (entity.getUpdateTime() == null) {
                    event.setEventTime(entity.getCreateTime());
                } else {
                    event.setEventTime(entity.getUpdateTime());
                }
                event.setElementHeader(this.headerConverter.getNewBean(ElementHeader.class, entity, "publishEntityEvent"));
                event.setElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(entity.getProperties()));
                if (previousEntity != null) {
                    event.setPreviousElementHeader(this.headerConverter.getNewBean(ElementHeader.class, previousEntity, "publishEntityEvent"));
                    event.setPreviousElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousEntity.getProperties()));
                }
                if (newClassification != null) {
                    event.setClassificationName(newClassification.getName());
                }
                if (previousClassification != null) {
                    event.setClassificationName(previousClassification.getName());
                    event.setPreviousClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousClassification.getProperties()));
                }
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                this.outTopicAuditLog.logException("publishEntityEvent", AssetManagerAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.toString(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void publishRelationshipEvent(AssetManagerEventType eventType, Relationship relationship, Relationship previousRelationship, EntityDetail end1, EntityDetail end2) {
        String methodName = "publishRelationshipEvent";
        if (this.outTopicServerConnector != null) {
            AssetManagerOutTopicEvent event = new AssetManagerOutTopicEvent();
            try {
                event.setEventType(eventType);
                if (relationship.getUpdateTime() == null) {
                    event.setEventTime(relationship.getCreateTime());
                } else {
                    event.setEventTime(relationship.getUpdateTime());
                }
                event.setElementHeader(this.headerConverter.getNewBean(ElementHeader.class, relationship, "publishRelationshipEvent"));
                event.setElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(relationship.getProperties()));
                if (previousRelationship != null) {
                    event.setPreviousElementHeader(this.headerConverter.getNewBean(ElementHeader.class, previousRelationship, "publishRelationshipEvent"));
                    event.setPreviousElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousRelationship.getProperties()));
                }
                event.setEndOneElementHeader(this.headerConverter.getNewBean(ElementHeader.class, end1, "publishRelationshipEvent"));
                event.setEndOneElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(end1.getProperties()));
                event.setEndTwoElementHeader(this.headerConverter.getNewBean(ElementHeader.class, end2, "publishRelationshipEvent"));
                event.setEndTwoElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(end2.getProperties()));
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                this.outTopicAuditLog.logException("publishRelationshipEvent", AssetManagerAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.toString(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", AssetManagerAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", AssetManagerAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

