/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ProcessExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessContainmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ControlFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.DataFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.LineageMappingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ProcessCallProperties;
import org.slf4j.LoggerFactory;

public class LineageExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(LineageExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createProcess(String serverName, String userId, boolean assetManagerIsHome, ProcessRequestBody requestBody) {
        String methodName = "createProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProcess");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createProcess");
                response.setGUID(handler.createProcess(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), requestBody.getProcessStatus(), requestBody.getEffectiveTime(), "createProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createProcessFromTemplate(String serverName, String userId, boolean assetManagerIsHome, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createProcessFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProcessFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProcessFromTemplate");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createProcessFromTemplate");
                response.setGUID(handler.createProcessFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), requestBody.getEffectiveTime(), "createProcessFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createProcessFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createProcessFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcess(String serverName, String userId, String processGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ProcessRequestBody requestBody) {
        String methodName = "updateProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcess");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcess");
                handler.updateProcess(userId, requestBody.getMetadataCorrelationProperties(), processGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcessStatus(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, ProcessStatusRequestBody requestBody) {
        String methodName = "updateProcessStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcessStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcessStatus");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcessStatus");
                handler.updateProcessStatus(userId, requestBody.getMetadataCorrelationProperties(), processGUID, requestBody.getProcessStatus(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateProcessStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcessStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateProcessStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProcessParent(String serverName, String userId, String parentProcessGUID, String childProcessGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessParent");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ProcessContainmentProperties) {
                    ProcessContainmentProperties properties = (ProcessContainmentProperties)relationshipProperties;
                    handler.setupProcessParent(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, parentProcessGUID, childProcessGUID, properties.getProcessContainmentType(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupProcessParent");
                } else {
                    handler.setupProcessParent(userId, null, null, assetManagerIsHome, parentProcessGUID, childProcessGUID, null, null, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupProcessParent");
                }
            } else {
                handler.setupProcessParent(userId, null, null, assetManagerIsHome, parentProcessGUID, childProcessGUID, null, null, null, forLineage, forDuplicateProcessing, new Date(), "setupProcessParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessParent(String serverName, String userId, String parentProcessGUID, String childProcessGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessParent");
            if (requestBody != null) {
                handler.clearProcessParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), parentProcessGUID, childProcessGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearProcessParent");
            } else {
                handler.clearProcessParent(userId, null, null, parentProcessGUID, childProcessGUID, forLineage, forDuplicateProcessing, new Date(), "clearProcessParent");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishProcess(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "publishProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "publishProcess");
            if (requestBody != null) {
                handler.publishProcess(userId, processGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "publishProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "publishProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawProcess(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "withdrawProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "withdrawProcess");
            if (requestBody != null) {
                handler.withdrawProcess(userId, processGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "withdrawProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "withdrawProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeProcess(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removeProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "removeProcess");
            if (requestBody != null) {
                handler.removeProcess(userId, requestBody.getMetadataCorrelationProperties(), processGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse findProcesses(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findProcesses");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProcesses");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "findProcesses");
                response.setElementList(handler.findProcesses(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findProcesses"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getProcessesForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getProcessesForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessesForAssetManager");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessesForAssetManager");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessesForAssetManager");
                response.setElementList(handler.getProcessesForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessesForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getProcessesForAssetManager", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessesForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getProcessesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getProcessesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessesByName");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessesByName");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessesByName");
                response.setElementList(handler.getProcessesByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementResponse getProcessByGUID(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getProcessByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessByGUID");
        ProcessElementResponse response = new ProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessByGUID");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessByGUID");
            if (requestBody != null) {
                response.setElement(handler.getProcessByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessByGUID"));
            } else {
                response.setElement(handler.getProcessByGUID(userId, null, null, processGUID, forLineage, forDuplicateProcessing, new Date(), "getProcessByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementResponse getProcessParent(String serverName, String userId, String processGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getProcessParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessParent");
        ProcessElementResponse response = new ProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessParent");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessParent");
            if (requestBody != null) {
                response.setElement(handler.getProcessParent(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessParent"));
            } else {
                response.setElement(handler.getProcessParent(userId, null, null, processGUID, forLineage, forDuplicateProcessing, new Date(), "getProcessParent"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessElementsResponse getSubProcesses(String serverName, String userId, String processGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSubProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSubProcesses");
        ProcessElementsResponse response = new ProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubProcesses");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getSubProcesses");
            if (requestBody != null) {
                response.setElementList(handler.getSubProcesses(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getSubProcesses"));
            } else {
                response.setElementList(handler.getSubProcesses(userId, null, null, processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getSubProcesses"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSubProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createPort(String serverName, String userId, boolean assetManagerIsHome, String processGUID, boolean forLineage, boolean forDuplicateProcessing, PortRequestBody requestBody) {
        String methodName = "createPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPort");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createPort");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "createPort");
                response.setGUID(handler.createPort(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, processGUID, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "createPort"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPort", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updatePort(String serverName, String userId, String portGUID, boolean forLineage, boolean forDuplicateProcessing, PortRequestBody requestBody) {
        String methodName = "updatePort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updatePort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePort");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updatePort");
                handler.updatePort(userId, requestBody.getMetadataCorrelationProperties(), portGUID, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updatePort");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updatePort", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updatePort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProcessPort(String serverName, String userId, boolean assetManagerIsHome, String processGUID, String portGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupProcessPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessPort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessPort");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessPort");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupProcessPort(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, processGUID, portGUID, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupProcessPort");
                } else {
                    handler.setupProcessPort(userId, null, null, assetManagerIsHome, processGUID, portGUID, null, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupProcessPort");
                }
            } else {
                handler.setupProcessPort(userId, null, null, assetManagerIsHome, processGUID, portGUID, null, null, forLineage, forDuplicateProcessing, new Date(), "setupProcessPort");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupProcessPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessPort(String serverName, String userId, String processGUID, String portGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearProcessPort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessPort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessPort");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessPort");
            if (requestBody != null) {
                handler.clearProcessPort(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, portGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearProcessPort");
            } else {
                handler.clearProcessPort(userId, null, null, processGUID, portGUID, forLineage, forDuplicateProcessing, new Date(), "clearProcessPort");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearProcessPort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupPortDelegation(String serverName, String userId, boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupPortDelegation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupPortDelegation");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupPortDelegation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, portOneGUID, portTwoGUID, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), forLineage, forDuplicateProcessing, new Date(), "setupPortDelegation");
                } else {
                    handler.setupPortDelegation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, portOneGUID, portTwoGUID, null, null, forLineage, forDuplicateProcessing, new Date(), "setupPortDelegation");
                }
            } else {
                handler.setupPortDelegation(userId, null, null, assetManagerIsHome, portOneGUID, portTwoGUID, null, null, forLineage, forDuplicateProcessing, new Date(), "setupPortDelegation");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearPortDelegation(String serverName, String userId, String portOneGUID, String portTwoGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearPortDelegation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearPortDelegation");
            if (requestBody != null) {
                handler.clearPortDelegation(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portOneGUID, portTwoGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearPortDelegation");
            } else {
                handler.clearPortDelegation(userId, null, null, portOneGUID, portTwoGUID, forLineage, forDuplicateProcessing, new Date(), "clearPortDelegation");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupPortSchemaType(String serverName, String userId, boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupPortSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupPortSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupPortSchemaType");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupPortSchemaType");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupPortSchemaType(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, portGUID, schemaTypeGUID, requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupPortSchemaType");
                } else {
                    handler.setupPortSchemaType(userId, null, null, assetManagerIsHome, portGUID, schemaTypeGUID, null, null, forLineage, forDuplicateProcessing, new Date(), "setupPortSchemaType");
                }
            } else {
                handler.setupPortSchemaType(userId, null, null, assetManagerIsHome, portGUID, schemaTypeGUID, null, null, forLineage, forDuplicateProcessing, new Date(), "setupPortSchemaType");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupPortSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearPortSchemaType(String serverName, String userId, String portGUID, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearPortSchemaType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearPortSchemaType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearPortSchemaType");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearPortSchemaType");
            if (requestBody != null) {
                handler.clearPortSchemaType(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, schemaTypeGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearPortSchemaType");
            } else {
                handler.clearPortSchemaType(userId, null, null, portGUID, schemaTypeGUID, forLineage, forDuplicateProcessing, new Date(), "clearPortSchemaType");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearPortSchemaType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removePort(String serverName, String userId, String portGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removePort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removePort");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removePort");
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "removePort");
                handler.removePort(userId, requestBody.getMetadataCorrelationProperties(), portGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removePort");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removePort", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removePort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse findPorts(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findPorts";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findPorts");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findPorts");
            if (requestBody != null) {
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "findPorts");
                response.setElementList(handler.findPorts(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), requestBody.getSearchStringParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findPorts"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findPorts", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findPorts", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortsForProcess(String serverName, String userId, String processGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getPortsForProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortsForProcess");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortsForProcess");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortsForProcess");
            if (requestBody != null) {
                response.setElementList(handler.getPortsForProcess(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getPortsForProcess"));
            } else {
                response.setElementList(handler.getPortsForProcess(userId, null, null, processGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getPortsForProcess"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPortsForProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortUse(String serverName, String userId, String portGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getPortUse";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortUse");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortUse");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortUse");
            if (requestBody != null) {
                response.setElementList(handler.getPortUse(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getPortUse"));
            } else {
                response.setElementList(handler.getPortUse(userId, null, null, portGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getPortUse"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPortUse", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementResponse getPortDelegation(String serverName, String userId, String portGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getPortDelegation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortDelegation");
        PortElementResponse response = new PortElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortDelegation");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortDelegation");
            if (requestBody != null) {
                response.setElement(handler.getPortDelegation(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getPortDelegation"));
            } else {
                response.setElement(handler.getPortDelegation(userId, null, null, portGUID, forLineage, forDuplicateProcessing, new Date(), "getPortDelegation"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPortDelegation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementsResponse getPortsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getPortsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortsByName");
        PortElementsResponse response = new PortElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortsByName");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortsByName");
            if (requestBody != null) {
                response.setElementList(handler.getPortsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), requestBody.getNameParameterName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getPortsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getPortsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPortsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PortElementResponse getPortByGUID(String serverName, String userId, String portGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getPortByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPortByGUID");
        PortElementResponse response = new PortElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPortByGUID");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getPortByGUID");
            if (requestBody != null) {
                response.setElement(handler.getPortByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), portGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getPortByGUID"));
            } else {
                response.setElement(handler.getPortByGUID(userId, null, null, portGUID, forLineage, forDuplicateProcessing, new Date(), "getPortByGUID"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPortByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setBusinessSignificant(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "setBusinessSignificant";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setBusinessSignificant");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setBusinessSignificant");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setBusinessSignificant");
            if (requestBody != null) {
                handler.setBusinessSignificant(userId, requestBody.getMetadataCorrelationProperties(), elementGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setBusinessSignificant");
            } else {
                handler.setBusinessSignificant(userId, null, elementGUID, forLineage, forDuplicateProcessing, new Date(), "setBusinessSignificant");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setBusinessSignificant", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearBusinessSignificant(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "clearBusinessSignificant";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearBusinessSignificant");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearBusinessSignificant");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearBusinessSignificant");
            if (requestBody != null) {
                handler.clearBusinessSignificant(userId, requestBody.getMetadataCorrelationProperties(), elementGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearBusinessSignificant");
            } else {
                handler.clearBusinessSignificant(userId, null, elementGUID, forLineage, forDuplicateProcessing, new Date(), "clearBusinessSignificant");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearBusinessSignificant", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupDataFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupDataFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupDataFlow");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof DataFlowProperties) {
                DataFlowProperties dataFlowProperties = (DataFlowProperties)relationshipProperties;
                response.setGUID(handler.setupDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, dataFlowProperties.getQualifiedName(), dataFlowProperties.getLabel(), dataFlowProperties.getDescription(), dataFlowProperties.getFormula(), dataFlowProperties.getEffectiveFrom(), dataFlowProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupDataFlow"));
            } else {
                response.setGUID(handler.setupDataFlow(userId, null, null, assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, null, null, null, null, null, null, forLineage, forDuplicateProcessing, new Date(), "setupDataFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementResponse getDataFlow(String serverName, String userId, String dataSupplierGUID, String dataConsumerGUID, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlow");
        DataFlowElementResponse response = new DataFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlow");
            if (requestBody != null) {
                response.setElement(handler.getDataFlow(userId, dataSupplierGUID, dataConsumerGUID, requestBody.getName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataFlow"));
            } else {
                response.setElement(handler.getDataFlow(userId, dataSupplierGUID, dataConsumerGUID, null, forLineage, forDuplicateProcessing, new Date(), "getDataFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataFlow(String serverName, String userId, String dataFlowGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataFlow");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof DataFlowProperties) {
                DataFlowProperties properties = (DataFlowProperties)relationshipProperties;
                ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateDataFlow");
                handler.updateDataFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFlowGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getFormula(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateDataFlow");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDataFlow(String serverName, String userId, String dataFlowGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearDataFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDataFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearDataFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearDataFlow");
            if (requestBody != null) {
                handler.clearDataFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), dataFlowGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearDataFlow");
            } else {
                handler.clearDataFlow(userId, null, null, dataFlowGUID, forLineage, forDuplicateProcessing, new Date(), "clearDataFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearDataFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowConsumers(String serverName, String userId, String dataSupplierGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getDataFlowConsumers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowConsumers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowConsumers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlowConsumers");
            if (requestBody != null) {
                response.setElements(handler.getDataFlowConsumers(userId, dataSupplierGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataFlowConsumers"));
            } else {
                response.setElements(handler.getDataFlowConsumers(userId, dataSupplierGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getDataFlowConsumers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlowConsumers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFlowElementsResponse getDataFlowSuppliers(String serverName, String userId, String dataConsumerGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getDataFlowSuppliers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFlowSuppliers");
        DataFlowElementsResponse response = new DataFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFlowSuppliers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDataFlowSuppliers");
            if (requestBody != null) {
                response.setElements(handler.getDataFlowSuppliers(userId, dataConsumerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataFlowSuppliers"));
            } else {
                response.setElements(handler.getDataFlowSuppliers(userId, dataConsumerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getDataFlowSuppliers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFlowSuppliers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupControlFlow");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupControlFlow");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof ControlFlowProperties) {
                ControlFlowProperties properties = (ControlFlowProperties)relationshipProperties;
                response.setGUID(handler.setupControlFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, currentStepGUID, nextStepGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getGuard(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupControlFlow"));
            } else {
                response.setGUID(handler.setupControlFlow(userId, null, null, assetManagerIsHome, currentStepGUID, nextStepGUID, null, null, null, null, null, null, forLineage, forDuplicateProcessing, new Date(), "setupControlFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementResponse getControlFlow(String serverName, String userId, String currentStepGUID, String nextStepGUID, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlow");
        ControlFlowElementResponse response = new ControlFlowElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlow");
            if (requestBody != null) {
                response.setElement(handler.getControlFlow(userId, currentStepGUID, nextStepGUID, requestBody.getName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getControlFlow"));
            } else {
                response.setElement(handler.getControlFlow(userId, currentStepGUID, nextStepGUID, null, forLineage, forDuplicateProcessing, new Date(), "getControlFlow"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateControlFlow(String serverName, String userId, String controlFlowGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateControlFlow");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof ControlFlowProperties) {
                ControlFlowProperties properties = (ControlFlowProperties)relationshipProperties;
                handler.updateControlFlow(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), controlFlowGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getGuard(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateControlFlow");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateControlFlow", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearControlFlow(String serverName, String userId, String controlFlowGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearControlFlow";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearControlFlow");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearControlFlow");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearControlFlow");
            if (requestBody != null) {
                handler.clearControlFlow(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), controlFlowGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearControlFlow");
            } else {
                handler.clearControlFlow(userId, null, null, controlFlowGUID, forLineage, forDuplicateProcessing, new Date(), "clearControlFlow");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearControlFlow", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowNextSteps(String serverName, String userId, String currentStepGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getControlFlowNextSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowNextSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowNextSteps");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlowNextSteps");
            if (requestBody != null) {
                response.setElements(handler.getControlFlowNextSteps(userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getControlFlowNextSteps"));
            } else {
                response.setElements(handler.getControlFlowNextSteps(userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getControlFlowNextSteps"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlowNextSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ControlFlowElementsResponse getControlFlowPreviousSteps(String serverName, String userId, String currentStepGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getControlFlowPreviousSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getControlFlowPreviousSteps");
        ControlFlowElementsResponse response = new ControlFlowElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getControlFlowPreviousSteps");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getControlFlowPreviousSteps");
            if (requestBody != null) {
                response.setElements(handler.getControlFlowPreviousSteps(userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getControlFlowPreviousSteps"));
            } else {
                response.setElements(handler.getControlFlowPreviousSteps(userId, currentStepGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getControlFlowPreviousSteps"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getControlFlowPreviousSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupProcessCall(String serverName, String userId, String callerGUID, String calledGUID, boolean assetManagerIsHome, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProcessCall");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupProcessCall");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof ProcessCallProperties) {
                ProcessCallProperties properties = (ProcessCallProperties)relationshipProperties;
                response.setGUID(handler.setupProcessCall(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, callerGUID, calledGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getFormula(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupProcessCall"));
            } else {
                response.setGUID(handler.setupProcessCall(userId, null, null, assetManagerIsHome, callerGUID, calledGUID, null, null, null, null, null, null, forLineage, forDuplicateProcessing, new Date(), "setupProcessCall"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementResponse getProcessCall(String serverName, String userId, String callerGUID, String calledGUID, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCall");
        ProcessCallElementResponse response = new ProcessCallElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCall");
            if (requestBody != null) {
                response.setElement(handler.getProcessCall(userId, callerGUID, calledGUID, requestBody.getName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessCall"));
            } else {
                response.setElement(handler.getProcessCall(userId, callerGUID, calledGUID, null, forLineage, forDuplicateProcessing, new Date(), "getProcessCall"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateProcessCall(String serverName, String userId, String processCallGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateProcessCall");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof ProcessCallProperties) {
                ProcessCallProperties properties = (ProcessCallProperties)relationshipProperties;
                handler.updateProcessCall(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), processCallGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getFormula(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateProcessCall");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateProcessCall", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProcessCall(String serverName, String userId, String processCallGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearProcessCall";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProcessCall");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProcessCall");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearProcessCall");
            if (requestBody != null) {
                handler.clearProcessCall(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), processCallGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearProcessCall");
            } else {
                handler.clearProcessCall(userId, null, null, processCallGUID, forLineage, forDuplicateProcessing, new Date(), "clearProcessCall");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearProcessCall", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCalled(String serverName, String userId, String callerGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getProcessCalled";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCalled");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCalled");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCalled");
            if (requestBody != null) {
                response.setElements(handler.getProcessCalled(userId, callerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessCalled"));
            } else {
                response.setElements(handler.getProcessCalled(userId, callerGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getProcessCalled"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCalled", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ProcessCallElementsResponse getProcessCallers(String serverName, String userId, String calledGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getProcessCallers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProcessCallers");
        ProcessCallElementsResponse response = new ProcessCallElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProcessCallers");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getProcessCallers");
            if (requestBody != null) {
                response.setElements(handler.getProcessCallers(userId, calledGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getProcessCallers"));
            } else {
                response.setElements(handler.getProcessCallers(userId, calledGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getProcessCallers"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getProcessCallers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupLineageMapping");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String guid;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "setupLineageMapping");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof DataFlowProperties) {
                    DataFlowProperties properties = (DataFlowProperties)relationshipProperties;
                    guid = handler.setupLineageMapping(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), sourceElementGUID, destinationElementGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupLineageMapping");
                } else {
                    guid = handler.setupLineageMapping(userId, null, null, sourceElementGUID, destinationElementGUID, null, null, null, null, null, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupLineageMapping");
                }
            } else {
                guid = handler.setupLineageMapping(userId, null, null, sourceElementGUID, destinationElementGUID, null, null, null, null, null, forLineage, forDuplicateProcessing, new Date(), "setupLineageMapping");
            }
            response.setGUID(guid);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementResponse getLineageMapping(String serverName, String userId, String sourceElementGUID, String destinationElementGUID, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLineageMapping");
        LineageMappingElementResponse response = new LineageMappingElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getLineageMapping");
            if (requestBody != null) {
                response.setElement(handler.getLineageMapping(userId, sourceElementGUID, destinationElementGUID, requestBody.getName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getLineageMapping"));
            } else {
                response.setElement(handler.getLineageMapping(userId, sourceElementGUID, destinationElementGUID, null, forLineage, forDuplicateProcessing, new Date(), "getLineageMapping"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateLineageMapping(String serverName, String userId, String lineageMappingGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            RelationshipProperties relationshipProperties;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "updateLineageMapping");
            if (requestBody != null && (relationshipProperties = requestBody.getProperties()) instanceof LineageMappingProperties) {
                LineageMappingProperties properties = (LineageMappingProperties)relationshipProperties;
                handler.updateLineageMapping(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), lineageMappingGUID, properties.getQualifiedName(), properties.getLabel(), properties.getDescription(), properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateLineageMapping");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateLineageMapping", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLineageMapping(String serverName, String userId, String lineageMappingGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearLineageMapping";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLineageMapping");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLineageMapping");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "clearLineageMapping");
            if (requestBody != null) {
                handler.clearLineageMapping(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), lineageMappingGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearLineageMapping");
            } else {
                handler.clearLineageMapping(userId, null, null, lineageMappingGUID, forLineage, forDuplicateProcessing, new Date(), "clearLineageMapping");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearLineageMapping", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getDestinationLineageMappings(String serverName, String userId, String sourceElementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getDestinationLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDestinationLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDestinationLineageMappings");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getDestinationLineageMappings");
            if (requestBody != null) {
                response.setElements(handler.getDestinationLineageMappings(userId, sourceElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDestinationLineageMappings"));
            } else {
                response.setElements(handler.getDestinationLineageMappings(userId, sourceElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getDestinationLineageMappings"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDestinationLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LineageMappingElementsResponse getSourceLineageMappings(String serverName, String userId, String destinationElementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSourceLineageMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSourceLineageMappings");
        LineageMappingElementsResponse response = new LineageMappingElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceLineageMappings");
            ProcessExchangeHandler handler = instanceHandler.getProcessExchangeHandler(userId, serverName, "getSourceLineageMappings");
            if (requestBody != null) {
                response.setElements(handler.getSourceLineageMappings(userId, destinationElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getSourceLineageMappings"));
            } else {
                response.setElements(handler.getSourceLineageMappings(userId, destinationElementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, new Date(), "getSourceLineageMappings"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSourceLineageMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

