/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ControlFlowProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ControlFlowConverter<B>
extends AssetManagerOMASConverter<B> {
    public ControlFlowConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ControlFlowElement) {
                ControlFlowElement bean = (ControlFlowElement)returnBean;
                ControlFlowProperties controlFlowProperties = new ControlFlowProperties();
                if (relationship != null) {
                    bean.setControlFlowHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                    EntityProxy entityProxy = relationship.getEntityOneProxy();
                    if (entityProxy != null) {
                        bean.setCurrentStep(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    if ((entityProxy = relationship.getEntityTwoProxy()) != null) {
                        bean.setNextStep(super.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName));
                    }
                    InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
                    controlFlowProperties.setQualifiedName(this.getISCQualifiedName(instanceProperties));
                    controlFlowProperties.setLabel(this.getLabel(instanceProperties));
                    controlFlowProperties.setDescription(this.getDescription(instanceProperties));
                    controlFlowProperties.setGuard(this.getGuard(instanceProperties));
                    bean.setControlFlowProperties(controlFlowProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

