/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.AssetManagerOMASConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalIdentifierConverter<B>
extends AssetManagerOMASConverter<B> {
    public ExternalIdentifierConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        ArrayList<Relationship> relationships = null;
        if (relationship != null) {
            relationships = new ArrayList<Relationship>();
            relationships.add(relationship);
        }
        return this.getNewComplexBean(beanClass, entity, relationships, methodName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof MetadataCorrelationHeader) {
                MetadataCorrelationHeader bean = (MetadataCorrelationHeader)returnBean;
                if (primaryEntity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    bean.setExternalIdentifier(this.removeIdentifier(instanceProperties));
                    bean.setExternalInstanceTypeName(this.removeIdentifierTypeName(instanceProperties));
                    bean.setKeyPattern(this.removeKeyPattern(instanceProperties));
                    bean.setExternalInstanceCreatedBy(this.removeExternalInstanceCreatedBy(instanceProperties));
                    bean.setExternalInstanceCreationTime(this.removeExternalInstanceCreationTime(instanceProperties));
                    bean.setExternalInstanceLastUpdatedBy(this.removeExternalInstanceLastUpdatedBy(instanceProperties));
                    bean.setExternalInstanceLastUpdateTime(this.removeExternalInstanceLastUpdateTime(instanceProperties));
                    bean.setExternalInstanceVersion(this.removeExternalInstanceVersion(instanceProperties));
                    if (relationships != null) {
                        for (Relationship relationship : relationships) {
                            if (relationship == null || relationship.getType() == null || relationship.getProperties() == null || relationship.getEntityOneProxy() == null) continue;
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName)) {
                                instanceProperties = new InstanceProperties(relationship.getProperties());
                                bean.setSynchronizationDirection(this.removePermittedSynchronization(instanceProperties));
                                bean.setSynchronizationDescription(this.removeDescription(instanceProperties));
                                bean.setExternalScopeGUID(relationship.getEntityOneProxy().getGUID());
                                bean.setExternalScopeTypeName(relationship.getEntityOneProxy().getType().getTypeDefName());
                                instanceProperties = new InstanceProperties(relationship.getEntityOneProxy().getUniqueProperties());
                                bean.setExternalScopeName(this.removeQualifiedName(instanceProperties));
                                continue;
                            }
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName)) continue;
                            instanceProperties = new InstanceProperties(relationship.getProperties());
                            bean.setExternalIdentifierName(this.removeDescription(instanceProperties));
                            bean.setExternalIdentifierUsage(this.removeUsage(instanceProperties));
                            bean.setExternalIdentifierSource(this.removeSource(instanceProperties));
                            bean.setMappingProperties(this.removeMappingProperties(instanceProperties));
                            bean.setLastSynchronized(this.removeLastSynchronized(instanceProperties));
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, primaryEntity, relationships, methodName);
    }
}

