/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ConnectionConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.ConnectorTypeConverter;
import org.odpi.openmetadata.accessservices.assetmanager.converters.EndpointConverter;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.SupplementaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionExchangeHandler
extends ExchangeHandlerBase {
    private final ConnectionHandler<ConnectionElement> connectionHandler;
    private final ConnectorTypeHandler<ConnectorTypeElement> connectorTypeHandler;
    private final EndpointHandler<EndpointElement> endpointHandler;
    private static final String connectionGUIDParameterName = "connectionGUID";
    private static final String connectorTypeGUIDParameterName = "connectorTypeGUID";
    private static final String endpointGUIDParameterName = "endpointGUID";
    private static final String searchStringParameterName = "searchString";
    private static final String nameParameterName = "name";
    private static final String entityParameterName = "entity";
    private static final String entityGUIDParameterName = "entity.getGUID()";

    public ConnectionExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler(new ConnectionConverter(repositoryHelper, serviceName, serverName), ConnectionElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler(new ConnectorTypeConverter(repositoryHelper, serviceName, serverName), ConnectorTypeElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.endpointHandler = new EndpointHandler(new EndpointConverter(repositoryHelper, serviceName, serverName), EndpointElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToConnections(String userId, String assetManagerGUID, String assetManagerName, List<ConnectionElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToConnectorTypes(String userId, String assetManagerGUID, String assetManagerName, List<ConnectorTypeElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToEndpoints(String userId, String assetManagerGUID, String assetManagerName, List<EndpointElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null && assetManagerGUID != null) {
            for (EndpointElement element : results) {
                if (element == null || element.getElementHeader() == null || element.getElementHeader().getGUID() == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, (SupplementaryProperties)element.getEndpointProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public String createConnection(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, ConnectionProperties connectionProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "connectionDetails";
        String qualifiedNameParameterName = "connectionDetails.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionDetails", methodName);
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionDetails.qualifiedName", methodName);
        String connectionGUID = this.connectionHandler.createConnection(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), null, null, connectionProperties.getQualifiedName(), connectionProperties.getDisplayName(), connectionProperties.getDescription(), connectionProperties.getAdditionalProperties(), connectionProperties.getSecuredProperties(), connectionProperties.getConfigurationProperties(), connectionProperties.getUserId(), connectionProperties.getClearPassword(), connectionProperties.getEncryptedPassword(), connectionProperties.getTypeName(), connectionProperties.getExtendedProperties(), null, null, null, null, connectionProperties.getEffectiveFrom(), connectionProperties.getEffectiveTo(), false, false, this.connectionHandler.getSupportedZones(), null, methodName);
        if (connectionGUID != null) {
            this.createExternalIdentifier(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.PROCESS.typeName, correlationProperties, false, false, null, methodName);
        }
        return connectionGUID;
    }

    public String createConnectionFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String connectionGUID = this.connectionHandler.createConnectionFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, "templateGUID", templateProperties.getQualifiedName(), "templateProperties.qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (connectionGUID != null) {
            this.createExternalIdentifier(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.PROCESS.typeName, correlationProperties, false, false, null, methodName);
        }
        return connectionGUID;
    }

    public void updateConnection(String userId, MetadataCorrelationProperties correlationProperties, String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String propertiesParameterName = "connectionDetails";
        String qualifiedNameParameterName = "connectionDetails.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionDetails", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionDetails.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.connectionHandler.updateConnection(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), connectionGUID, connectionGUIDParameterName, connectionProperties.getQualifiedName(), connectionProperties.getDisplayName(), connectionProperties.getDescription(), connectionProperties.getAdditionalProperties(), connectionProperties.getSecuredProperties(), connectionProperties.getConfigurationProperties(), connectionProperties.getUserId(), connectionProperties.getClearPassword(), connectionProperties.getEncryptedPassword(), connectionProperties.getTypeName(), connectionProperties.getExtendedProperties(), isMergeUpdate, connectionProperties.getEffectiveFrom(), connectionProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupConnectorType(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String connectorTypeGUID, RelationshipProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String connectorTypeGUIDParameterName = connectorTypeGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, connectorTypeGUIDParameterName, methodName);
        if (properties != null) {
            this.connectionHandler.addConnectionConnectorType(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, connectorTypeGUID, connectorTypeGUIDParameterName, properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.connectionHandler.addConnectionConnectorType(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, connectorTypeGUID, connectorTypeGUIDParameterName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearConnectorType(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String connectorTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String connectorTypeGUIDParameterName = connectorTypeGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, connectorTypeGUIDParameterName, methodName);
        this.connectionHandler.removeConnectionConnectorType(userId, assetManagerGUID, assetManagerName, connectionGUID, connectionGUIDParameterName, connectorTypeGUID, connectorTypeGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupEndpoint(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String endpointGUID, RelationshipProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String endpointGUIDParameterName = endpointGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(endpointGUID, endpointGUIDParameterName, methodName);
        if (properties != null) {
            this.connectionHandler.addConnectionEndpoint(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, endpointGUID, endpointGUIDParameterName, properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.connectionHandler.addConnectionEndpoint(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, endpointGUID, endpointGUIDParameterName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearEndpoint(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String endpointGUIDParameterName = endpointGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(endpointGUID, endpointGUIDParameterName, methodName);
        this.connectionHandler.removeConnectionEndpoint(userId, assetManagerGUID, assetManagerName, connectionGUID, connectionGUIDParameterName, endpointGUID, endpointGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", methodName);
        if (properties != null) {
            this.connectionHandler.addEmbeddedConnection(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, properties.getPosition(), properties.getDisplayName(), properties.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, this.connectionHandler.getSupportedZones(), effectiveTime, methodName);
        } else {
            this.connectionHandler.addEmbeddedConnection(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, 0, null, null, embeddedConnectionGUID, "embeddedConnectionGUID", null, null, forLineage, forDuplicateProcessing, this.connectionHandler.getSupportedZones(), effectiveTime, methodName);
        }
    }

    public void clearEmbeddedConnection(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, String embeddedConnectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", methodName);
        this.connectionHandler.removeEmbeddedConnection(userId, assetManagerGUID, assetManagerName, connectionGUID, connectionGUIDParameterName, embeddedConnectionGUID, "embeddedConnectionGUID", forLineage, forDuplicateProcessing, this.connectionHandler.getSupportedZones(), effectiveTime, methodName);
    }

    public void setupAssetConnection(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String assetGUID, String connectionGUID, AssetConnectionProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = connectionGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        if (properties != null) {
            this.connectionHandler.addConnectionToAsset(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, assetGUID, "assetGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.connectionHandler.addConnectionToAsset(userId, this.getExternalSourceGUID(assetManagerGUID, assetManagerIsHome), this.getExternalSourceName(assetManagerName, assetManagerIsHome), connectionGUID, connectionGUIDParameterName, assetGUID, "assetGUID", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearAssetConnection(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String connectionGUIDParameterName = connectionGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.connectionHandler.removeConnectionToAsset(userId, assetManagerGUID, assetManagerName, connectionGUID, connectionGUIDParameterName, assetGUID, "assetGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeConnection(String userId, MetadataCorrelationProperties correlationProperties, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectionGUIDParameterName = connectionGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.connectionHandler.removeConnection(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), connectionGUID, connectionGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ConnectionElement> findConnections(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.connectionHandler.findConnections(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToConnections(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ConnectionElement> getConnectionsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.connectionHandler.getConnectionsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToConnections(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ConnectionElement> getConnectionsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ConnectionElement> results = new ArrayList<ConnectionElement>();
        List entities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.CONNECTION.typeName, startFrom, validatedPageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (entities != null) {
            for (EntityDetail entity : entities) {
                ConnectionElement element;
                if (entity == null || (element = (ConnectionElement)this.connectionHandler.getBeanFromEntity(userId, entity, entityParameterName, methodName)) == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, entity.getGUID(), entityGUIDParameterName, OpenMetadataType.CONNECTION.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                results.add(element);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public ConnectionElement getConnectionByGUID(String userId, String assetManagerGUID, String assetManagerName, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = connectionGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectionGUID, connectionGUIDParameterName, methodName);
        ConnectionElement element = (ConnectionElement)this.connectionHandler.getConnectionByGUID(userId, connectionGUID, connectionGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return element;
    }

    public String createEndpoint(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, EndpointProperties endpointProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", methodName);
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", methodName);
        String endpointGUID = this.endpointHandler.createEndpoint(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), null, endpointProperties.getQualifiedName(), endpointProperties.getName(), endpointProperties.getResourceDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), endpointProperties.getEffectiveFrom(), endpointProperties.getEffectiveTo(), null, methodName);
        if (endpointGUID != null) {
            this.maintainSupplementaryProperties(userId, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.ENDPOINT.typeName, endpointProperties.getQualifiedName(), (SupplementaryProperties)endpointProperties, true, false, false, null, methodName);
            this.createExternalIdentifier(userId, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, correlationProperties, false, false, null, methodName);
        }
        return endpointGUID;
    }

    public String createEndpointFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String endpointGUID = this.endpointHandler.createEndpointFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), templateProperties.getNetworkAddress(), methodName);
        if (endpointGUID != null) {
            this.createExternalIdentifier(userId, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, correlationProperties, false, false, null, methodName);
        }
        return endpointGUID;
    }

    public void updateEndpoint(String userId, MetadataCorrelationProperties correlationProperties, String endpointGUID, boolean isMergeUpdate, EndpointProperties endpointProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUIDParameterName = endpointGUIDParameterName;
        String propertiesParameterName = "endpointProperties";
        String qualifiedNameParameterName = "endpointProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(endpointGUID, endpointGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", methodName);
        }
        this.endpointHandler.updateEndpoint(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), endpointGUID, endpointGUIDParameterName, endpointProperties.getQualifiedName(), endpointProperties.getName(), endpointProperties.getResourceDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), isMergeUpdate, endpointProperties.getEffectiveFrom(), endpointProperties.getEffectiveTo(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.maintainSupplementaryProperties(userId, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.ENDPOINT.typeName, endpointProperties.getQualifiedName(), (SupplementaryProperties)endpointProperties, isMergeUpdate, false, false, null, methodName);
    }

    public void removeEndpoint(String userId, MetadataCorrelationProperties correlationProperties, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectorTypeGUIDParameterName = endpointGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(endpointGUID, endpointGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.endpointHandler.removeEndpoint(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), endpointGUID, endpointGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<EndpointElement> findEndpoints(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.endpointHandler.findEndpoints(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToEndpoints(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<EndpointElement> getEndpointsByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.endpointHandler.getEndpointsByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToEndpoints(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<EndpointElement> getEndpointsForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<EndpointElement> results = new ArrayList<EndpointElement>();
        List entities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.ENDPOINT.typeName, startFrom, validatedPageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (entities != null) {
            for (EntityDetail entity : entities) {
                EndpointElement element;
                if (entity == null || (element = (EndpointElement)this.endpointHandler.getBeanFromEntity(userId, entity, entityParameterName, methodName)) == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, entity.getGUID(), entityGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                this.getSupplementaryProperties(element.getElementHeader().getGUID(), endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, (SupplementaryProperties)element.getEndpointProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(element);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public EndpointElement getEndpointByGUID(String userId, String assetManagerGUID, String assetManagerName, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EndpointElement element = (EndpointElement)this.endpointHandler.getEndpointByGUID(userId, endpointGUID, endpointGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), entityGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            this.getSupplementaryProperties(element.getElementHeader().getGUID(), endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, (SupplementaryProperties)element.getEndpointProperties(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return element;
    }

    public String createConnectorType(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, ConnectorTypeProperties connectorTypeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "connectorTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", methodName);
        this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "connectorTypeProperties.qualifiedName", methodName);
        String connectorTypeGUID = this.connectorTypeHandler.createConnectorType(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), null, connectorTypeProperties.getQualifiedName(), connectorTypeProperties.getDisplayName(), connectorTypeProperties.getDescription(), connectorTypeProperties.getSupportedAssetTypeName(), null, connectorTypeProperties.getExpectedDataFormat(), connectorTypeProperties.getConnectorProviderClassName(), connectorTypeProperties.getConnectorFrameworkName(), connectorTypeProperties.getConnectorInterfaceLanguage(), connectorTypeProperties.getConnectorInterfaces(), connectorTypeProperties.getTargetTechnologySource(), connectorTypeProperties.getTargetTechnologyName(), connectorTypeProperties.getTargetTechnologyInterfaces(), connectorTypeProperties.getTargetTechnologyVersions(), connectorTypeProperties.getRecognizedAdditionalProperties(), connectorTypeProperties.getRecognizedSecuredProperties(), connectorTypeProperties.getRecognizedConfigurationProperties(), connectorTypeProperties.getAdditionalProperties(), connectorTypeProperties.getTypeName(), connectorTypeProperties.getExtendedProperties(), connectorTypeProperties.getEffectiveFrom(), connectorTypeProperties.getEffectiveTo(), null, methodName);
        if (connectorTypeGUID != null) {
            this.createExternalIdentifier(userId, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, correlationProperties, false, false, null, methodName);
        }
        return connectorTypeGUID;
    }

    public String createConnectorTypeFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", methodName);
        String connectorTypeGUID = this.connectorTypeHandler.createConnectorTypeFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), methodName);
        if (connectorTypeGUID != null) {
            this.createExternalIdentifier(userId, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, correlationProperties, false, false, null, methodName);
        }
        return connectorTypeGUID;
    }

    public void updateConnectorType(String userId, MetadataCorrelationProperties correlationProperties, String connectorTypeGUID, boolean isMergeUpdate, ConnectorTypeProperties connectorTypeProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String connectorTypeGUIDParameterName = connectorTypeGUIDParameterName;
        String propertiesParameterName = "connectorTypeProperties";
        String qualifiedNameParameterName = "connectorTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, connectorTypeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "connectorTypeProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.connectorTypeHandler.updateConnectorType(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), connectorTypeGUID, connectorTypeGUIDParameterName, connectorTypeProperties.getQualifiedName(), connectorTypeProperties.getDisplayName(), connectorTypeProperties.getDescription(), connectorTypeProperties.getSupportedAssetTypeName(), null, connectorTypeProperties.getExpectedDataFormat(), connectorTypeProperties.getConnectorProviderClassName(), connectorTypeProperties.getConnectorFrameworkName(), connectorTypeProperties.getConnectorInterfaceLanguage(), connectorTypeProperties.getConnectorInterfaces(), connectorTypeProperties.getTargetTechnologySource(), connectorTypeProperties.getTargetTechnologyName(), connectorTypeProperties.getTargetTechnologyInterfaces(), connectorTypeProperties.getTargetTechnologyVersions(), connectorTypeProperties.getRecognizedAdditionalProperties(), connectorTypeProperties.getRecognizedSecuredProperties(), connectorTypeProperties.getRecognizedConfigurationProperties(), connectorTypeProperties.getAdditionalProperties(), connectorTypeProperties.getTypeName(), connectorTypeProperties.getExtendedProperties(), connectorTypeProperties.getEffectiveFrom(), connectorTypeProperties.getEffectiveTo(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeConnectorType(String userId, MetadataCorrelationProperties correlationProperties, String connectorTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, connectorTypeGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.connectorTypeHandler.removeConnectorType(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), connectorTypeGUID, connectorTypeGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String userId, String assetManagerGUID, String assetManagerName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.connectorTypeHandler.findConnectorTypes(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToConnectorTypes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String assetManagerGUID, String assetManagerName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.connectorTypeHandler.getConnectorTypesByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToConnectorTypes(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<ConnectorTypeElement> getConnectorTypesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ConnectorTypeElement> results = new ArrayList<ConnectorTypeElement>();
        List entities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.CONNECTOR_TYPE.typeName, startFrom, validatedPageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (entities != null) {
            for (EntityDetail entity : entities) {
                ConnectorTypeElement element;
                if (entity == null || (element = (ConnectorTypeElement)this.connectorTypeHandler.getBeanFromEntity(userId, entity, entityParameterName, methodName)) == null) continue;
                element.setCorrelationHeaders(this.getCorrelationProperties(userId, entity.getGUID(), entityGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                results.add(element);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(openMetadataGUID, "openMetadataGUID", methodName);
        ConnectorTypeElement element = (ConnectorTypeElement)this.connectorTypeHandler.getConnectorTypeByGUID(userId, openMetadataGUID, "openMetadataGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (element != null) {
            element.setCorrelationHeaders(this.getCorrelationProperties(userId, element.getElementHeader().getGUID(), connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return element;
    }
}

