/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.ExchangeHandlerBase;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryConverter;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryConverter;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermConverter;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.CanonicalVocabularyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.EditingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermContextDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.StagingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.TaxonomyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryExchangeHandler
extends ExchangeHandlerBase {
    private final GlossaryHandler<GlossaryElement> glossaryHandler;
    private final GlossaryCategoryHandler<GlossaryCategoryElement> glossaryCategoryHandler;
    private final GlossaryTermHandler<GlossaryTermElement> glossaryTermHandler;
    private static final String glossaryGUIDParameterName = "glossaryGUID";
    private static final String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
    private static final String glossaryTermGUIDParameterName = "glossaryTermGUID";

    public GlossaryExchangeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryHandler = new GlossaryHandler((OpenMetadataAPIGenericConverter)new GlossaryConverter(repositoryHelper, serviceName, serverName), GlossaryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryCategoryHandler = new GlossaryCategoryHandler((OpenMetadataAPIGenericConverter)new GlossaryCategoryConverter(repositoryHelper, serviceName, serverName), GlossaryCategoryElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.glossaryTermHandler = new GlossaryTermHandler((OpenMetadataAPIGenericConverter)new GlossaryTermConverter(repositoryHelper, serviceName, serverName), GlossaryTermElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private void addCorrelationPropertiesToGlossaries(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryElement> results, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, assetManagerGUID, assetManagerName, false, false, null, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryCategoryElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    private void addCorrelationPropertiesToGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, List<GlossaryTermElement> results, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (results != null) {
            for (CorrelatedMetadataElement correlatedMetadataElement : results) {
                if (correlatedMetadataElement == null || correlatedMetadataElement.getElementHeader() == null || correlatedMetadataElement.getElementHeader().getGUID() == null) continue;
                correlatedMetadataElement.setCorrelationHeaders(this.getCorrelationProperties(userId, correlatedMetadataElement.getElementHeader().getGUID(), glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
    }

    public String createGlossary(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, GlossaryProperties glossaryProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossary(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, false, false, null, methodName);
        }
        return glossaryGUID;
    }

    public String createGlossaryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String templateGUID, TemplateProperties templateProperties, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryGUID = this.glossaryHandler.createGlossaryFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), deepCopy, methodName);
        if (glossaryGUID != null) {
            this.createExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, false, false, null, methodName);
        }
        return glossaryGUID;
    }

    public void updateGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, GlossaryProperties glossaryProperties, String updateDescription, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryProperties";
        String qualifiedNameParameterName = "glossaryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryProperties, "glossaryProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(glossaryProperties.getQualifiedName(), "glossaryProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.updateGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, glossaryProperties.getQualifiedName(), glossaryProperties.getDisplayName(), glossaryProperties.getDescription(), glossaryProperties.getLanguage(), glossaryProperties.getUsage(), glossaryProperties.getAdditionalProperties(), glossaryProperties.getTypeName(), glossaryProperties.getExtendedProperties(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String revisionHistoryTitle = "Glossary properties updated by " + userId + " on " + String.valueOf(new Date());
        this.updateRevisionHistory(userId, glossaryGUID, glossaryProperties.getQualifiedName(), OpenMetadataType.GLOSSARY.typeName, revisionHistoryTitle, updateDescription);
    }

    public void removeGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.removeGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setGlossaryAsEditingGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, EditingGlossaryProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (properties != null) {
            this.glossaryHandler.addEditingGlossaryClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, properties.getDescription(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryHandler.addEditingGlossaryClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearGlossaryAsEditingGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.removeEditingGlossaryClassificationFromGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setGlossaryAsStagingGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, StagingGlossaryProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (properties != null) {
            this.glossaryHandler.addStagingGlossaryClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, properties.getDescription(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryHandler.addStagingGlossaryClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearGlossaryAsStagingGlossary(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.removeStagingGlossaryClassificationFromGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, TaxonomyProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (properties != null) {
            this.glossaryHandler.addTaxonomyClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, properties.getOrganizingPrinciple(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryHandler.addTaxonomyClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearGlossaryAsTaxonomy(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.removeTaxonomyClassificationFromGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, CanonicalVocabularyProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (properties != null) {
            this.glossaryHandler.addCanonicalVocabClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, properties.getScope(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryHandler.addCanonicalVocabClassificationToGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearGlossaryAsCanonical(String userId, MetadataCorrelationProperties correlationProperties, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryHandler.removeCanonicalVocabClassificationFromGlossary(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryGUID, glossaryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<GlossaryElement> findGlossaries(String userId, String assetManagerGUID, String assetManagerName, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.findGlossaries(userId, searchString, searchStringParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesByName(String userId, String assetManagerGUID, String assetManagerName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryHandler.getGlossariesByName(userId, name, nameParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaries(userId, assetManagerGUID, assetManagerName, results, methodName);
        return results;
    }

    public List<GlossaryElement> getGlossariesForAssetManager(String userId, String assetManagerGUID, String assetManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetManagerGUIDParameterName = "assetManagerGUID";
        String glossaryEntityParameterName = "glossaryEntity";
        String glossaryGUIDParameterName = "glossaryEntity.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetManagerGUID, "assetManagerGUID", methodName);
        ArrayList<GlossaryElement> results = new ArrayList<GlossaryElement>();
        List glossaryEntities = this.externalIdentifierHandler.getElementEntitiesForScope(userId, assetManagerGUID, "assetManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, OpenMetadataType.GLOSSARY.typeName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (glossaryEntities != null) {
            for (EntityDetail glossaryEntity : glossaryEntities) {
                GlossaryElement glossaryElement;
                if (glossaryEntity == null || (glossaryElement = (GlossaryElement)this.glossaryHandler.getBeanFromEntity(userId, glossaryEntity, "glossaryEntity", methodName)) == null) continue;
                glossaryElement.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryEntity.getGUID(), "glossaryEntity.getGUID()", OpenMetadataType.GLOSSARY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                results.add(glossaryElement);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public GlossaryElement getGlossaryByGUID(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = glossaryGUIDParameterName;
        GlossaryElement glossary = (GlossaryElement)this.glossaryHandler.getGlossaryByGUID(userId, glossaryGUID, glossaryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossary != null) {
            glossary.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossary;
    }

    public GlossaryElement getGlossaryForCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = glossaryCategoryGUIDParameterName;
        GlossaryElement glossary = (GlossaryElement)this.glossaryHandler.getGlossaryForCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossary != null) {
            String glossaryGUIDParameterName = "glossary.getElementHeader().getGUID()";
            glossary.setCorrelationHeaders(this.getCorrelationProperties(userId, glossary.getElementHeader().getGUID(), "glossary.getElementHeader().getGUID()", OpenMetadataType.GLOSSARY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossary;
    }

    public GlossaryElement getGlossaryForTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = glossaryTermGUIDParameterName;
        GlossaryElement glossary = (GlossaryElement)this.glossaryHandler.getGlossaryForTerm(userId, glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossary != null) {
            String glossaryGUIDParameterName = "glossary.getElementHeader().getGUID()";
            glossary.setCorrelationHeaders(this.getCorrelationProperties(userId, glossary.getElementHeader().getGUID(), "glossary.getElementHeader().getGUID()", OpenMetadataType.GLOSSARY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossary;
    }

    public String createGlossaryCategory(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, GlossaryCategoryProperties glossaryCategoryProperties, boolean isRootCategory, String updateDescription, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategory(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryGUID, glossaryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), isRootCategory, glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), glossaryCategoryProperties.getEffectiveFrom(), glossaryCategoryProperties.getEffectiveTo(), effectiveTime, methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String revisionHistoryTitle = "Glossary category created by " + userId + " on " + String.valueOf(new Date());
            this.updateRevisionHistory(userId, glossaryCategoryGUID, glossaryCategoryProperties.getQualifiedName(), OpenMetadataType.GLOSSARY_CATEGORY.typeName, revisionHistoryTitle, updateDescription);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String glossaryGUID, String templateGUID, TemplateProperties templateProperties, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryGUIDParameterName = glossaryGUIDParameterName;
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryCategoryGUID = this.glossaryCategoryHandler.createGlossaryCategoryFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryGUID, glossaryGUIDParameterName, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), deepCopy, methodName);
        if (glossaryCategoryGUID != null) {
            this.createExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, correlationProperties, false, false, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public void updateGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, GlossaryCategoryProperties glossaryCategoryProperties, String updateDescription, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryCategoryProperties";
        String qualifiedNameParameterName = "glossaryCategoryProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryCategoryProperties, "glossaryCategoryProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(glossaryCategoryProperties.getQualifiedName(), "glossaryCategoryProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryCategoryHandler.updateGlossaryCategory(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryCategoryGUID, glossaryCategoryGUIDParameterName, glossaryCategoryProperties.getQualifiedName(), glossaryCategoryProperties.getDisplayName(), glossaryCategoryProperties.getDescription(), glossaryCategoryProperties.getAdditionalProperties(), glossaryCategoryProperties.getTypeName(), glossaryCategoryProperties.getExtendedProperties(), glossaryCategoryProperties.getEffectiveFrom(), glossaryCategoryProperties.getEffectiveTo(), effectiveTime, isMergeUpdate, forLineage, forDuplicateProcessing, methodName);
        String revisionHistoryTitle = "Glossary category updated by " + userId + " on " + String.valueOf(new Date());
        this.updateRevisionHistory(userId, glossaryCategoryGUID, glossaryCategoryProperties.getQualifiedName(), OpenMetadataType.GLOSSARY_CATEGORY.typeName, revisionHistoryTitle, updateDescription);
    }

    public void removeGlossaryCategory(String userId, MetadataCorrelationProperties correlationProperties, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validateExternalIdentifier(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryCategoryHandler.removeGlossaryCategory(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryCategoryGUID, glossaryCategoryGUIDParameterName, effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.findGlossaryCategories(userId, glossaryGUID, searchString, searchStringParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getCategoriesForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getCategoriesForTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getCategoriesForTerm(userId, glossaryTermGUID, glossaryTermGUIDParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossaryCategoriesByName(userId, glossaryGUID, name, nameParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryCategory;
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryCategoryHandler.getGlossarySubCategories(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, startFrom, pageSize, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        this.addCorrelationPropertiesToGlossaryCategories(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String userId, String assetManagerGUID, String assetManagerName, String openMetadataGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "openMetadataGUID";
        GlossaryCategoryElement glossaryCategory = (GlossaryCategoryElement)this.glossaryCategoryHandler.getGlossaryCategoryByGUID(userId, openMetadataGUID, "openMetadataGUID", effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (glossaryCategory != null) {
            glossaryCategory.setCorrelationHeaders(this.getCorrelationProperties(userId, openMetadataGUID, "openMetadataGUID", OpenMetadataType.GLOSSARY_CATEGORY.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryCategory;
    }

    public String createGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, GlossaryTermProperties glossaryTermProperties, String updateDescription, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getAliases(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getPublishVersionIdentifier(), glossaryTermProperties.getAdditionalProperties(), glossaryTermProperties.getTypeName(), glossaryTermProperties.getExtendedProperties(), InstanceStatus.ACTIVE, glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), effectiveTime, methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String revisionHistoryTitle = "Glossary term created by " + userId + " on " + String.valueOf(new Date());
            this.updateRevisionHistory(userId, glossaryTermGUID, glossaryTermProperties.getQualifiedName(), OpenMetadataType.GLOSSARY_TERM.typeName, revisionHistoryTitle, updateDescription);
        }
        return glossaryTermGUID;
    }

    private InstanceStatus getInstanceStatus(GlossaryTermStatus status) {
        if (status != null) {
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case GlossaryTermStatus.DRAFT -> InstanceStatus.DRAFT;
                case GlossaryTermStatus.PREPARED -> InstanceStatus.PREPARED;
                case GlossaryTermStatus.PROPOSED -> InstanceStatus.PROPOSED;
                case GlossaryTermStatus.APPROVED -> InstanceStatus.APPROVED;
                case GlossaryTermStatus.REJECTED -> InstanceStatus.REJECTED;
                case GlossaryTermStatus.ACTIVE -> InstanceStatus.ACTIVE;
                case GlossaryTermStatus.DEPRECATED -> InstanceStatus.DEPRECATED;
                case GlossaryTermStatus.OTHER -> InstanceStatus.OTHER;
            };
        }
        return null;
    }

    public String createControlledGlossaryTerm(String userId, String glossaryGUID, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, String updateDescription, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermGUID;
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        String initialStatusParameterName = "initialStatus";
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        this.invalidParameterHandler.validateObject((Object)initialStatus, "initialStatus", methodName);
        this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        String typeName = OpenMetadataType.CONTROLLED_GLOSSARY_TERM.typeName;
        if (glossaryTermProperties.getTypeName() != null) {
            typeName = glossaryTermProperties.getTypeName();
        }
        if ((glossaryTermGUID = this.glossaryTermHandler.createGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryGUID, glossaryGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getAliases(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getPublishVersionIdentifier(), glossaryTermProperties.getAdditionalProperties(), typeName, glossaryTermProperties.getExtendedProperties(), this.getInstanceStatus(initialStatus), glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), effectiveTime, methodName)) != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String revisionHistoryTitle = "Glossary term created by " + userId + " on " + String.valueOf(new Date());
            this.updateRevisionHistory(userId, glossaryTermGUID, glossaryTermProperties.getQualifiedName(), OpenMetadataType.CONTROLLED_GLOSSARY_TERM.typeName, revisionHistoryTitle, updateDescription);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, boolean assetManagerIsHome, String glossaryGUID, String templateGUID, TemplateProperties templateProperties, GlossaryTermStatus initialStatus, boolean deepCopy, boolean templateSubstitute, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        String glossaryTermGUID = this.glossaryTermHandler.createGlossaryTermFromTemplate(userId, this.getExternalSourceGUID(correlationProperties, assetManagerIsHome), this.getExternalSourceName(correlationProperties, assetManagerIsHome), glossaryGUID, glossaryGUIDParameterName, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getAliases(), templateProperties.getDescription(), templateProperties.getVersionIdentifier(), this.getInstanceStatus(initialStatus), deepCopy, templateSubstitute, methodName);
        if (glossaryTermGUID != null) {
            this.createExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, false, false, null, methodName);
        }
        return glossaryTermGUID;
    }

    public void updateGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermProperties glossaryTermProperties, String updateDescription, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "glossaryTermProperties";
        String qualifiedNameParameterName = "glossaryTermProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermProperties, "glossaryTermProperties", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(glossaryTermProperties.getQualifiedName(), "glossaryTermProperties.qualifiedName", methodName);
        }
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.updateGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, glossaryTermProperties.getQualifiedName(), glossaryTermProperties.getDisplayName(), glossaryTermProperties.getAliases(), glossaryTermProperties.getSummary(), glossaryTermProperties.getDescription(), glossaryTermProperties.getExamples(), glossaryTermProperties.getAbbreviation(), glossaryTermProperties.getUsage(), glossaryTermProperties.getPublishVersionIdentifier(), glossaryTermProperties.getAdditionalProperties(), OpenMetadataType.GLOSSARY_TERM.typeName, glossaryTermProperties.getExtendedProperties(), glossaryTermProperties.getEffectiveFrom(), glossaryTermProperties.getEffectiveTo(), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String revisionHistoryTitle = "Glossary term updated by " + userId + " on " + String.valueOf(new Date());
        this.updateRevisionHistory(userId, glossaryTermGUID, glossaryTermProperties.getQualifiedName(), OpenMetadataType.GLOSSARY_TERM.typeName, revisionHistoryTitle, updateDescription);
    }

    public void updateGlossaryTermStatus(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermStatus glossaryTermStatus, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryTermStatusParameterName = "glossaryTermStatus";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)glossaryTermStatus, "glossaryTermStatus", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.updateGlossaryTermStatus(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, this.getInstanceStatus(glossaryTermStatus), "glossaryTermStatus", effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    public void updateGlossaryTermFromTemplate(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String templateGUID, String updateDescription, boolean isMergeClassifications, boolean isMergeProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail termEntity = this.glossaryTermHandler.updateGlossaryTermFromTemplate(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, templateGUID, "templateGUID", isMergeClassifications, isMergeProperties, effectiveTime, forLineage, forDuplicateProcessing, methodName);
        if (termEntity != null) {
            String revisionHistoryTitle = "Glossary term updated by " + userId + " on " + String.valueOf(new Date()) + " from template " + templateGUID;
            this.updateRevisionHistory(userId, glossaryTermGUID, this.glossaryTermHandler.getRepositoryHelper().getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, termEntity.getProperties(), methodName), OpenMetadataType.GLOSSARY_TERM.typeName, revisionHistoryTitle, updateDescription);
        }
    }

    public void moveGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, String newGlossaryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String newGlossaryGUIDParameterName = "newGlossaryGUID";
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(newGlossaryGUID, "newGlossaryGUID", methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.moveGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, newGlossaryGUID, "newGlossaryGUID", effectiveTime, forLineage, forDuplicateProcessing, methodName);
    }

    public List<String> getTermRelationshipTypeNames() {
        return this.glossaryTermHandler.getTermRelationshipTypeNames();
    }

    public void setTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsAbstractConcept(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsAbstractConcept(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsDataValue(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsDataValue(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsDataValue(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private int getActivityType(GlossaryTermActivityType activityType) {
        if (activityType != null) {
            return activityType.getOrdinal();
        }
        return GlossaryTermActivityType.ACTION.getOrdinal();
    }

    public void setTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermActivityType activityType, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsActivity(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, this.getActivityType(activityType), null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsActivity(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsActivity(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, GlossaryTermContextDefinition contextDefinition, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (contextDefinition != null) {
            this.glossaryTermHandler.setTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, contextDefinition.getDescription(), contextDefinition.getScope(), null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.setTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void clearTermAsContext(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsContext(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsSpineObject(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineObject(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsSpineObject(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsSpineAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsSpineAttribute(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.setTermAsObjectIdentifier(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.clearTermAsObjectIdentifier(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public GlossaryTermElement undoGlossaryTermUpdate(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryTermElement glossaryTerm = (GlossaryTermElement)this.glossaryTermHandler.undoBeanUpdateInRepository(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryTerm != null) {
            glossaryTerm.setCorrelationHeaders(this.getCorrelationProperties(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryTerm;
    }

    public void archiveGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, ArchiveProperties archiveProperties, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, true, forDuplicateProcessing, effectiveTime, methodName);
        if (archiveProperties == null) {
            this.glossaryTermHandler.archiveGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, null, null, null, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.glossaryTermHandler.archiveGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, archiveProperties.getArchiveDate(), archiveProperties.getArchiveProcess(), archiveProperties.getArchiveProperties(), forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void removeGlossaryTerm(String userId, MetadataCorrelationProperties correlationProperties, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.validateExternalIdentifier(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, correlationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.glossaryTermHandler.removeGlossaryTerm(userId, this.getExternalSourceGUID(correlationProperties), this.getExternalSourceName(correlationProperties), glossaryTermGUID, glossaryTermGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String searchString, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.findTerms(userId, glossaryGUID, searchString, this.getInstanceStatuses(limitResultsByStatus), startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    private List<InstanceStatus> getInstanceStatuses(List<GlossaryTermStatus> glossaryTermStatuses) {
        if (glossaryTermStatuses != null) {
            ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>();
            for (GlossaryTermStatus glossaryTermStatus : glossaryTermStatuses) {
                instanceStatuses.add(this.getInstanceStatus(glossaryTermStatus));
            }
            if (!instanceStatuses.isEmpty()) {
                return instanceStatuses;
            }
        }
        return null;
    }

    private List<Integer> getEnumOrdinals(List<GlossaryTermRelationshipStatus> glossaryTermRelationshipStatuses) {
        if (glossaryTermRelationshipStatuses != null) {
            ArrayList<Integer> ordinals = new ArrayList<Integer>();
            for (GlossaryTermRelationshipStatus status : glossaryTermRelationshipStatuses) {
                if (status == null) continue;
                ordinals.add(status.getOrdinal());
            }
            if (!ordinals.isEmpty()) {
                return ordinals;
            }
        }
        return null;
    }

    public List<GlossaryTermElement> getTermsForGlossary(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossary(userId, glossaryGUID, glossaryGUIDParameterName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String userId, String assetManagerGUID, String assetManagerName, String glossaryCategoryGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, this.getEnumOrdinals(limitResultsByStatus), startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getRelatedTerms(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String relationshipTypeName, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getRelatedTerms(userId, glossaryTermGUID, glossaryTermGUIDParameterName, relationshipTypeName, this.getEnumOrdinals(limitResultsByStatus), startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String userId, String assetManagerGUID, String assetManagerName, String glossaryGUID, String name, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.glossaryTermHandler.getTermsByName(userId, glossaryGUID, name, this.getInstanceStatuses(limitResultsByStatus), startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public GlossaryTermElement getGlossaryTermByGUID(String userId, String assetManagerGUID, String assetManagerName, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        GlossaryTermElement glossaryTerm = (GlossaryTermElement)this.glossaryTermHandler.getTerm(userId, guid, "guid", forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryTerm != null) {
            glossaryTerm.setCorrelationHeaders(this.getCorrelationProperties(userId, guid, "guid", OpenMetadataType.GLOSSARY_TERM.typeName, assetManagerGUID, assetManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName));
        }
        return glossaryTerm;
    }

    public List<GlossaryTermElement> getGlossaryTermHistory(String userId, String assetManagerGUID, String assetManagerName, String guid, Date fromTime, Date toTime, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "guid";
        HistorySequencingOrder sequencingOrder = HistorySequencingOrder.BACKWARDS;
        if (oldestFirst) {
            sequencingOrder = HistorySequencingOrder.FORWARDS;
        }
        List results = this.glossaryTermHandler.getBeanHistory(userId, guid, "guid", OpenMetadataType.GLOSSARY_TERM.typeName, fromTime, toTime, startFrom, pageSize, sequencingOrder, forLineage, forDuplicateProcessing, this.glossaryTermHandler.getSupportedZones(), effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }

    public List<GlossaryTermElement> getMeanings(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = glossaryTermGUIDParameterName;
        List results = this.glossaryTermHandler.getMeanings(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.addCorrelationPropertiesToGlossaryTerms(userId, assetManagerGUID, assetManagerName, results, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return results;
    }
}

