/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class DataAssetExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataAssetExchangeRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDataAsset(String serverName, String userId, boolean assetManagerIsHome, DataAssetRequestBody requestBody) {
        String methodName = "createDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "createDataAsset");
                response.setGUID(handler.createDataAsset(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, requestBody.getElementProperties(), false, false, requestBody.getEffectiveTime(), "createDataAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDataAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataAssetFromTemplate(String serverName, String userId, boolean assetManagerIsHome, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createDataAssetFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDataAssetFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataAssetFromTemplate");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "createDataAssetFromTemplate");
                response.setGUID(handler.createDataAssetFromTemplate(userId, requestBody.getMetadataCorrelationProperties(), assetManagerIsHome, templateGUID, requestBody.getElementProperties(), "createDataAssetFromTemplate"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDataAssetFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataAssetFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataAsset(String serverName, String userId, String assetGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, DataAssetRequestBody requestBody) {
        String methodName = "updateDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "updateDataAsset");
                handler.updateDataAsset(userId, requestBody.getMetadataCorrelationProperties(), assetGUID, isMergeUpdate, requestBody.getElementProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateDataAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDataAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishDataAsset(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "publishDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "publishDataAsset");
            handler.publishDataAsset(userId, assetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "publishDataAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawDataAsset(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "withdrawDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "withdrawDataAsset");
            handler.withdrawDataAsset(userId, assetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "withdrawDataAsset");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "withdrawDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeDataAsset(String serverName, String userId, String assetGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "removeDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeDataAsset");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeDataAsset");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "removeDataAsset");
            if (requestBody != null) {
                handler.removeDataAsset(userId, requestBody.getMetadataCorrelationProperties(), assetGUID, cascadedDelete, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeDataAsset");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeDataAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setDataAssetAsReferenceData(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "setDataAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setDataAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setDataAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "setDataAssetAsReferenceData");
            if (requestBody != null) {
                handler.setDataAssetAsReferenceData(userId, assetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setDataAssetAsReferenceData");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setDataAssetAsReferenceData", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setDataAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearDataAssetAsReferenceData(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, UpdateRequestBody requestBody) {
        String methodName = "clearDataAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearDataAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearDataAssetAsReferenceData");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "clearDataAssetAsReferenceData");
            if (requestBody != null) {
                handler.clearDataAssetAsReferenceData(userId, assetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearDataAssetAsReferenceData");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearDataAssetAsReferenceData", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearDataAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupRelatedDataAsset(String serverName, String userId, boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupRelatedDataAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupRelatedDataAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupRelatedDataAsset");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "setupRelatedDataAsset");
                response.setGUID(handler.setupRelatedDataAsset(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), assetManagerIsHome, relationshipTypeName, fromAssetGUID, toAssetGUID, requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "setupRelatedDataAsset"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupRelatedDataAsset", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupRelatedDataAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementResponse getAssetRelationship(String serverName, String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetRelationship");
        RelationshipElementResponse response = new RelationshipElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetRelationship");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getAssetRelationship");
            if (requestBody != null) {
                response.setElement(handler.getAssetRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), relationshipTypeName, fromAssetGUID, toAssetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getAssetRelationship"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAssetRelationship", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAssetRelationship(String serverName, String userId, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAssetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAssetRelationship");
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "updateAssetRelationship");
                handler.updateAssetRelationship(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipTypeName, relationshipGUID, isMergeUpdate, requestBody.getProperties(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "updateAssetRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateAssetRelationship", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetRelationship(String serverName, String userId, String relationshipTypeName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAssetRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetRelationship");
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "clearAssetRelationship");
                handler.clearAssetRelationship(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), relationshipTypeName, relationshipGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearAssetRelationship");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "clearAssetRelationship", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssetRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementsResponse getRelatedAssetsAtEnd2(String serverName, String userId, String relationshipTypeName, String fromAssetGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getRelatedAssetsAtEnd2";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssetsAtEnd2");
        RelationshipElementsResponse response = new RelationshipElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssetsAtEnd2");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getRelatedAssetsAtEnd2");
                response.setElements(handler.getRelatedAssetsAtEnd2(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), relationshipTypeName, fromAssetGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getRelatedAssetsAtEnd2"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getRelatedAssetsAtEnd2", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedAssetsAtEnd2", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelationshipElementsResponse getRelatedAssetsAtEnd1(String serverName, String userId, String relationshipTypeName, String toAssetGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getRelatedAssetsAtEnd1";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssetsAtEnd1");
        RelationshipElementsResponse response = new RelationshipElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssetsAtEnd1");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getRelatedAssetsAtEnd1");
                response.setElements(handler.getRelatedAssetsAtEnd1(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), relationshipTypeName, toAssetGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getRelatedAssetsAtEnd1"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getRelatedAssetsAtEnd1", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedAssetsAtEnd1", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse findDataAssets(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findDataAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findDataAssets");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataAssets");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "findDataAssets");
                response.setElementList(handler.findDataAssets(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getSearchString(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "findDataAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findDataAssets", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse scanDataAssets(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "scanDataAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "scanDataAssets");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "scanDataAssets");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "scanDataAssets");
                response.setElementList(handler.scanDataAssets(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "scanDataAssets"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "scanDataAssets", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "scanDataAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse getDataAssetsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getDataAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetsByName");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetsByName");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetsByName");
            if (requestBody != null) {
                response.setElementList(handler.getDataAssetsByName(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), requestBody.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataAssetsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDataAssetsByName", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementsResponse getDataAssetsForAssetManager(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getDataAssetsForAssetManager";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetsForAssetManager");
        DataAssetElementsResponse response = new DataAssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetsForAssetManager");
            if (requestBody != null) {
                DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetsForAssetManager");
                response.setElementList(handler.getDataAssetsForAssetManager(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataAssetsForAssetManager"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getDataAssetsForAssetManager", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataAssetsForAssetManager", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataAssetElementResponse getDataAssetByGUID(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getDataAssetByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataAssetByGUID");
        DataAssetElementResponse response = new DataAssetElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataAssetByGUID");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "getDataAssetByGUID");
            if (requestBody != null) {
                response.setElement(handler.getDataAssetByGUID(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), assetGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataAssetByGUID"));
            } else {
                response.setElement(handler.getDataAssetByGUID(userId, null, null, assetGUID, forLineage, forDuplicateProcessing, null, "getDataAssetByGUID"));
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataAssetByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

