/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.handlers.DataAssetExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.handlers.GlossaryExchangeHandler;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindNameProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.FindAssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LevelIdentifierQueryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.RetentionClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityTagsProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class StewardshipExchangeRESTServices {
    private static final AssetManagerInstanceHandler instanceHandler = new AssetManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(StewardshipExchangeRESTServices.class), instanceHandler.getServiceName());

    public ElementStubsResponse getDataFieldClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getDataFieldClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFieldClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFieldClassifiedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getDataFieldClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierQueryProperties) {
                    LevelIdentifierQueryProperties properties = (LevelIdentifierQueryProperties)findProperties;
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataFieldClassifiedElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getDataFieldClassifiedElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierQueryProperties.class.getName(), "getDataFieldClassifiedElements");
                }
            } else {
                response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getDataFieldClassifiedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFieldClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidenceClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidenceClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "setConfidenceClassification");
                    if (requestBody.getMetadataCorrelationProperties() != null) {
                        handler.addGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setConfidenceClassification");
                    } else {
                        handler.addGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setConfidenceClassification");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidenceClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidenceClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidenceClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearConfidenceClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidenceClassification");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "clearConfidenceClassification");
            if (requestBody != null) {
                if (requestBody.getMetadataCorrelationProperties() != null) {
                    handler.removeGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearConfidenceClassification");
                } else {
                    handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearConfidenceClassification");
                }
            } else {
                handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, null, "clearConfidenceClassification");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getConfidenceClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidenceClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfidenceClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidenceClassifiedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getConfidenceClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierQueryProperties) {
                    LevelIdentifierQueryProperties properties = (LevelIdentifierQueryProperties)findProperties;
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConfidenceClassifiedElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConfidenceClassifiedElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierQueryProperties.class.getName(), "getConfidenceClassifiedElements");
                }
            } else {
                response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getConfidenceClassifiedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getConfidenceClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setCriticalityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setCriticalityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "setCriticalityClassification");
                    if (requestBody.getMetadataCorrelationProperties() != null) {
                        handler.addGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setCriticalityClassification");
                    } else {
                        handler.addGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setCriticalityClassification");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setCriticalityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setCriticalityClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCriticalityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearCriticalityClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCriticalityClassification");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "clearCriticalityClassification");
            if (requestBody != null) {
                if (requestBody.getMetadataCorrelationProperties() != null) {
                    handler.removeGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearCriticalityClassification");
                } else {
                    handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearCriticalityClassification");
                }
            } else {
                handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, null, "clearCriticalityClassification");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getCriticalityClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getCriticalityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCriticalityClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCriticalityClassifiedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getCriticalityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierQueryProperties) {
                    LevelIdentifierQueryProperties properties = (LevelIdentifierQueryProperties)findProperties;
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getCriticalityClassifiedElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getCriticalityClassifiedElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierQueryProperties.class.getName(), "getCriticalityClassifiedElements");
                }
            } else {
                response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getCriticalityClassifiedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCriticalityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidentialityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidentialityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "setConfidentialityClassification");
                    if (requestBody.getMetadataCorrelationProperties() != null) {
                        handler.addGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setConfidentialityClassification");
                    } else {
                        handler.addGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getLevelIdentifier(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setConfidentialityClassification");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidentialityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidentialityClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidentialityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearConfidentialityClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidentialityClassification");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "clearConfidentialityClassification");
            if (requestBody != null) {
                if (requestBody.getMetadataCorrelationProperties() != null) {
                    handler.removeGovernanceActionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearConfidentialityClassification");
                } else {
                    handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearConfidentialityClassification");
                }
            } else {
                handler.removeGovernanceActionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, null, "clearConfidentialityClassification");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getConfidentialityClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidentialityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfidentialityClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidentialityClassifiedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getConfidentialityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierQueryProperties) {
                    LevelIdentifierQueryProperties properties = (LevelIdentifierQueryProperties)findProperties;
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConfidentialityClassifiedElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getConfidentialityClassifiedElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierQueryProperties.class.getName(), "getConfidentialityClassifiedElements");
                }
            } else {
                response.setElements(handler.getGovernanceActionClassifiedElements(userId, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getConfidentialityClassifiedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getConfidentialityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRetentionClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setRetentionClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof RetentionClassificationProperties) {
                    RetentionClassificationProperties properties = (RetentionClassificationProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "setRetentionClassification");
                    if (requestBody.getMetadataCorrelationProperties() != null) {
                        handler.addRetentionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getRetentionBasis(), properties.getAssociatedGUID(), properties.getArchiveAfter(), properties.getDeleteAfter(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setRetentionClassification");
                    } else {
                        handler.addRetentionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getStatus(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getRetentionBasis(), properties.getAssociatedGUID(), properties.getArchiveAfter(), properties.getDeleteAfter(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "setRetentionClassification");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(RetentionClassificationProperties.class.getName(), "setRetentionClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setRetentionClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearRetentionClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearRetentionClassification";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearRetentionClassification");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "clearRetentionClassification");
            if (requestBody != null) {
                if (requestBody.getMetadataCorrelationProperties() != null) {
                    handler.removeRetentionClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearRetentionClassification");
                } else {
                    handler.removeRetentionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearRetentionClassification");
                }
            } else {
                handler.removeRetentionClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, null, "clearRetentionClassification");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getRetentionClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getRetentionClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRetentionClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRetentionClassifiedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getRetentionClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierQueryProperties) {
                    LevelIdentifierQueryProperties properties = (LevelIdentifierQueryProperties)findProperties;
                    response.setElements(handler.getRetentionClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getRetentionClassifiedElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getRetentionClassifiedElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierQueryProperties.class.getName(), "getRetentionClassifiedElements");
                }
            } else {
                response.setElements(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getRetentionClassifiedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRetentionClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addSecurityTags";
        String assetGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SecurityTagsProperties) {
                    SecurityTagsProperties properties = (SecurityTagsProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "addSecurityTags");
                    handler.addSecurityTags(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getSecurityLabels(), properties.getSecurityProperties(), properties.getAccessGroups(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addSecurityTags");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SecurityTagsProperties.class.getName(), "addSecurityTags");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeSecurityTags(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "removeSecurityTags";
        String assetGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeSecurityTags");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "removeSecurityTags");
            if (requestBody != null) {
                handler.removeSecurityTags(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeSecurityTags");
            } else {
                handler.removeSecurityTags(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, null, "removeSecurityTags");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getSecurityTaggedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getSecurityTaggedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityTaggedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityTaggedElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getSecurityTaggedElements");
            if (requestBody != null) {
                response.setElements(handler.getSecurityTagsClassifiedElements(userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getSecurityTaggedElements"));
            } else {
                response.setElements(handler.getSecurityTagsClassifiedElements(userId, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getSecurityTaggedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSecurityTaggedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOwnership(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addOwnership";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOwnership");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof OwnerProperties) {
                    OwnerProperties properties = (OwnerProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "addOwnership");
                    handler.addOwner(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getOwner(), properties.getOwnerTypeName(), properties.getOwnerPropertyName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addOwnership");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(OwnerProperties.class.getName(), "addOwnership");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addOwnership", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOwnership(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearOwnership";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearOwnership");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "clearOwnership");
            if (requestBody != null) {
                handler.removeOwner(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearOwnership");
            } else {
                handler.removeOwner(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, null, "clearOwnership");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getOwnersElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getOwnersElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOwnersElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOwnersElements");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getOwnersElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElements(handler.getOwnersElements(userId, properties.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getOwnersElements"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getOwnersElements(userId, null, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getOwnersElements"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getOwnersElements");
                }
            } else {
                response.setElements(handler.getOwnersElements(userId, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getOwnersElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getOwnersElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addAssetOrigin(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        String organizationGUIDParameter = "properties.organizationGUID";
        String businessCapabilityGUIDParameter = "properties.businessCapabilityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAssetOrigin");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof AssetOriginProperties) {
                    AssetOriginProperties properties = (AssetOriginProperties)classificationProperties;
                    DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "addAssetOrigin");
                    handler.addAssetOrigin(userId, assetGUID, "assetGUID", properties.getOrganizationGUID(), "properties.organizationGUID", properties.getBusinessCapabilityGUID(), "properties.businessCapabilityGUID", properties.getOtherOriginValues(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "addAssetOrigin");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(AssetOriginProperties.class.getName(), "addAssetOrigin");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addAssetOrigin", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetOrigin(String serverName, String userId, String assetGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearAssetOrigin";
        String elementGUIDParameter = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetOrigin");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetOrigin");
            DataAssetExchangeHandler handler = instanceHandler.getDataAssetExchangeHandler(userId, serverName, "clearAssetOrigin");
            if (requestBody != null) {
                handler.removeAssetOrigin(userId, assetGUID, "assetGUID", forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "clearAssetOrigin");
            } else {
                handler.removeAssetOrigin(userId, assetGUID, "assetGUID", forLineage, forDuplicateProcessing, null, "clearAssetOrigin");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssetOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetElementsResponse getAssetsByOrigin(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getAssetsByOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByOrigin");
        AssetElementsResponse response = new AssetElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByOrigin");
            AssetHandler<AssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByOrigin");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindAssetOriginProperties) {
                    FindAssetOriginProperties properties = (FindAssetOriginProperties)findProperties;
                    response.setElementList(handler.getAssetsFromOrigin(userId, properties.getOrganizationGUID(), properties.getBusinessCapabilityGUID(), properties.getOtherOriginValues(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getAssetsByOrigin"));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getAssetsFromOrigin(userId, null, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getAssetsByOrigin"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindAssetOriginProperties.class.getName(), "getAssetsByOrigin");
                }
            } else {
                response.setElementList(handler.getAssetsFromOrigin(userId, null, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getAssetsByOrigin"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssetsByOrigin", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addElementToSubjectArea(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addElementToSubjectArea";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addElementToSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addElementToSubjectArea");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SubjectAreaClassificationProperties) {
                    SubjectAreaClassificationProperties properties = (SubjectAreaClassificationProperties)classificationProperties;
                    SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "addElementToSubjectArea");
                    if (requestBody.getMetadataCorrelationProperties() != null) {
                        handler.addSubjectAreaClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getSubjectAreaName(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "addElementToSubjectArea");
                    } else {
                        handler.addSubjectAreaClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, properties.getSubjectAreaName(), forLineage, forDuplicateProcessing, properties.getEffectiveFrom(), properties.getEffectiveTo(), requestBody.getEffectiveTime(), "addElementToSubjectArea");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaClassificationProperties.class.getName(), "addElementToSubjectArea");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addElementToSubjectArea", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addElementToSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeElementFromSubjectArea(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "removeElementFromSubjectArea";
        String elementGUIDParameter = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeElementFromSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementFromSubjectArea");
            SoftwareCapabilityHandler<SoftwareCapabilityElement> handler = instanceHandler.getAssetManagerHandler(userId, serverName, "removeElementFromSubjectArea");
            if (requestBody == null) {
                handler.removeSubjectAreaClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, null, "removeElementFromSubjectArea");
            } else if (requestBody.getMetadataCorrelationProperties() == null) {
                handler.removeSubjectAreaClassification(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeElementFromSubjectArea");
            } else {
                handler.removeSubjectAreaClassification(userId, requestBody.getMetadataCorrelationProperties().getExternalScopeGUID(), requestBody.getMetadataCorrelationProperties().getExternalScopeName(), elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "removeElementFromSubjectArea");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeElementFromSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getMembersOfSubjectArea(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getMembersOfSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMembersOfSubjectArea");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMembersOfSubjectArea");
            ReferenceableHandler<ElementStub> handler = instanceHandler.getElementStubHandler(userId, serverName, "getMembersOfSubjectArea");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElements(handler.getSubjectAreaMembers(userId, properties.getName(), startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getMembersOfSubjectArea"));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getSubjectAreaMembers(userId, null, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getMembersOfSubjectArea"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getMembersOfSubjectArea");
                }
            } else {
                response.setElements(handler.getSubjectAreaMembers(userId, null, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getMembersOfSubjectArea"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMembersOfSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getMeanings(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeanings");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeanings");
            GlossaryExchangeHandler handler = instanceHandler.getGlossaryExchangeHandler(userId, serverName, "getMeanings");
            if (requestBody == null) {
                response.setElementList(handler.getMeanings(userId, null, null, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getMeanings"));
            } else {
                response.setElementList(handler.getMeanings(userId, requestBody.getAssetManagerGUID(), requestBody.getAssetManagerName(), elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getMeanings"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSemanticAssignees(String serverName, String userId, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSemanticAssignees";
        String elementGUIDParameterName = "glossaryTermGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSemanticAssignees");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSemanticAssignees");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSemanticAssignees");
            if (requestBody == null) {
                response.setElements(handler.getSemanticAssignments(userId, glossaryTermGUID, "glossaryTermGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getSemanticAssignees"));
            } else {
                response.setElements(handler.getSemanticAssignments(userId, glossaryTermGUID, "glossaryTermGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getSemanticAssignees"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSemanticAssignees", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getGovernedElements(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedElements";
        String elementGUIDParameterName = "governanceDefinitionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getGovernedElements");
            if (requestBody == null) {
                response.setElements(handler.getGovernedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getGovernedElements"));
            } else {
                response.setElements(handler.getGovernedElements(userId, governanceDefinitionGUID, "governanceDefinitionGUID", OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGovernedElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getGovernedByDefinitions(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedByDefinitions";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedByDefinitions");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedByDefinitions");
            GovernanceDefinitionHandler<GovernanceDefinitionElement> handler = instanceHandler.getGovernanceDefinitionHandler(userId, serverName, "getGovernedByDefinitions");
            if (requestBody == null) {
                response.setElements(handler.getGoverningDefinitions(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getGovernedByDefinitions"));
            } else {
                response.setElements(handler.getGoverningDefinitions(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getGovernedByDefinitions"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGovernedByDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSourceElements(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSourceElements";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSourceElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceElements");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getSourceElements");
            if (requestBody == null) {
                response.setElements(handler.getSourceElements(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getSourceElements"));
            } else {
                response.setElements(handler.getSourceElements(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getSourceElements"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSourceElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getElementsSourceFrom(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getElementsSourceFrom";
        String elementGUIDParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsSourceFrom");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsSourceFrom");
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getElementsSourceFrom");
            if (requestBody == null) {
                response.setElements(handler.getElementsSourceFrom(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, null, "getElementsSourceFrom"));
            } else {
                response.setElements(handler.getElementsSourceFrom(userId, elementGUID, "elementGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime(), "getElementsSourceFrom"));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getElementsSourceFrom", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

