/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.DataAssetExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-manager/"))
public class DataAssetExchangeResource {
    private DataAssetExchangeRESTServices restAPI = new DataAssetExchangeRESTServices();

    @PostMapping(path={"/data-assets"})
    public GUIDResponse createAsset(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody AssetRequestBody requestBody) {
        return this.restAPI.createAsset(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/data-assets/from-template/{templateGUID}"})
    public GUIDResponse createAssetFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createAssetFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}"})
    public VoidResponse updateAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam boolean isMergeUpdate, @RequestBody AssetRequestBody requestBody) {
        return this.restAPI.updateAsset(serverName, userId, assetGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/publish"})
    public VoidResponse publishAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.publishAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/withdraw"})
    public VoidResponse withdrawAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.withdrawAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/remove"})
    public VoidResponse removeAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeAsset(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/is-reference-data"})
    public VoidResponse setAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/is-reference-data/remove"})
    public VoidResponse clearAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/data-assets/by-search-string"})
    public AssetElementsResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findAssets(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-assets/by-name"})
    public AssetElementsResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getAssetsByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-assets/by-asset-manager"})
    public AssetElementsResponse getAssetsForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getAssetsForAssetManager(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-assets/{assetGUID}/retrieve"})
    public AssetElementResponse getAssetByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getAssetByGUID(serverName, userId, assetGUID, requestBody);
    }
}

