/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalReferenceRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.ExternalReferenceExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-manager/overview"))
public class ExternalReferenceExchangeResource {
    private ExternalReferenceExchangeRESTServices restAPI = new ExternalReferenceExchangeRESTServices();

    @PostMapping(path={"/external-references"})
    public GUIDResponse createExternalReference(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody ExternalReferenceRequestBody requestBody) {
        return this.restAPI.createExternalReference(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}"})
    public VoidResponse updateExternalReference(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestParam boolean isMergeUpdate, @RequestBody ExternalReferenceRequestBody requestBody) {
        return this.restAPI.updateExternalReference(serverName, userId, externalReferenceGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}/remove"})
    public VoidResponse deleteExternalReference(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.deleteExternalReference(serverName, userId, externalReferenceGUID, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}/links/{attachedToGUID}"})
    public GUIDResponse linkExternalReferenceToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String attachedToGUID, @PathVariable String externalReferenceGUID, @RequestParam boolean assetManagerIsHome, @RequestBody ExternalReferenceLinkRequestBody requestBody) {
        return this.restAPI.linkExternalReferenceToElement(serverName, userId, assetManagerIsHome, attachedToGUID, externalReferenceGUID, requestBody);
    }

    @PostMapping(path={"/external-references/links/{externalReferenceLinkGUID}/update"})
    public VoidResponse updateExternalReferenceToElementLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceLinkGUID, @RequestBody ExternalReferenceLinkRequestBody requestBody) {
        return this.restAPI.updateExternalReferenceToElementLink(serverName, userId, externalReferenceLinkGUID, requestBody);
    }

    @PostMapping(path={"/external-references/links/{externalReferenceLinkGUID}/remove"})
    public VoidResponse unlinkExternalReferenceFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceLinkGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.unlinkExternalReferenceFromElement(serverName, userId, externalReferenceLinkGUID, requestBody);
    }

    @PostMapping(path={"/external-references/by-type"})
    public ExternalReferenceElementsResponse getExternalReferences(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalReferences(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-resource-id"})
    public ExternalReferenceElementsResponse getExternalReferencesById(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getExternalReferencesById(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-url"})
    public ExternalReferenceElementsResponse getExternalReferencesByURL(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getExternalReferencesByURL(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-name"})
    public ExternalReferenceElementsResponse getExternalReferencesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getExternalReferencesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-asset-manager"})
    public ExternalReferenceElementsResponse getExternalReferencesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalReferencesForAssetManager(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/by-search-string"})
    public ExternalReferenceElementsResponse findExternalReferences(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findExternalReferences(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/attached-to/{attachedToGUID}"})
    public ExternalReferenceLinkElementsResponse retrieveAttachedExternalReferences(@PathVariable String serverName, @PathVariable String userId, @PathVariable String attachedToGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.retrieveAttachedExternalReferences(serverName, userId, attachedToGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/external-references/{externalReferenceGUID}/by-guid"})
    public ExternalReferenceElementResponse getExternalReferenceByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalReferenceGUID, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalReferenceByGUID(serverName, userId, externalReferenceGUID, requestBody);
    }
}

