/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementHeadersResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.AssetManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-manager/overview"))
public class AssetManagerOMASResource {
    private final AssetManagerRESTServices restAPI = new AssetManagerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/asset-managers"})
    public GUIDResponse createExternalAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestBody AssetManagerProperties assetManagerProperties) {
        return this.restAPI.createExternalAssetManager(serverName, userId, assetManagerProperties);
    }

    @GetMapping(path={"/asset-managers/by-name/{qualifiedName}"})
    public GUIDResponse getExternalAssetManagerGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getExternalAssetManagerGUID(serverName, userId, qualifiedName);
    }

    @PostMapping(path={"/asset-managers/elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/add"})
    public VoidResponse addExternalIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.addExternalIdentifier(serverName, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/asset-managers/elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/update"})
    public VoidResponse updateExternalIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.updateExternalIdentifier(serverName, userId, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/asset-managers/elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/remove"})
    public VoidResponse removeExternalIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.removeExternalIdentifier(serverName, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/asset-managers/elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers"})
    public VoidResponse confirmSynchronization(@PathVariable String serverName, @PathVariable String userId, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.confirmSynchronization(serverName, userId, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/asset-managers/external-identifiers/open-metadata-elements"})
    public ElementHeadersResponse getElementsForExternalIdentifier(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.getElementsForExternalIdentifier(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

