/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ActivityTermClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CanonicalVocabularyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CategorizationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ContextDefinitionClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryElementLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ExternalGlossaryLinkRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TaxonomyClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.GlossaryExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-manager/"))
public class GlossaryExchangeResource {
    private GlossaryExchangeRESTServices restAPI = new GlossaryExchangeRESTServices();

    @PostMapping(path={"/glossaries"})
    public GUIDResponse createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody GlossaryRequestBody requestBody) {
        return this.restAPI.createGlossary(serverName, userId, requestBody);
    }

    @PostMapping(path={"/glossaries/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}"})
    public VoidResponse updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody GlossaryRequestBody requestBody) {
        return this.restAPI.updateGlossary(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/remove"})
    public VoidResponse removeGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeGlossary(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy"})
    public VoidResponse setGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody TaxonomyClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsTaxonomy(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy/remove"})
    public VoidResponse clearGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearGlossaryAsTaxonomy(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical"})
    public VoidResponse setGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody CanonicalVocabularyClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsCanonical(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical/remove"})
    public VoidResponse clearGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearGlossaryAsCanonical(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/by-search-string"})
    public GlossaryElementsResponse findGlossaries(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaries(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/by-name"})
    public GlossaryElementsResponse getGlossariesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossariesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/by-asset-manager"})
    public GlossaryElementsResponse getGlossariesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossariesForAssetManager(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/retrieve"})
    public GlossaryElementResponse getGlossaryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossaryByGUID(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories"})
    public GUIDResponse createGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody GlossaryCategoryRequestBody requestBody) {
        return this.restAPI.createGlossaryCategory(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryCategoryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategoryFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}"})
    public VoidResponse updateGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestBody GlossaryCategoryRequestBody requestBody) {
        return this.restAPI.updateGlossaryCategory(serverName, userId, glossaryCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}"})
    public VoidResponse setupCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}/remove"})
    public VoidResponse clearCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/remove"})
    public VoidResponse removeGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeGlossaryCategory(serverName, userId, glossaryCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-search-string"})
    public GlossaryCategoryElementsResponse findGlossaryCategories(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryCategories(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/retrieve"})
    public GlossaryCategoryElementsResponse getCategoriesForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getCategoriesForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-name"})
    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoriesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/retrieve"})
    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryByGUID(serverName, userId, glossaryCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/parent/retrieve"})
    public GlossaryCategoryElementResponse getGlossaryCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryParent(serverName, userId, glossaryCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/subcategories/retrieve"})
    public GlossaryCategoryElementsResponse getGlossarySubCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossarySubCategories(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms"})
    public GUIDResponse createGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody GlossaryTermRequestBody requestBody) {
        return this.restAPI.createGlossaryTerm(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/new-controlled"})
    public GUIDResponse createControlledGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestBody ControlledGlossaryTermRequestBody requestBody) {
        return this.restAPI.createControlledGlossaryTerm(serverName, userId, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryTermFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}"})
    public VoidResponse updateGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody GlossaryTermRequestBody requestBody) {
        return this.restAPI.updateGlossaryTerm(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/status"})
    public VoidResponse updateGlossaryTermStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody GlossaryTermStatusRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermStatus(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}"})
    public VoidResponse setupTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestBody CategorizationRequestBody requestBody) {
        return this.restAPI.setupTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}"})
    public VoidResponse setupTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestBody TermRelationshipRequestBody requestBody) {
        return this.restAPI.setupTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/update"})
    public VoidResponse updateTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestBody TermRelationshipRequestBody requestBody) {
        return this.restAPI.updateTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/remove"})
    public VoidResponse clearTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept"})
    public VoidResponse setTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setTermAsAbstractConcept(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept/remove"})
    public VoidResponse clearTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsAbstractConcept(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value"})
    public VoidResponse setTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setTermAsDataValue(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value/remove"})
    public VoidResponse clearTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsDataValue(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity"})
    public VoidResponse setTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody ActivityTermClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsActivity(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity/remove"})
    public VoidResponse clearTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsActivity(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition"})
    public VoidResponse setTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody ContextDefinitionClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsContext(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition/remove"})
    public VoidResponse clearTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsContext(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object"})
    public VoidResponse setTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setTermAsSpineObject(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object/remove"})
    public VoidResponse clearTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsSpineObject(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute"})
    public VoidResponse setTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setTermAsSpineAttribute(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute/remove"})
    public VoidResponse clearTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsSpineAttribute(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier"})
    public VoidResponse setTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.setTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier/remove"})
    public VoidResponse clearTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/remove"})
    public VoidResponse removeGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeGlossaryTerm(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-search-string"})
    public GlossaryTermElementsResponse findGlossaryTerms(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryTerms(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getTermsForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getTermsForGlossaryCategory(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-name"})
    public GlossaryTermElementsResponse getGlossaryTermsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossaryTermsByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/retrieve"})
    public GlossaryTermElementResponse getGlossaryTermByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossaryTermByGUID(serverName, userId, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links"})
    public GUIDResponse createExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @RequestBody ExternalGlossaryLinkRequestBody requestBody) {
        return this.restAPI.createExternalGlossaryLink(serverName, userId, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}"})
    public VoidResponse updateExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestBody ExternalGlossaryLinkRequestBody requestBody) {
        return this.restAPI.updateExternalGlossaryLink(serverName, userId, externalLinkGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}/remove"})
    public VoidResponse removeExternalGlossaryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.removeExternalGlossaryLink(serverName, userId, externalLinkGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalLinkToGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String externalLinkGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.attachExternalLinkToGlossary(serverName, userId, glossaryGUID, externalLinkGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalLinkFromGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.detachExternalLinkFromGlossary(serverName, userId, externalLinkGUID, glossaryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/external-links/retrieve"})
    public ExternalGlossaryLinkElementsResponse getExternalLinksForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getExternalLinksForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/glossaries/external-links/{externalLinkGUID}/retrieve"})
    public GlossaryElementsResponse getGlossariesForExternalLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getGlossariesForExternalLink(serverName, userId, externalLinkGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalCategoryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String externalLinkGUID, @RequestBody ExternalGlossaryElementLinkRequestBody requestBody) {
        return this.restAPI.attachExternalCategoryLink(serverName, userId, glossaryCategoryGUID, externalLinkGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalCategoryLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryCategoryGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.detachExternalCategoryLink(serverName, userId, externalLinkGUID, glossaryCategoryGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/external-links/{externalLinkGUID}"})
    public VoidResponse attachExternalTermLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryTermGUID, @RequestBody ExternalGlossaryElementLinkRequestBody requestBody) {
        return this.restAPI.attachExternalTermLink(serverName, userId, externalLinkGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/external-links/{externalLinkGUID}/remove"})
    public VoidResponse detachExternalTermLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String externalLinkGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.detachExternalTermLink(serverName, userId, externalLinkGUID, glossaryTermGUID, requestBody);
    }
}

