/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.server.GovernanceExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/asset-manager/overview/"))
public class GovernanceExchangeResource {
    private GovernanceExchangeRESTServices restAPI = new GovernanceExchangeRESTServices();

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, userId, processGUID);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    public GovernanceActionTypeElementsResponse findGovernanceActionTypes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    public GovernanceActionTypeElementsResponse getGovernanceActionTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{actionTypeGUID}"})
    public GovernanceActionTypeElementResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, userId, actionTypeGUID);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}/first-action-type"})
    public GovernanceActionTypeElementResponse getFirstActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getFirstActionType(serverName, userId, processGUID);
    }

    @GetMapping(path={"/governance-action-types/{actionTypeGUID}/next-action-type"})
    public NextGovernanceActionTypeElementsResponse getNextGovernanceActionTypes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNextGovernanceActionTypes(serverName, userId, actionTypeGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-actions/{governanceActionGUID}"})
    public GovernanceActionElementResponse getGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID) {
        return this.restAPI.getGovernanceAction(serverName, userId, governanceActionGUID);
    }

    @GetMapping(path={"/governance-actions"})
    public GovernanceActionElementsResponse getGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceActions(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-actions/active"})
    public GovernanceActionElementsResponse getActiveGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveGovernanceActions(serverName, userId, startFrom, pageSize);
    }
}

