/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.AssetManagerIdentifiersRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ControlFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.DataFlowRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.LineageMappingElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NameRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.PortRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessCallRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessContainmentTypeRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ProcessStatusRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.SearchStringRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.server.LineageExchangeRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-manager/users/{userId}"})
@Tag(name="Asset Manager OMAS", description="The Asset Manager OMAS provides APIs and events for managing metadata exchange with third party asset managers, such as data catalogs.", externalDocs=@ExternalDocumentation(description="Asset Manager Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/asset-manager/overview"))
public class LineageExchangeResource {
    private LineageExchangeRESTServices restAPI = new LineageExchangeRESTServices();

    @PostMapping(path={"/processes"})
    public GUIDResponse createProcess(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @RequestBody ProcessRequestBody requestBody) {
        return this.restAPI.createProcess(serverName, userId, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/processes/from-template/{templateGUID}"})
    public GUIDResponse createProcessFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam boolean assetManagerIsHome, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createProcessFromTemplate(serverName, userId, assetManagerIsHome, templateGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}"})
    public VoidResponse updateProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam boolean isMergeUpdate, @RequestBody ProcessRequestBody requestBody) {
        return this.restAPI.updateProcess(serverName, userId, processGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/status"})
    public VoidResponse updateProcessStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody ProcessStatusRequestBody requestBody) {
        return this.restAPI.updateProcessStatus(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/parent/{parentProcessGUID}/child/{childProcessGUID}"})
    public VoidResponse setupProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentProcessGUID, @PathVariable String childProcessGUID, @RequestParam boolean assetManagerIsHome, @RequestBody ProcessContainmentTypeRequestBody requestBody) {
        return this.restAPI.setupProcessParent(serverName, userId, parentProcessGUID, childProcessGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/processes/parent/{parentProcessGUID}/child/{childProcessGUID}/remove"})
    public VoidResponse clearProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentProcessGUID, @PathVariable String childProcessGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearProcessParent(serverName, userId, parentProcessGUID, childProcessGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/publish"})
    public VoidResponse publishProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.publishProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/withdraw"})
    public VoidResponse withdrawProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.withdrawProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/remove"})
    public VoidResponse removeProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.removeProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/by-search-string"})
    public ProcessElementsResponse findProcesses(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findProcesses(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/processes/by-asset-manager"})
    public ProcessElementsResponse getProcessesForAssetManager(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getProcessesForAssetManager(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/processes/by-name"})
    public ProcessElementsResponse getProcessesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getProcessesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/retrieve"})
    public ProcessElementResponse getProcessByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getProcessByGUID(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/parent/retrieve"})
    public ProcessElementResponse getProcessParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getProcessParent(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/children/retrieve"})
    public ProcessElementsResponse getSubProcesses(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSubProcesses(serverName, userId, processGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports"})
    public GUIDResponse createPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam boolean assetManagerIsHome, @RequestBody PortRequestBody requestBody) {
        return this.restAPI.createPort(serverName, userId, assetManagerIsHome, processGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/update"})
    public VoidResponse updatePort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestBody PortRequestBody requestBody) {
        return this.restAPI.updatePort(serverName, userId, portGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/{portGUID}"})
    public VoidResponse setupProcessPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String portGUID, @RequestParam boolean assetManagerIsHome, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupProcessPort(serverName, userId, assetManagerIsHome, processGUID, portGUID, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/{portGUID}/remove"})
    public VoidResponse clearProcessPort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String portGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearProcessPort(serverName, userId, processGUID, portGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portOneGUID}/port-delegations/{portTwoGUID}"})
    public VoidResponse setupPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portOneGUID, @PathVariable String portTwoGUID, @RequestParam boolean assetManagerIsHome, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupPortDelegation(serverName, userId, assetManagerIsHome, portOneGUID, portTwoGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portOneGUID}/port-delegations/{portTwoGUID}/remove"})
    public VoidResponse clearPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portOneGUID, @PathVariable String portTwoGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearPortDelegation(serverName, userId, portOneGUID, portTwoGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/schema-type/{schemaTypeGUID}"})
    public VoidResponse setupPortSchemaType(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean assetManagerIsHome, @PathVariable String portGUID, @PathVariable String schemaTypeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupPortSchemaType(serverName, userId, assetManagerIsHome, portGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/schema-type/{schemaTypeGUID}/remove"})
    public VoidResponse clearPortSchemaType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @PathVariable String schemaTypeGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearPortSchemaType(serverName, userId, portGUID, schemaTypeGUID, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/remove"})
    public VoidResponse removePort(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.removePort(serverName, userId, portGUID, requestBody);
    }

    @PostMapping(path={"/ports/by-search-string"})
    public PortElementsResponse findPorts(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findPorts(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/processes/{processGUID}/ports/retrieve"})
    public PortElementsResponse getPortsForProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getPortsForProcess(serverName, userId, processGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/used-by/retrieve"})
    public PortElementsResponse getPortUse(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getPortUse(serverName, userId, portGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/port-delegations/retrieve"})
    public PortElementResponse getPortDelegation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getPortDelegation(serverName, userId, portGUID, requestBody);
    }

    @PostMapping(path={"/ports/by-name"})
    public PortElementsResponse getPortsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPortsByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/ports/{portGUID}/retrieve"})
    public PortElementResponse getPortByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String portGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getPortByGUID(serverName, userId, portGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/is-business-significant"})
    public VoidResponse setBusinessSignificant(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.setBusinessSignificant(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/is-business-significant/remove"})
    public VoidResponse clearBusinessSignificant(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.clearBusinessSignificant(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}"})
    public GUIDResponse setupDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestParam boolean assetManagerIsHome, @RequestBody DataFlowRequestBody requestBody) {
        return this.restAPI.setupDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/{dataConsumerGUID}/retrieve"})
    public DataFlowElementResponse getDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @PathVariable String dataConsumerGUID, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getDataFlow(serverName, userId, dataSupplierGUID, dataConsumerGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/update"})
    public VoidResponse updateDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestBody DataFlowRequestBody requestBody) {
        return this.restAPI.updateDataFlow(serverName, userId, dataFlowGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/{dataFlowGUID}/remove"})
    public VoidResponse clearDataFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataFlowGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearDataFlow(serverName, userId, dataFlowGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/suppliers/{dataSupplierGUID}/consumers/retrieve"})
    public DataFlowElementsResponse getDataFlowConsumers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataSupplierGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getDataFlowConsumers(serverName, userId, dataSupplierGUID, requestBody);
    }

    @PostMapping(path={"/data-flows/consumers/{dataConsumerGUID}/suppliers/retrieve"})
    public DataFlowElementsResponse getDataFlowSuppliers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String dataConsumerGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getDataFlowSuppliers(serverName, userId, dataConsumerGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}"})
    public GUIDResponse setupControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestParam boolean assetManagerIsHome, @RequestBody ControlFlowRequestBody requestBody) {
        return this.restAPI.setupControlFlow(serverName, userId, currentStepGUID, nextStepGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/{nextStepGUID}/retrieve"})
    public ControlFlowElementResponse getControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @PathVariable String nextStepGUID, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getControlFlow(serverName, userId, currentStepGUID, nextStepGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/update"})
    public VoidResponse updateControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestBody ControlFlowRequestBody requestBody) {
        return this.restAPI.updateControlFlow(serverName, userId, controlFlowGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/{controlFlowGUID}/remove"})
    public VoidResponse clearControlFlow(@PathVariable String serverName, @PathVariable String userId, @PathVariable String controlFlowGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearControlFlow(serverName, userId, controlFlowGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/next-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowNextSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getControlFlowNextSteps(serverName, userId, currentStepGUID, requestBody);
    }

    @PostMapping(path={"/control-flows/current-steps/{currentStepGUID}/previous-steps/retrieve"})
    public ControlFlowElementsResponse getControlFlowPreviousSteps(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentStepGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getControlFlowPreviousSteps(serverName, userId, currentStepGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}"})
    public GUIDResponse setupProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestParam boolean assetManagerIsHome, @RequestBody ProcessCallRequestBody requestBody) {
        return this.restAPI.setupProcessCall(serverName, userId, callerGUID, calledGUID, assetManagerIsHome, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/{calledGUID}/retrieve"})
    public ProcessCallElementResponse getProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @PathVariable String calledGUID, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getProcessCall(serverName, userId, callerGUID, calledGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/update"})
    public VoidResponse updateProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestBody ProcessCallRequestBody requestBody) {
        return this.restAPI.updateProcessCall(serverName, userId, processCallGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/{processCallGUID}/remove"})
    public VoidResponse clearProcessCall(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processCallGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearProcessCall(serverName, userId, processCallGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/callers/{callerGUID}/called/retrieve"})
    public ProcessCallElementsResponse getProcessCalled(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getProcessCalled(serverName, userId, callerGUID, requestBody);
    }

    @PostMapping(path={"/process-calls/called/{calledGUID}/callers/retrieve"})
    public ProcessCallElementsResponse getProcessCallers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String calledGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getProcessCallers(serverName, userId, calledGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}"})
    public VoidResponse setupLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.setupLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/{destinationElementGUID}/remove"})
    public VoidResponse clearLineageMapping(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @PathVariable String destinationElementGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.clearLineageMapping(serverName, userId, sourceElementGUID, destinationElementGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/sources/{sourceElementGUID}/destinations/retrieve"})
    public LineageMappingElementsResponse getDestinationLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String sourceElementGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getDestinationLineageMappings(serverName, userId, sourceElementGUID, requestBody);
    }

    @PostMapping(path={"/lineage-mappings/destinations/{destinationElementGUID}/sources/retrieve"})
    public LineageMappingElementsResponse getSourceLineageMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String destinationElementGUID, @RequestBody AssetManagerIdentifiersRequestBody requestBody) {
        return this.restAPI.getSourceLineageMappings(serverName, userId, destinationElementGUID, requestBody);
    }
}

